/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class ImageCache {
    public static final int DISABLE = 0;
    public static final int GRAY = 1;
    public static final int REGULAR = 2;
    private static final int TYPES_OF_IMAGES = 3;
    private final ReferenceCleanerThread imageCleaner;
    private final Map imageMap;
    private final ReferenceQueue imageReferenceQueue;
    private Image missingImage = null;
    private StaleImages staleImages;

    public ImageCache() {
        this.imageMap = Collections.synchronizedMap(new HashMap());
        this.staleImages = new StaleImages();
        this.imageReferenceQueue = new ReferenceQueue();
        this.imageCleaner = new ReferenceCleanerThread(this);
        this.imageCleaner.start();
    }

    public ImageCache(int initialLoadCapacity) {
        this.imageMap = initialLoadCapacity < 0 ? Collections.synchronizedMap(new HashMap()) : Collections.synchronizedMap(new HashMap(initialLoadCapacity));
        this.staleImages = new StaleImages();
        this.imageReferenceQueue = new ReferenceQueue();
        this.imageCleaner = new ReferenceCleanerThread(this);
        this.imageCleaner.start();
    }

    public ImageCache(int initialLoadCapacity, float loadFactor) {
        this.imageMap = initialLoadCapacity < 0 || loadFactor <= 0.0f ? Collections.synchronizedMap(new HashMap()) : Collections.synchronizedMap(new HashMap(initialLoadCapacity, loadFactor));
        this.staleImages = new StaleImages();
        this.imageReferenceQueue = new ReferenceQueue();
        this.imageCleaner = new ReferenceCleanerThread(this);
        this.imageCleaner.start();
    }

    private Image addNewEquivalenceSet(ImageDescriptor imageDescriptor, EquivalenceSet equivalenceKey, int typeOfImage) {
        Image[] images = new Image[3];
        images[2] = imageDescriptor.createImage(false);
        if (images[2] == null) {
            equivalenceKey.clear();
            return this.getMissingImage();
        }
        if (typeOfImage == 0) {
            images[typeOfImage] = new Image(null, images[2], 1);
        } else if (typeOfImage == 1) {
            images[typeOfImage] = new Image(null, images[2], 2);
        }
        ImageMapEntry mapEntry = new ImageMapEntry(equivalenceKey, images);
        this.imageMap.put(equivalenceKey, mapEntry);
        return images[typeOfImage];
    }

    public final void dispose() {
        if (this.missingImage != null && !this.missingImage.isDisposed()) {
            this.missingImage.dispose();
            this.missingImage = null;
        }
        this.imageCleaner.stopCleaning();
        try {
            this.imageCleaner.join();
        }
        catch (InterruptedException interruptedException) {}
        Iterator imageItr = this.imageMap.entrySet().iterator();
        while (imageItr.hasNext()) {
            Map.Entry entry = imageItr.next();
            EquivalenceSet key = (EquivalenceSet)entry.getKey();
            Image[] images = ((ImageMapEntry)entry.getValue()).getImages();
            int i = 0;
            while (i < images.length) {
                Image image = images[i];
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                ++i;
            }
            key.clear();
        }
        this.imageMap.clear();
        this.staleImages.disposeStaleImages();
    }

    public final Image getImage(ImageDescriptor imageDescriptor) {
        return this.getImage(imageDescriptor, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage(ImageDescriptor imageDescriptor, int typeOfImage) {
        if (imageDescriptor == null) {
            return null;
        }
        if (typeOfImage < 0 || typeOfImage >= 3) {
            return null;
        }
        ImageCacheWeakReference referencedToAdd = new ImageCacheWeakReference(imageDescriptor, this.imageReferenceQueue);
        EquivalenceSet temporaryKey = new EquivalenceSet(referencedToAdd);
        Image imageToReturn = null;
        Map map = this.imageMap;
        synchronized (map) {
            ImageMapEntry mapEntry = (ImageMapEntry)this.imageMap.get(temporaryKey);
            imageToReturn = mapEntry != null ? this.getImageFromEquivalenceSet(imageDescriptor, mapEntry, referencedToAdd, typeOfImage) : this.addNewEquivalenceSet(imageDescriptor, temporaryKey, typeOfImage);
        }
        return imageToReturn;
    }

    private Image getImageFromEquivalenceSet(ImageDescriptor imageDescriptor, ImageMapEntry mapEntry, ImageCacheWeakReference referenceToAdd, int typeOfImage) {
        Image[] images = mapEntry.getImages();
        EquivalenceSet equivalenceKey = mapEntry.getEquivalenceSet();
        boolean added = equivalenceKey.addWeakReference(referenceToAdd);
        if (!added) {
            referenceToAdd.clear();
        }
        if (images[typeOfImage] != null) {
            return images[typeOfImage];
        }
        if (images[2] == null) {
            throw new NullPointerException("The normal image from the equivalence set should not be null.");
        }
        if (typeOfImage == 1) {
            images[typeOfImage] = new Image(null, images[2], 2);
        } else if (typeOfImage == 0) {
            images[typeOfImage] = new Image(null, images[2], 1);
        }
        return images[typeOfImage];
    }

    public final Image getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    private static final class EquivalenceSet {
        private final int equivalenceHashCode;
        private final ArrayList imageCacheWeakReferences = new ArrayList();

        EquivalenceSet(ImageCacheWeakReference referenceToAdd) {
            this.imageCacheWeakReferences.add(referenceToAdd);
            this.equivalenceHashCode = referenceToAdd.getCachedHashCode();
        }

        public boolean addWeakReference(ImageCacheWeakReference referenceToAdd) {
            ImageCacheWeakReference weakReference = null;
            Iterator i = this.imageCacheWeakReferences.iterator();
            while (i.hasNext()) {
                weakReference = (ImageCacheWeakReference)i.next();
                if (referenceToAdd.get() != weakReference.get()) continue;
                return false;
            }
            this.imageCacheWeakReferences.add(referenceToAdd);
            return true;
        }

        public void clear() {
            ImageCacheWeakReference currentReference = null;
            Iterator i = this.imageCacheWeakReferences.iterator();
            while (i.hasNext()) {
                currentReference = (ImageCacheWeakReference)i.next();
                if (currentReference == null) continue;
                currentReference.clear();
            }
            this.imageCacheWeakReferences.clear();
        }

        public boolean equals(Object object) {
            ImageDescriptor reachableDescriptor = null;
            if (!(object instanceof EquivalenceSet)) {
                return false;
            }
            reachableDescriptor = ((EquivalenceSet)object).getFirstReachableDescriptor();
            if (reachableDescriptor == null) {
                return false;
            }
            return reachableDescriptor.equals(this.getFirstReachableDescriptor());
        }

        public ImageDescriptor getFirstReachableDescriptor() {
            ImageDescriptor referent = null;
            Iterator i = this.imageCacheWeakReferences.iterator();
            while (i.hasNext()) {
                referent = (ImageDescriptor)((ImageCacheWeakReference)i.next()).get();
                if (referent == null) continue;
                return referent;
            }
            return null;
        }

        public int getSize() {
            return this.imageCacheWeakReferences.size();
        }

        public int hashCode() {
            return this.equivalenceHashCode;
        }

        public boolean removeReference(ImageCacheWeakReference referenceToRemove) {
            return this.imageCacheWeakReferences.remove(referenceToRemove);
        }
    }

    private static final class ImageCacheWeakReference
    extends WeakReference {
        private final int referentHashCode;

        public ImageCacheWeakReference(Object referent, ReferenceQueue queue) {
            super(referent, queue);
            this.referentHashCode = referent.hashCode();
        }

        public int getCachedHashCode() {
            return this.referentHashCode;
        }
    }

    private static final class ImageMapEntry {
        private final Image[] entryImages;
        private final EquivalenceSet entrySet;

        public ImageMapEntry(EquivalenceSet equivalenceSet, Image[] images) {
            this.entrySet = equivalenceSet;
            this.entryImages = images;
        }

        public EquivalenceSet getEquivalenceSet() {
            return this.entrySet;
        }

        public Image[] getImages() {
            return this.entryImages;
        }
    }

    private static class ReferenceCleanerThread
    extends Thread {
        private static int threads = 0;
        private final ImageCacheWeakReference endMarker;
        private final Map imageMap;
        private final ReferenceQueue referenceQueue;
        private final StaleImages staleImages;

        ReferenceCleanerThread(ImageCache imageCache) {
            super("Reference Cleaner: " + ++threads);
            this.referenceQueue = imageCache.imageReferenceQueue;
            this.imageMap = imageCache.imageMap;
            this.endMarker = new ImageCacheWeakReference(this.referenceQueue, this.referenceQueue);
            this.staleImages = imageCache.staleImages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeReferenceEnqueued(ImageCacheWeakReference currentReference) {
            EquivalenceSet currentSet = null;
            Set keySet = this.imageMap.keySet();
            Image[] images = null;
            Map map = this.imageMap;
            synchronized (map) {
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    currentSet = (EquivalenceSet)i.next();
                    boolean removed = currentSet.removeReference(currentReference);
                    if (!removed) continue;
                    if (currentSet.getSize() != 0 || (images = ((ImageMapEntry)this.imageMap.remove(currentSet)).getImages()) != null) break;
                    throw new NullPointerException("The array of images removed from the map on clean up should not be null.");
                }
            }
            if (images != null) {
                this.staleImages.addImagesToDispose(images);
                Display display = Display.getDefault();
                if (display != null) {
                    display.asyncExec(new Runnable(this){
                        final /* synthetic */ ReferenceCleanerThread this$1;
                        {
                            this.this$1 = referenceCleanerThread;
                        }

                        public void run() {
                            ReferenceCleanerThread.access$0(this.this$1).disposeStaleImages();
                        }
                    });
                }
            }
        }

        public final void run() {
            while (true) {
                Reference reference = null;
                try {
                    reference = this.referenceQueue.remove();
                }
                catch (InterruptedException interruptedException) {}
                if (reference == this.endMarker) break;
                if (reference instanceof ImageCacheWeakReference) {
                    this.removeReferenceEnqueued((ImageCacheWeakReference)reference);
                }
                if (reference == null) continue;
                reference.clear();
            }
        }

        private final void stopCleaning() {
            this.endMarker.enqueue();
        }

        static /* synthetic */ StaleImages access$0(ReferenceCleanerThread referenceCleanerThread) {
            return referenceCleanerThread.staleImages;
        }
    }

    private static class StaleImages {
        private final List staleImages = Collections.synchronizedList(new ArrayList());

        public void addImagesToDispose(Image[] images) {
            this.staleImages.add(images);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposeStaleImages() {
            Image[] imagesToDispose = null;
            List list = this.staleImages;
            synchronized (list) {
                Iterator i = this.staleImages.iterator();
                while (i.hasNext()) {
                    imagesToDispose = (Image[])i.next();
                    int j = 0;
                    while (j < imagesToDispose.length) {
                        Image image = imagesToDispose[j];
                        if (image != null && !image.isDisposed()) {
                            image.dispose();
                        }
                        ++j;
                    }
                }
                this.staleImages.clear();
            }
        }
    }
}

