/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import java.util.Comparator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.deferred.AbstractVirtualTable;
import org.eclipse.jface.viewers.deferred.BackgroundContentProvider;
import org.eclipse.jface.viewers.deferred.IConcurrentModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class DeferredContentProvider
implements ILazyContentProvider {
    private int rangeStart = 0;
    private int rangeLength = 0;
    private int limit = -1;
    private BackgroundContentProvider provider;
    private Comparator sortOrder;
    private IFilter filter = AcceptAllFilter.getInstance();
    private AbstractVirtualTable table;

    public DeferredContentProvider(Comparator sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void dispose() {
        this.setProvider(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.setProvider(null);
            return;
        }
        Assert.isTrue(newInput instanceof IConcurrentModel);
        Assert.isTrue(viewer instanceof TableViewer);
        IConcurrentModel model = (IConcurrentModel)newInput;
        this.table = new TableViewerAdapter((TableViewer)viewer);
        BackgroundContentProvider newProvider = new BackgroundContentProvider(this.table, model, this.sortOrder, Display.getCurrent());
        this.setProvider(newProvider);
        newProvider.setLimit(this.limit);
        newProvider.setFilter(this.filter);
    }

    public void setSortOrder(Comparator sortOrder) {
        Assert.isNotNull(sortOrder);
        this.sortOrder = sortOrder;
        if (this.provider != null) {
            this.provider.setSortOrder(sortOrder);
        }
    }

    public void setFilter(IFilter toSet) {
        this.filter = toSet;
        if (this.provider != null) {
            this.provider.setFilter(toSet);
        }
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (this.provider != null) {
            this.provider.setLimit(limit);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void updateElement(int element) {
        if (this.provider != null) {
            this.provider.checkVisibleRange();
        }
    }

    private void setProvider(BackgroundContentProvider newProvider) {
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = newProvider;
    }

    private static final class TableViewerAdapter
    extends AbstractVirtualTable {
        private TableViewer viewer;

        public TableViewerAdapter(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void clear(int index) {
            this.viewer.clear(index);
        }

        public void replace(Object element, int itemIndex) {
            this.viewer.replace(element, itemIndex);
        }

        public void setItemCount(int total) {
            this.viewer.setItemCount(total);
        }

        public int getItemCount() {
            return this.viewer.getTable().getItemCount();
        }

        public int getTopIndex() {
            return this.viewer.getTable().getTopIndex();
        }

        public int getVisibleItemCount() {
            int start = this.getTopIndex();
            int itemCount = this.getItemCount();
            Table table = this.viewer.getTable();
            return Math.min(table.getBounds().height / table.getItemHeight() + 1, itemCount - start);
        }
    }
}

