/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.DefaultDescription;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.internal.content.LowLevelIOException;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ContentType
implements IContentType {
    static final byte ASSOCIATED_BY_EXTENSION = 2;
    static final byte ASSOCIATED_BY_NAME = 1;
    private static final String DESCRIBER_ELEMENT = "describer";
    static final byte NOT_ASSOCIATED = 0;
    public static final String PREF_DEFAULT_CHARSET = "charset";
    public static final String PREF_FILE_EXTENSIONS = "file-extensions";
    public static final String PREF_FILE_NAMES = "file-names";
    static final byte PRIORITY_HIGH = 1;
    static final byte PRIORITY_LOW = -1;
    static final byte PRIORITY_NORMAL = 0;
    static final int SPEC_PRE_DEFINED = 1;
    static final int SPEC_USER_DEFINED = 2;
    static final byte STATUS_INVALID = 2;
    static final byte STATUS_UNKNOWN = 0;
    static final byte STATUS_VALID = 1;
    private String baseTypeId;
    private String aliasTargetId;
    private IConfigurationElement contentTypeElement;
    private String userCharset;
    private IContentDescription defaultDescription;
    private IContentDescriber describer;
    private List fileSpecs;
    private ContentTypeManager manager;
    private String name;
    private String namespace;
    private byte priority;
    private String simpleId;
    private byte validation = 0;
    private Map defaultProperties;
    private boolean builtInAssociations = false;

    public static ContentType createContentType(ContentTypeCatalog catalog, String namespace, String simpleId, String name, byte priority, String[] fileExtensions, String[] fileNames, String baseTypeId, String aliasTargetId, Map defaultProperties, IConfigurationElement contentTypeElement) {
        ContentType contentType = new ContentType(catalog.getManager());
        contentType.defaultDescription = new DefaultDescription(contentType);
        contentType.simpleId = simpleId;
        contentType.namespace = namespace;
        contentType.name = name;
        contentType.priority = priority;
        if (fileExtensions != null && fileExtensions.length > 0 || fileNames != null && fileNames.length > 0) {
            contentType.builtInAssociations = true;
            contentType.fileSpecs = new ArrayList(fileExtensions.length + fileNames.length);
            int i = 0;
            while (i < fileNames.length) {
                contentType.internalAddFileSpec(catalog, fileNames[i], 5);
                ++i;
            }
            i = 0;
            while (i < fileExtensions.length) {
                contentType.internalAddFileSpec(catalog, fileExtensions[i], 9);
                ++i;
            }
        }
        contentType.defaultProperties = defaultProperties;
        contentType.contentTypeElement = contentTypeElement;
        contentType.baseTypeId = baseTypeId;
        contentType.aliasTargetId = aliasTargetId;
        contentType.processPreferences(catalog);
        return contentType;
    }

    private void processPreferences(ContentTypeCatalog catalog) {
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        this.userCharset = contentTypeNode.get(PREF_DEFAULT_CHARSET, null);
        String userSetFileNames = contentTypeNode.get(PREF_FILE_NAMES, null);
        String[] fileNames = Util.parseItems(userSetFileNames);
        int i = 0;
        while (i < fileNames.length) {
            this.internalAddFileSpec(catalog, fileNames[i], 6);
            ++i;
        }
        String userSetFileExtensions = contentTypeNode.get(PREF_FILE_EXTENSIONS, null);
        String[] fileExtensions = Util.parseItems(userSetFileExtensions);
        int i2 = 0;
        while (i2 < fileExtensions.length) {
            this.internalAddFileSpec(catalog, fileExtensions[i2], 10);
            ++i2;
        }
    }

    static FileSpec createFileSpec(String fileSpec, int type) {
        return new FileSpec(fileSpec, type);
    }

    private static String getPreferenceKey(int flags) {
        if ((flags & 8) != 0) {
            return PREF_FILE_EXTENSIONS;
        }
        if ((flags & 4) != 0) {
            return PREF_FILE_NAMES;
        }
        throw new IllegalArgumentException("Unknown type: " + flags);
    }

    public ContentType(ContentTypeManager manager) {
        this.manager = manager;
    }

    public void addFileSpec(String fileSpec, int type) throws CoreException {
        this.addFileSpec(this.manager.getCatalog(), fileSpec, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileSpec(ContentTypeCatalog catalog, String fileSpec, int type) throws CoreException {
        Object[] userSet;
        Assert.isLegal(type == 8 || type == 4, "Unknown type: " + type);
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            aliasTarget.addFileSpec(catalog, fileSpec, type);
            return;
        }
        ContentType contentType = this;
        synchronized (contentType) {
            if (!this.internalAddFileSpec(catalog, fileSpec, type | 2)) {
                return;
            }
            userSet = this.internalGetFileSpecs(type | 1);
        }
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        contentTypeNode.put(ContentType.getPreferenceKey(type), Util.toListString(userSet));
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind((String)Messages.content_errorSavingSettings, (Object)this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int describe(IContentDescriber selectedDescriber, boolean text, Object contents, ContentDescription description) throws IOException {
        block16: {
            int n;
            block15: {
                try {
                    int n2;
                    block13: {
                        block14: {
                            try {
                                if (!text) {
                                    n2 = selectedDescriber.describe((InputStream)contents, description);
                                    Object var7_7 = null;
                                    if (text) break block13;
                                    break block14;
                                }
                                n = ((ITextContentDescriber)selectedDescriber).describe((Reader)contents, (IContentDescription)description);
                                break block15;
                            }
                            catch (RuntimeException re) {
                                this.invalidateDescriber(re);
                                break block16;
                            }
                            catch (Error e) {
                                this.invalidateDescriber(e);
                                throw e;
                            }
                            catch (LowLevelIOException llioe) {
                                throw llioe.getActualException();
                            }
                            catch (IOException ioe) {
                                if (ContentTypeManager.DEBUGGING) {
                                    String message = NLS.bind((String)Messages.content_errorReadingContents, (Object)this.getId());
                                    ContentType.log(message, ioe);
                                }
                                break block16;
                            }
                        }
                        ((LazyInputStream)contents).rewind();
                        return n2;
                    }
                    ((LazyReader)contents).rewind();
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (!text) {
                        ((LazyInputStream)contents).rewind();
                        throw throwable;
                    }
                    ((LazyReader)contents).rewind();
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (!text) {
                ((LazyInputStream)contents).rewind();
                return n;
            }
            ((LazyReader)contents).rewind();
            return n;
        }
        Object var7_10 = null;
        if (!text) {
            ((LazyInputStream)contents).rewind();
            return 0;
        }
        ((LazyReader)contents).rewind();
        return 0;
    }

    public boolean equals(Object another) {
        if (!(another instanceof ContentType)) {
            return false;
        }
        return ((ContentType)another).getId().equals(this.getId());
    }

    public String getAliasTargetId() {
        return this.aliasTargetId;
    }

    public IContentType getBaseType() {
        return this.getBaseType(this.manager.getCatalog());
    }

    ContentType getBaseType(ContentTypeCatalog catalog) {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.getBaseType(catalog);
        }
        if (this.baseTypeId == null) {
            return null;
        }
        ContentType originalBaseType = catalog.internalGetContentType(this.baseTypeId);
        return originalBaseType != null ? originalBaseType.getTarget(catalog, true) : null;
    }

    String getBaseTypeId() {
        return this.baseTypeId;
    }

    public String getDefaultCharset() {
        return this.getDefaultProperty(this.manager.getCatalog(), IContentDescription.CHARSET);
    }

    public IContentDescription getDefaultDescription() {
        return this.getDefaultDescription(this.manager.getCatalog());
    }

    private IContentDescription getDefaultDescription(ContentTypeCatalog catalog) {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.getDefaultDescription(catalog);
        }
        return this.defaultDescription;
    }

    String getDefaultProperty(QualifiedName key) {
        return this.getDefaultProperty(this.manager.getCatalog(), key);
    }

    String getDefaultProperty(ContentTypeCatalog catalog, QualifiedName key) {
        String propertyValue = this.getTarget(catalog, true).internalGetDefaultProperty(catalog, key);
        if ("".equals(propertyValue)) {
            return null;
        }
        return propertyValue;
    }

    int getDepth(ContentTypeCatalog catalog) {
        ContentType baseType = this.getBaseType(catalog);
        if (baseType == null) {
            return 0;
        }
        return 1 + baseType.getDepth(catalog);
    }

    public IContentDescriber getDescriber() {
        return this.getDescriber(this.manager.getCatalog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IContentDescriber getDescriber(ContentTypeCatalog catalog) {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.getDescriber(catalog);
        }
        try {
            if ("".equals(this.contentTypeElement.getAttributeAsIs(DESCRIBER_ELEMENT))) {
                return null;
            }
            ContentType contentType = this;
            synchronized (contentType) {
                if (this.describer != null) {
                    return this.describer;
                }
                if (this.contentTypeElement.getChildren(DESCRIBER_ELEMENT).length > 0 || this.contentTypeElement.getAttributeAsIs(DESCRIBER_ELEMENT) != null) {
                    try {
                        this.describer = (IContentDescriber)this.contentTypeElement.createExecutableExtension(DESCRIBER_ELEMENT);
                        return this.describer;
                    }
                    catch (CoreException ce) {
                        return this.invalidateDescriber(ce);
                    }
                }
            }
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            this.manager.invalidate();
            return null;
        }
        ContentType baseType = this.getBaseType(catalog);
        return baseType == null ? null : baseType.getDescriber(catalog);
    }

    public IContentDescription getDescriptionFor(InputStream contents, QualifiedName[] options) throws IOException {
        return this.getDescriptionFor(this.manager.getCatalog(), contents, options);
    }

    private IContentDescription getDescriptionFor(ContentTypeCatalog catalog, InputStream contents, QualifiedName[] options) throws IOException {
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        if (buffer == null) {
            return this.defaultDescription;
        }
        return this.internalGetDescriptionFor(catalog, buffer, options);
    }

    public IContentDescription getDescriptionFor(Reader contents, QualifiedName[] options) throws IOException {
        return this.getDescriptionFor(this.manager.getCatalog(), contents, options);
    }

    private IContentDescription getDescriptionFor(ContentTypeCatalog catalog, Reader contents, QualifiedName[] options) throws IOException {
        LazyReader buffer = ContentTypeManager.readBuffer(contents);
        if (buffer == null) {
            return this.defaultDescription;
        }
        return this.internalGetDescriptionFor(catalog, buffer, options);
    }

    public String[] getFileSpecs(int typeMask) {
        return this.getFileSpecs(this.manager.getCatalog(), typeMask);
    }

    public String[] getFileSpecs(ContentTypeCatalog catalog) {
        return this.getFileSpecs(catalog, 12);
    }

    public String[] getFileSpecs(ContentTypeCatalog catalog, int typeMask) {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.getFileSpecs(catalog, typeMask);
        }
        return this.internalGetFileSpecs(typeMask);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private String[] internalGetFileSpecs(int typeMask) {
        if (this.fileSpecs == null) {
            return new String[0];
        }
        typeMask ^= 3;
        ArrayList<String> result = new ArrayList<String>(this.fileSpecs.size());
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if ((spec.getType() & typeMask) != spec.getType()) continue;
            result.add(spec.getText());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getId() {
        return String.valueOf(this.namespace) + '.' + this.simpleId;
    }

    public String getName() {
        return this.name;
    }

    byte getPriority() {
        return this.priority;
    }

    String getSimpleId() {
        return this.simpleId;
    }

    ContentType getTarget(ContentTypeCatalog catalog, boolean self) {
        ContentType target = catalog.getAliasTarget(this);
        return self && target == null ? this : target;
    }

    byte getValidation() {
        return this.validation;
    }

    boolean hasFileSpec(String text, int typeMask) {
        if (this.fileSpecs == null) {
            return false;
        }
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if (!spec.equals(text, typeMask)) continue;
            return true;
        }
        return false;
    }

    boolean internalAddFileSpec(ContentTypeCatalog catalog, String fileSpec, int typeMask) {
        if (this.hasFileSpec(fileSpec, typeMask)) {
            return false;
        }
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.internalAddFileSpec(catalog, fileSpec, typeMask);
        }
        if (this.fileSpecs == null) {
            this.fileSpecs = new ArrayList(3);
        }
        FileSpec newFileSpec = ContentType.createFileSpec(fileSpec, typeMask);
        this.fileSpecs.add(newFileSpec);
        if ((typeMask & 2) != 0) {
            catalog.associate(this, newFileSpec.getText(), newFileSpec.getType());
        }
        return true;
    }

    private String internalGetDefaultProperty(ContentTypeCatalog catalog, QualifiedName key) {
        String defaultValue;
        if (this.userCharset != null && key.equals(IContentDescription.CHARSET)) {
            return this.userCharset;
        }
        String string = defaultValue = this.defaultProperties == null ? null : (String)this.defaultProperties.get(key);
        if (defaultValue != null) {
            return defaultValue;
        }
        ContentType baseType = this.getBaseType(catalog);
        return baseType == null ? null : baseType.internalGetDefaultProperty(catalog, key);
    }

    IContentDescription internalGetDescriptionFor(ContentTypeCatalog catalog, InputStream buffer, QualifiedName[] options) throws IOException {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.internalGetDescriptionFor(catalog, buffer, options);
        }
        if (buffer == null) {
            return this.defaultDescription;
        }
        IContentDescriber tmpDescriber = this.getDescriber(catalog);
        if (tmpDescriber == null) {
            return this.defaultDescription;
        }
        ContentDescription description = new ContentDescription(options, this);
        this.describe(tmpDescriber, false, buffer, description);
        if (!description.isSet()) {
            return this.defaultDescription;
        }
        description.markImmutable();
        return description;
    }

    IContentDescription internalGetDescriptionFor(ContentTypeCatalog catalog, Reader buffer, QualifiedName[] options) throws IOException {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.internalGetDescriptionFor(catalog, buffer, options);
        }
        if (buffer == null) {
            return this.defaultDescription;
        }
        IContentDescriber tmpDescriber = this.getDescriber(catalog);
        if (tmpDescriber == null) {
            return this.defaultDescription;
        }
        ContentDescription description = new ContentDescription(options, this);
        if (!(tmpDescriber instanceof ITextContentDescriber)) {
            throw new UnsupportedOperationException();
        }
        this.describe(tmpDescriber, true, buffer, description);
        if (!description.isSet()) {
            return this.defaultDescription;
        }
        description.markImmutable();
        return description;
    }

    byte internalIsAssociatedWith(ContentTypeCatalog catalog, String fileName) {
        ContentType baseType;
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.internalIsAssociatedWith(catalog, fileName);
        }
        if (this.hasFileSpec(fileName, 4)) {
            return 1;
        }
        String fileExtension = ContentTypeManager.getFileExtension(fileName);
        if (this.hasFileSpec(fileExtension, 8)) {
            return 2;
        }
        if (!this.hasBuiltInAssociations() && (baseType = this.getBaseType(catalog)) != null) {
            return baseType.internalIsAssociatedWith(catalog, fileName);
        }
        return 0;
    }

    boolean hasAnyFileSpec() {
        return this.fileSpecs != null && !this.fileSpecs.isEmpty();
    }

    boolean hasBuiltInAssociations() {
        return this.builtInAssociations;
    }

    boolean internalRemoveFileSpec(ContentTypeCatalog catalog, String fileSpec, int typeMask) {
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.internalRemoveFileSpec(catalog, fileSpec, typeMask);
        }
        if (this.fileSpecs == null) {
            return false;
        }
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if (spec.getType() != typeMask || !fileSpec.equals(spec.getText())) continue;
            i.remove();
            catalog.dissociate(this, spec.getText(), spec.getType());
            return true;
        }
        return false;
    }

    private IContentDescriber invalidateDescriber(Throwable reason) {
        this.setValidation((byte)2);
        String message = NLS.bind((String)Messages.content_invalidContentDescriber, (Object)this.getId());
        ContentType.log(message, reason);
        this.describer = new InvalidDescriber();
        return this.describer;
    }

    public boolean isAssociatedWith(String fileName) {
        return this.internalIsAssociatedWith(this.manager.getCatalog(), fileName) != 0;
    }

    public boolean isKindOf(IContentType another) {
        return this.isKindOf(this.manager.getCatalog(), (ContentType)another);
    }

    boolean isKindOf(ContentTypeCatalog catalog, ContentType another) {
        if (another == null) {
            return false;
        }
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            return aliasTarget.isKindOf(catalog, another);
        }
        if (this == another) {
            return true;
        }
        if (this.getDepth(catalog) <= another.getDepth(catalog)) {
            return false;
        }
        ContentType baseType = this.getBaseType(catalog);
        return baseType != null && baseType.isKindOf(catalog, another);
    }

    boolean isValid() {
        return this.validation == 1;
    }

    public static void log(String message, Throwable reason) {
        Status status = new Status(4, "org.eclipse.core.runtime", 0, message, reason instanceof CoreException ? null : reason);
        InternalPlatform.getDefault().log(status);
    }

    public void removeFileSpec(String fileSpec, int type) throws CoreException {
        this.removeFileSpec(this.manager.getCatalog(), fileSpec, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileSpec(ContentTypeCatalog catalog, String fileSpec, int type) throws CoreException {
        Assert.isLegal(type == 8 || type == 4, "Unknown type: " + type);
        ContentType aliasTarget = this.getTarget(catalog, false);
        if (aliasTarget != null) {
            aliasTarget.removeFileSpec(catalog, fileSpec, type);
            return;
        }
        ContentType contentType = this;
        synchronized (contentType) {
            if (!this.internalRemoveFileSpec(catalog, fileSpec, type | 2)) {
                return;
            }
        }
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        Object[] userSet = this.internalGetFileSpecs(type | 1);
        if (userSet.length == 0) {
            contentTypeNode.remove(ContentType.getPreferenceKey(type));
        } else {
            contentTypeNode.put(ContentType.getPreferenceKey(type), Util.toListString(userSet));
        }
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind((String)Messages.content_errorSavingSettings, (Object)this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    void setAliasTarget(ContentTypeCatalog catalog, ContentType newTarget) {
        catalog.setAliasTarget(this, newTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCharset(String newCharset) throws CoreException {
        ContentType contentType = this;
        synchronized (contentType) {
            if (this.userCharset == null) {
                if (newCharset == null) {
                    return;
                }
            } else if (this.userCharset.equals(newCharset)) {
                return;
            }
            this.userCharset = newCharset;
        }
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        this.setPreference(contentTypeNode, PREF_DEFAULT_CHARSET, this.userCharset);
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind((String)Messages.content_errorSavingSettings, (Object)this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    private void setPreference(Preferences node, String key, String value) {
        if (value == null) {
            node.remove(key);
        } else {
            node.put(key, value);
        }
    }

    void setValidation(byte validation) {
        this.validation = validation;
        if (ContentTypeManager.DEBUGGING) {
            Policy.debug("Validating " + this + ": " + ContentType.getValidationString(validation));
        }
    }

    private static String getValidationString(byte validation) {
        return validation == 1 ? "VALID" : (validation == 2 ? "INVALID" : "UNKNOWN");
    }

    public String toString() {
        return this.getId();
    }

    boolean isAlias(ContentTypeCatalog catalog) {
        return this.getTarget(catalog, false) != null;
    }

    private class InvalidDescriber
    implements IContentDescriber,
    ITextContentDescriber {
        InvalidDescriber() {
        }

        public int describe(InputStream contents, IContentDescription description) throws IOException {
            return 0;
        }

        public int describe(Reader contents, IContentDescription description) throws IOException {
            return 0;
        }

        public QualifiedName[] getSupportedOptions() {
            return new QualifiedName[0];
        }
    }
}

