/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.DynamicClassLoader;
import com.sun.speech.freetts.UniqueVector;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;

public class VoiceManager {
    private static final VoiceManager INSTANCE = new VoiceManager();
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final String pathSeparator = System.getProperty("path.separator");
    private static final DynamicClassLoader classLoader = new DynamicClassLoader(new URL[0]);

    private VoiceManager() {
    }

    public static VoiceManager getInstance() {
        return INSTANCE;
    }

    public Voice[] getVoices() {
        UniqueVector voices = new UniqueVector();
        VoiceDirectory[] voiceDirectories = this.getVoiceDirectories();
        for (int i = 0; i < voiceDirectories.length; ++i) {
            voices.addArray(voiceDirectories[i].getVoices());
        }
        Object[] voiceArray = new Voice[voices.size()];
        return (Voice[])voices.toArray(voiceArray);
    }

    public String getVoiceInfo() {
        String infoString = "";
        VoiceDirectory[] voiceDirectories = this.getVoiceDirectories();
        for (int i = 0; i < voiceDirectories.length; ++i) {
            infoString = infoString + voiceDirectories[i].toString();
        }
        return infoString;
    }

    private VoiceDirectory[] getVoiceDirectories() {
        try {
            int i;
            String voiceClasses = System.getProperty("freetts.voices");
            if (voiceClasses != null) {
                return this.getVoiceDirectoryNamesFromProperty(voiceClasses);
            }
            UniqueVector voiceDirectoryNames = this.getVoiceDirectoryNamesFromFiles();
            UniqueVector pathURLs = this.getVoiceJarURLs();
            voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromJarURLs(pathURLs));
            URL[] voiceJarURLs = (URL[])pathURLs.toArray(new URL[pathURLs.size()]);
            for (i = 0; i < voiceJarURLs.length; ++i) {
                this.getDependencyURLs(voiceJarURLs[i], pathURLs);
            }
            for (i = 0; i < pathURLs.size(); ++i) {
                classLoader.addUniqueURL((URL)pathURLs.get(i));
            }
            UniqueVector voiceDirectories = new UniqueVector();
            for (int i2 = 0; i2 < voiceDirectoryNames.size(); ++i2) {
                Class<?> c = Class.forName((String)voiceDirectoryNames.get(i2), true, classLoader);
                voiceDirectories.add(c.newInstance());
            }
            return (VoiceDirectory[])voiceDirectories.toArray(new VoiceDirectory[voiceDirectories.size()]);
        }
        catch (InstantiationException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Unable to load voice directory. " + e);
        }
    }

    private VoiceDirectory[] getVoiceDirectoryNamesFromProperty(String voiceClasses) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] classnames = voiceClasses.split(",");
        VoiceDirectory[] directories = new VoiceDirectory[classnames.length];
        for (int i = 0; i < directories.length; ++i) {
            Class<?> c = Class.forName(classnames[i]);
            directories[i] = (VoiceDirectory)c.newInstance();
        }
        return directories;
    }

    private void getDependencyURLs(URL url, UniqueVector dependencyURLs) {
        block6: {
            try {
                String urlDirName = this.getURLDirName(url);
                if (!url.getProtocol().equals("jar")) break block6;
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                Attributes attributes = jarConnection.getMainAttributes();
                String fullClassPath = attributes.getValue(Attributes.Name.CLASS_PATH);
                if (fullClassPath == null || fullClassPath.equals("")) {
                    return;
                }
                String[] classPath = fullClassPath.split("\\s+");
                for (int i = 0; i < classPath.length; ++i) {
                    URL classPathURL;
                    try {
                        classPathURL = classPath[i].endsWith("/") ? new URL("file:" + urlDirName + classPath[i]) : new URL("jar", "", "file:" + urlDirName + classPath[i] + "!/");
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Warning: unable to resolve dependency " + classPath[i] + " referenced by " + url);
                        continue;
                    }
                    if (dependencyURLs.contains(classPathURL)) continue;
                    dependencyURLs.add(classPathURL);
                    this.getDependencyURLs(classPathURL, dependencyURLs);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private UniqueVector getVoiceDirectoryNamesFromFiles() {
        try {
            UniqueVector voiceDirectoryNames = new UniqueVector();
            InputStream is = this.getClass().getResourceAsStream("internal_voices.txt");
            if (is != null) {
                voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromInputStream(is));
            }
            try {
                voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromFile(this.getBaseDirectory() + "voices.txt"));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            String voicesFile = System.getProperty("freetts.voicesfile");
            if (voicesFile != null) {
                voiceDirectoryNames.addVector(this.getVoiceDirectoryNamesFromFile(voicesFile));
            }
            return voiceDirectoryNames;
        }
        catch (IOException e) {
            throw new Error("Error reading voices files. " + e);
        }
    }

    private UniqueVector getVoiceDirectoryNamesFromJarURLs(UniqueVector urls) {
        try {
            UniqueVector voiceDirectoryNames = new UniqueVector();
            for (int i = 0; i < urls.size(); ++i) {
                JarURLConnection jarConnection = (JarURLConnection)((URL)urls.get(i)).openConnection();
                Attributes attributes = jarConnection.getMainAttributes();
                String mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
                if (mainClass == null || mainClass.trim().equals("")) {
                    throw new Error("No Main-Class found in jar " + (URL)urls.get(i));
                }
                voiceDirectoryNames.add(mainClass);
            }
            return voiceDirectoryNames;
        }
        catch (IOException e) {
            throw new Error("Error reading jarfile manifests. ");
        }
    }

    private UniqueVector getVoiceJarURLs() {
        UniqueVector voiceJarURLs = new UniqueVector();
        try {
            String baseDirectory = this.getBaseDirectory();
            if (!baseDirectory.equals("")) {
                voiceJarURLs.addVector(this.getVoiceJarURLsFromDir(baseDirectory));
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String voicesPath = System.getProperty("freetts.voicespath", "");
        if (!voicesPath.equals("")) {
            String[] dirNames = voicesPath.split(pathSeparator);
            for (int i = 0; i < dirNames.length; ++i) {
                try {
                    voiceJarURLs.addVector(this.getVoiceJarURLsFromDir(dirNames[i]));
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new Error("Error loading jars from voicespath " + dirNames[i] + ". ");
                }
            }
        }
        return voiceJarURLs;
    }

    private UniqueVector getVoiceJarURLsFromDir(String dirName) throws FileNotFoundException {
        try {
            UniqueVector voiceJarURLs = new UniqueVector();
            File dir = new File(new URI("file://" + dirName));
            if (!dir.isDirectory()) {
                throw new FileNotFoundException("File is not a directory: " + dirName);
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String isVoice;
                if (!files[i].isFile() || files[i].isHidden() || !files[i].getName().endsWith(".jar")) continue;
                URL jarURL = files[i].toURL();
                jarURL = new URL("jar", "", "file:" + jarURL.getPath() + "!/");
                JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
                Attributes attributes = jarConnection.getMainAttributes();
                if (attributes == null || (isVoice = attributes.getValue("FreeTTSVoiceDefinition")) == null || !isVoice.trim().equals("true")) continue;
                voiceJarURLs.add(jarURL);
            }
            return voiceJarURLs;
        }
        catch (URISyntaxException e) {
            throw new Error("Error reading directory name '" + dirName + "'.");
        }
        catch (MalformedURLException e) {
            throw new Error("Error reading jars from directory " + dirName + ". ");
        }
        catch (IOException e) {
            throw new Error("Error reading jars from directory " + dirName + ". ");
        }
    }

    public String toString() {
        String names = "";
        Voice[] voices = this.getVoices();
        for (int i = 0; i < voices.length; ++i) {
            if (i == voices.length - 1) {
                if (i == 0) {
                    names = voices[i].getName();
                    continue;
                }
                names = names + "or " + voices[i].getName();
                continue;
            }
            names = names + voices[i].getName() + " ";
        }
        return names;
    }

    public boolean contains(String voiceName) {
        return this.getVoice(voiceName) != null;
    }

    public Voice getVoice(String voiceName) {
        Voice[] voices = this.getVoices();
        for (int i = 0; i < voices.length; ++i) {
            if (!voices[i].getName().equals(voiceName)) continue;
            return voices[i];
        }
        return null;
    }

    private String getBaseDirectory() {
        String name = this.getClass().getName();
        int lastdot = name.lastIndexOf(46);
        if (lastdot != -1) {
            name = name.substring(lastdot + 1);
        }
        URL url = this.getClass().getResource(name + ".class");
        return this.getURLDirName(url);
    }

    private String getURLDirName(URL url) {
        String urlFileName = url.getPath();
        int i = urlFileName.lastIndexOf(33);
        if (i == -1) {
            i = urlFileName.length();
        }
        int dir = urlFileName.lastIndexOf("/", i);
        if (!urlFileName.startsWith("file:")) {
            return "";
        }
        return urlFileName.substring(5, dir) + "/";
    }

    private UniqueVector getVoiceDirectoryNamesFromFile(String fileName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(fileName);
        if (is == null) {
            throw new IOException();
        }
        return this.getVoiceDirectoryNamesFromInputStream(is);
    }

    private UniqueVector getVoiceDirectoryNamesFromInputStream(InputStream is) throws IOException {
        String line;
        UniqueVector names = new UniqueVector();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
            names.add(line);
        }
        return names;
    }

    public static URLClassLoader getVoiceClassLoader() {
        return classLoader;
    }
}

