/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.BitVector;

final class SegmentReader
extends IndexReader {
    private boolean closeDirectory = false;
    private String segment;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    InputStream freqStream;
    InputStream proxStream;
    private Hashtable norms = new Hashtable();

    SegmentReader(SegmentInfo si, boolean closeDir) throws IOException {
        this(si);
        this.closeDirectory = closeDir;
    }

    SegmentReader(SegmentInfo si) throws IOException {
        super(si.dir);
        this.segment = si.name;
        this.fieldInfos = new FieldInfos(this.directory, this.segment + ".fnm");
        this.fieldsReader = new FieldsReader(this.directory, this.segment, this.fieldInfos);
        this.tis = new TermInfosReader(this.directory, this.segment, this.fieldInfos);
        if (SegmentReader.hasDeletions(si)) {
            this.deletedDocs = new BitVector(this.directory, this.segment + ".del");
        }
        this.freqStream = this.directory.openFile(this.segment + ".frq");
        this.proxStream = this.directory.openFile(this.segment + ".prx");
        this.openNorms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void doClose() throws IOException {
        if (this.deletedDocsDirty) {
            Directory directory = this.directory;
            synchronized (directory) {
                new Lock.With(this.directory.makeLock("commit.lock"), IndexWriter.COMMIT_LOCK_TIMEOUT){

                    public Object doBody() throws IOException {
                        SegmentReader.this.deletedDocs.write(SegmentReader.this.directory, SegmentReader.this.segment + ".tmp");
                        SegmentReader.this.directory.renameFile(SegmentReader.this.segment + ".tmp", SegmentReader.this.segment + ".del");
                        SegmentReader.this.directory.touchFile("segments");
                        return null;
                    }
                }.run();
            }
            this.deletedDocsDirty = false;
        }
        this.fieldsReader.close();
        this.tis.close();
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    static final boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.dir.fileExists(si.name + ".del");
    }

    final synchronized void doDelete(int docNum) throws IOException {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.deletedDocs.set(docNum);
    }

    final Vector files() throws IOException {
        Vector<String> files = new Vector<String>(16);
        files.addElement(this.segment + ".fnm");
        files.addElement(this.segment + ".fdx");
        files.addElement(this.segment + ".fdt");
        files.addElement(this.segment + ".tii");
        files.addElement(this.segment + ".tis");
        files.addElement(this.segment + ".frq");
        files.addElement(this.segment + ".prx");
        if (this.directory.fileExists(this.segment + ".del")) {
            files.addElement(this.segment + ".del");
        }
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                files.addElement(this.segment + ".f" + i);
            }
            ++i;
        }
        return files;
    }

    public final TermEnum terms() throws IOException {
        return this.tis.terms();
    }

    public final TermEnum terms(Term t) throws IOException {
        return this.tis.terms(t);
    }

    public final synchronized Document document(int n) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n);
    }

    public final synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public final int docFreq(Term t) throws IOException {
        TermInfo ti = this.tis.get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public final int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public final int maxDoc() {
        return this.fieldsReader.size();
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            fieldSet.add(fi.name);
            ++i;
        }
        return fieldSet;
    }

    public Collection getFieldNames(boolean indexed) throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed == indexed) {
                fieldSet.add(fi.name);
            }
            ++i;
        }
        return fieldSet;
    }

    public final byte[] norms(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] bytes = new byte[this.maxDoc()];
            this.norms(field, bytes, 0);
            norm.bytes = bytes;
        }
        return norm.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void norms(String field, byte[] bytes, int offset) throws IOException {
        InputStream normStream = this.normStream(field);
        if (normStream == null) {
            return;
        }
        try {
            normStream.readBytes(bytes, offset, this.maxDoc());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            normStream.close();
            throw throwable;
        }
        normStream.close();
    }

    final InputStream normStream(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        InputStream result = (InputStream)norm.in.clone();
        result.seek(0L);
        return result;
    }

    private final void openNorms() throws IOException {
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                this.norms.put(fi.name, new Norm(this.directory.openFile(this.segment + ".f" + fi.number)));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumerator = this.norms.elements();
            while (enumerator.hasMoreElements()) {
                Norm norm = (Norm)enumerator.nextElement();
                norm.in.close();
            }
        }
    }

    private static class Norm {
        public InputStream in;
        public byte[] bytes;

        public Norm(InputStream in) {
            this.in = in;
        }
    }
}

