/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TextStyle {
    public Font font;
    public Color foreground;
    public Color background;
    public boolean underline;
    public boolean strikeout;

    public TextStyle(Font font, Color foreground, Color background) {
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (foreground != null && foreground.isDisposed()) {
            SWT.error(5);
        }
        if (background != null && background.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.foreground = foreground;
        this.background = background;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TextStyle)) {
            return false;
        }
        TextStyle style = (TextStyle)object;
        if (this.foreground != null ? !this.foreground.equals(style.foreground) : style.foreground != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(style.background) : style.background != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(style.font) : style.font != null) {
            return false;
        }
        if (this.underline != style.underline) {
            return false;
        }
        return this.strikeout == style.strikeout;
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.font != null) {
            hash ^= this.font.hashCode();
        }
        if (this.foreground != null) {
            hash ^= this.foreground.hashCode();
        }
        if (this.background != null) {
            hash ^= this.background.hashCode();
        }
        if (this.underline) {
            hash ^= hash;
        }
        if (this.strikeout) {
            hash ^= hash;
        }
        return hash;
    }

    public String toString() {
        return "TextStyle {font: " + this.font + ", foreground: " + this.foreground + ", background: " + this.background + ", underline: " + this.underline + ", strikeout: " + this.strikeout + "}";
    }
}

