/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String text;
    Image image;
    Image[] images = new Image[0];
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int accelGroup;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void _setImages(Image[] images) {
        int pixbufs = 0;
        if (images != null) {
            int i = 0;
            while (i < images.length) {
                Image icon = images[i];
                int[] w = new int[1];
                int[] h = new int[1];
                OS.gdk_drawable_get_size((int)icon.pixmap, (int[])w, (int[])h);
                int width = w[0];
                int height = h[0];
                boolean hasMask = icon.mask != 0;
                int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)hasMask, (int)8, (int)width, (int)height);
                if (pixbuf == 0) {
                    SWT.error(2);
                }
                int colormap = OS.gdk_colormap_get_system();
                OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)icon.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
                if (hasMask) {
                    int gdkMaskImagePtr = OS.gdk_drawable_get_image((int)icon.mask, (int)0, (int)0, (int)width, (int)height);
                    if (gdkMaskImagePtr == 0) {
                        SWT.error(2);
                    }
                    int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
                    int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        int offset = pixels + y * stride;
                        OS.memmove((byte[])line, (int)offset, (int)stride);
                        int x = 0;
                        while (x < width) {
                            if (OS.gdk_image_get_pixel((int)gdkMaskImagePtr, (int)x, (int)y) == 0) {
                                line[x * 4 + 3] = 0;
                            }
                            ++x;
                        }
                        OS.memmove((int)offset, (byte[])line, (int)stride);
                        ++y;
                    }
                    OS.g_object_unref((int)gdkMaskImagePtr);
                }
                pixbufs = OS.g_list_append((int)pixbufs, (int)pixbuf);
                ++i;
            }
        }
        int window = OS.GTK_WIDGET_WINDOW((int)this.topHandle());
        OS.gdk_window_set_icon_list((int)window, (int)pixbufs);
        int[] data = new int[1];
        int temp = pixbufs;
        while (temp != 0) {
            OS.memmove((int[])data, (int)temp, (int)OS.PTR_SIZEOF);
            OS.g_object_unref((int)data[0]);
            temp = OS.g_list_next((int)temp);
        }
        if (pixbufs != 0) {
            OS.g_list_free((int)pixbufs);
        }
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    void createAccelGroup() {
        if (this.accelGroup != 0) {
            return;
        }
        this.accelGroup = OS.gtk_accel_group_new();
        if (this.accelGroup == 0) {
            SWT.error(2);
        }
        int shellHandle = this.topHandle();
        OS.gtk_window_add_accel_group((int)shellHandle, (int)this.accelGroup);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void destroyAccelGroup() {
        if (this.accelGroup == 0) {
            return;
        }
        int shellHandle = this.topHandle();
        OS.gtk_window_remove_accel_group((int)shellHandle, (int)this.accelGroup);
        this.accelGroup = 0;
    }

    void fixAccelGroup() {
        if (this.menuBar == null) {
            return;
        }
        this.destroyAccelGroup();
        this.createAccelGroup();
        this.menuBar.addAccelerators(this.accelGroup);
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton != null ? this.defaultButton : this.saveDefault;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    void releaseWidget() {
        if (this.menuBar != null) {
            this.menuBar.releaseResources();
        }
        this.menuBar = null;
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
        }
        this.menus = null;
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean restored = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return restored;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        int buttonHandle = 0;
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            buttonHandle = button.handle;
        }
        this.saveDefault = this.defaultButton = button;
        OS.gtk_window_set_default((int)this.topHandle(), (int)buttonHandle);
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        this.image = image;
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
        this._setImages(images);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        Button button;
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button == null || button.isDisposed()) {
            return false;
        }
        if (!button.isVisible() || !button.isEnabled()) {
            return true;
        }
        int shellHandle = this._getShell().topHandle();
        return OS.gtk_window_activate_default((int)shellHandle);
    }
}

