/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.gtk.OS;

class ImageList {
    int[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new int[4];
    }

    public int add(Image image) {
        int pixbuf;
        boolean hasMask;
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                OS.g_object_unref((int)this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0;
            }
            if (this.images[index] == null) break;
            ++index;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size((int)image.pixmap, (int[])w, (int[])h);
        int colormap = OS.gdk_colormap_get_system();
        boolean bl = hasMask = image.mask != 0;
        if (hasMask) {
            pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)true, (int)8, (int)w[0], (int)h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)image.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)w[0], (int)h[0]);
            int gdkMaskImagePtr = OS.gdk_drawable_get_image((int)image.mask, (int)0, (int)0, (int)w[0], (int)h[0]);
            if (gdkMaskImagePtr == 0) {
                SWT.error(2);
            }
            int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
            byte[] line = new byte[stride];
            int y = 0;
            while (y < h[0]) {
                int offset = pixels + y * stride;
                OS.memmove((byte[])line, (int)offset, (int)stride);
                int x = 0;
                while (x < w[0]) {
                    if (OS.gdk_image_get_pixel((int)gdkMaskImagePtr, (int)x, (int)y) == 0) {
                        line[x * 4 + 3] = 0;
                    }
                    ++x;
                }
                OS.memmove((int)offset, (byte[])line, (int)stride);
                ++y;
            }
            OS.g_object_unref((int)gdkMaskImagePtr);
        } else {
            ImageData data = image.getImageData();
            boolean hasAlpha = data.getTransparencyType() == 1;
            pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)hasAlpha, (int)8, (int)w[0], (int)h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)image.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)w[0], (int)h[0]);
            if (hasAlpha) {
                byte[] alpha = data.alphaData;
                int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
                int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
                byte[] line = new byte[stride];
                int y = 0;
                while (y < h[0]) {
                    int offset = pixels + y * stride;
                    OS.memmove((byte[])line, (int)offset, (int)stride);
                    int x = 0;
                    while (x < w[0]) {
                        line[x * 4 + 3] = alpha[y * h[0] + x];
                        ++x;
                    }
                    OS.memmove((int)offset, (byte[])line, (int)stride);
                    ++y;
                }
            }
        }
        if (this.width == -1 || this.height == -1) {
            this.width = w[0];
            this.height = h[0];
        }
        if (w[0] != this.width || h[0] != this.height) {
            int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)this.width, (int)this.height, (int)2);
            OS.g_object_unref((int)pixbuf);
            pixbuf = scaledPixbuf;
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
            int[] newPixbufs = new int[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, newPixbufs, 0, this.pixbufs.length);
            this.pixbufs = newPixbufs;
        }
        this.pixbufs[index] = pixbuf;
        this.images[index] = image;
        return index;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int index = 0;
        while (index < this.pixbufs.length) {
            if (this.pixbufs[index] != 0) {
                OS.g_object_unref((int)this.pixbufs[index]);
            }
            ++index;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    int getPixbuf(int index) {
        return this.pixbufs[index];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int indexOf(int pixbuf) {
        if (pixbuf == 0) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (pixbuf == this.pixbufs[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                OS.g_object_unref((int)this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0;
            }
            ++index;
        }
    }

    public int size() {
        int result = 0;
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null) {
                if (this.images[index].isDisposed()) {
                    OS.g_object_unref((int)this.pixbufs[index]);
                    this.images[index] = null;
                    this.pixbufs[index] = 0;
                }
                if (this.images[index] != null) {
                    ++result;
                }
            }
            ++index;
        }
        return result;
    }
}

