/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ImportClassNotFoundException;
import org.eclipse.osgi.framework.adaptor.ImportResourceNotFoundException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class BundleLoader
implements ClassLoaderDelegate {
    protected static final String DEFAULT_PACKAGE = ".";
    BundleLoaderProxy proxy;
    BundleHost bundle;
    BundleClassLoader classloader;
    KeyedHashSet importedPackages;
    boolean hasDynamicImports = false;
    boolean dynamicImportPackageAll;
    String[] dynamicImportPackageStems;
    String[] dynamicImportPackages;
    ArrayList providedPackages;
    KeyedHashSet requiredPackagesCache;
    BundleLoaderProxy[] requiredBundles;
    int[] reexportTable;

    protected static String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    protected static String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    protected BundleLoader(BundleHost bundle, BundleLoaderProxy proxy) throws BundleException {
        this.bundle = bundle;
        this.proxy = proxy;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), e);
        }
        this.initialize(proxy.getBundleDescription());
    }

    protected void initialize(BundleDescription description) {
        Bundle[] fragmentObjects;
        ExportPackageDescription[] exports;
        if (!(this instanceof SystemBundleLoader) && SystemBundleLoader.getSystemPackages() != null) {
            this.hasDynamicImports = true;
            this.importedPackages = new KeyedHashSet();
        }
        this.addImportedPackages(description.getResolvedImports());
        BundleDescription[] required = description.getResolvedRequires();
        if (required.length > 0) {
            HashSet<String> reExportSet = new HashSet<String>(required.length);
            BundleSpecification[] requiredSpecs = description.getRequiredBundles();
            if (requiredSpecs != null && requiredSpecs.length > 0) {
                int i = 0;
                while (i < requiredSpecs.length) {
                    if (requiredSpecs[i].isExported()) {
                        reExportSet.add(requiredSpecs[i].getName());
                    }
                    ++i;
                }
            }
            this.requiredBundles = new BundleLoaderProxy[required.length];
            int[] reexported = new int[required.length];
            int reexportIndex = 0;
            int i = 0;
            while (i < required.length) {
                this.requiredBundles[i] = this.getLoaderProxy(required[i]);
                if (reExportSet.contains(required[i].getSymbolicName())) {
                    reexported[reexportIndex++] = i;
                }
                ++i;
            }
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            }
        }
        if ((exports = description.getSelectedExports()) != null && exports.length > 0) {
            this.providedPackages = new ArrayList(exports.length);
            int i = 0;
            while (i < exports.length) {
                this.proxy.createPackageSource(exports[i], true);
                if (!this.providedPackages.contains(exports[i].getName())) {
                    this.providedPackages.add(exports[i].getName());
                }
                ++i;
            }
        }
        BundleDescription[] fragments = new BundleDescription[(fragmentObjects = this.bundle.getFragments()) == null ? 0 : fragmentObjects.length];
        int i = 0;
        while (i < fragments.length) {
            fragments[i] = ((AbstractBundle)fragmentObjects[i]).getBundleDescription();
            ++i;
        }
        if (description.hasDynamicImports()) {
            this.addDynamicImportPackage(description.getImportPackages());
        }
        i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && fragments[i].hasDynamicImports()) {
                this.addDynamicImportPackage(fragments[i].getImportPackages());
            }
            ++i;
        }
    }

    protected void initializeFragment(AbstractBundle fragment) throws BundleException {
        BundleDescription description = fragment.getBundleDescription();
        try {
            ImportPackageSpecification[] imports = description.getImportPackages();
            if (imports != null && imports.length > 0) {
                int i = 0;
                while (i < imports.length) {
                    String name;
                    if (imports[i].getResolution() == 4 && !this.isDynamicallyImported(name = imports[i].getName())) {
                        throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_IMPORT_CONFLICT", new Object[]{fragment.getLocation(), imports[i], this.bundle.getLocation()}));
                    }
                    ++i;
                }
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    private void addImportedPackages(ExportPackageDescription[] packages) {
        if (packages != null && packages.length > 0) {
            if (this.importedPackages == null) {
                this.importedPackages = new KeyedHashSet();
            }
            int i = 0;
            while (i < packages.length) {
                PackageSource source = this.createExportPackageSource(packages[i]);
                if (source == null) {
                    return;
                }
                this.importedPackages.add(source);
                ++i;
            }
        }
    }

    protected PackageSource createExportPackageSource(ExportPackageDescription export) {
        BundleLoaderProxy exportProxy = this.getLoaderProxy(export.getExporter());
        if (exportProxy == null) {
            return null;
        }
        return exportProxy.createPackageSource(export, false);
    }

    private static PackageSource createMultiSource(String packageName, PackageSource[] sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        ArrayList<SingleSourcePackage> sourceList = new ArrayList<SingleSourcePackage>(sources.length);
        int i = 0;
        while (i < sources.length) {
            SingleSourcePackage[] innerSources = sources[i].getSuppliers();
            int j = 0;
            while (j < innerSources.length) {
                if (!sourceList.contains(innerSources[j])) {
                    sourceList.add(innerSources[j]);
                }
                ++j;
            }
            ++i;
        }
        return new MultiSourcePackage(packageName, sourceList.toArray(new SingleSourcePackage[sourceList.size()]));
    }

    BundleLoaderProxy getLoaderProxy(BundleDescription source) {
        BundleLoaderProxy proxy = (BundleLoaderProxy)source.getUserObject();
        if (proxy == null) {
            long exportingID = source.getBundleId();
            BundleHost exportingBundle = (BundleHost)this.bundle.framework.getBundle(exportingID);
            if (exportingBundle == null) {
                return null;
            }
            proxy = exportingBundle.getLoaderProxy();
        }
        return proxy;
    }

    protected void close() {
        if (this.bundle == null) {
            return;
        }
        this.importedPackages = null;
        if (this.classloader != null) {
            this.classloader.close();
        }
        this.classloader = null;
        this.bundle = null;
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name);
    }

    protected URL getResource(String name) {
        return this.createClassLoader().getResource(name);
    }

    protected Enumeration getResources(String name) throws IOException {
        return this.createClassLoader().getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] classpath = this.bundle.getBundleData().getClassPath();
                if (classpath != null) {
                    this.classloader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
                }
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return this.classloader;
    }

    protected Class findLocalClass(String name) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        String packageName;
        Class result;
        if (this.isClosed()) {
            throw new ClassNotFoundException(name);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        if ((result = this.findImportedClass(name, packageName = BundleLoader.getPackageName(name))) == null) {
            result = this.findRequiredClass(name, packageName);
        }
        if (result == null && (result = this.findLocalClass(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    boolean isClosed() {
        return this.bundle == null;
    }

    public URL findResource(String name) {
        String packageName;
        URL resource;
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((resource = this.findImportedResource(name, packageName = BundleLoader.getResourcePackageName(name))) == null) {
            resource = this.findRequiredResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findLocalResource(name);
        }
        return resource;
    }

    public Enumeration findResources(String name) throws IOException {
        String packageName;
        Enumeration result;
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((result = this.findImportedResources(name, packageName = BundleLoader.getResourcePackageName(name))) == null) {
            result = this.findRequiredResources(name, packageName);
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected URL findLocalResource(final String name) {
        if (System.getSecurityManager() == null) {
            return this.createClassLoader().findLocalResource(name);
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createClassLoader().findLocalResource(name);
            }
        });
    }

    protected Enumeration findLocalResources(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.createClassLoader().findLocalResources(name);
    }

    public String findLibrary(final String name) {
        if (this.isClosed()) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    protected String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            result = ((AbstractBundle)fragments[i]).getBundleData().findLibrary(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    protected AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final BundleProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(pd, cp);
            }
        });
    }

    BundleClassLoader createBCL(BundleProtectionDomain pd, String[] cp) {
        BundleClassLoader bcl = this.bundle.getBundleData().createClassLoader(this, pd, cp);
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                try {
                    bcl.attachFragment(fragment.getBundleData(), fragment.domain, fragment.getBundleData().getClassPath());
                }
                catch (BundleException be) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                }
                ++i;
            }
        }
        bcl.initialize();
        return bcl;
    }

    public String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    protected PackageSource getImportPackageSource(String pkgname) {
        ExportPackageDescription exportPackage;
        if (pkgname == null) {
            return null;
        }
        PackageSource source = null;
        if (this.importedPackages != null && (source = (PackageSource)this.importedPackages.getByKey(pkgname)) != null) {
            return source;
        }
        if (this.isDynamicallyImported(pkgname) && (exportPackage = this.bundle.framework.adaptor.getState().linkDynamicImport(this.proxy.getBundleDescription(), pkgname)) != null) {
            source = this.createExportPackageSource(exportPackage);
            this.importedPackages.add(source);
            return source;
        }
        return null;
    }

    protected boolean isDynamicallyImported(String pkgname) {
        int i;
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (pkgname.startsWith("java.")) {
            return true;
        }
        if (!this.hasDynamicImports) {
            return false;
        }
        if (this.dynamicImportPackageAll) {
            return true;
        }
        String[] systemPackages = SystemBundleLoader.getSystemPackages();
        if (systemPackages != null) {
            i = 0;
            while (i < systemPackages.length) {
                if (pkgname.equals(systemPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackages != null) {
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                if (pkgname.equals(this.dynamicImportPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            i = 0;
            while (i < this.dynamicImportPackageStems.length) {
                if (pkgname.startsWith(this.dynamicImportPackageStems[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findImportedClass(String name, String packageName) throws ImportClassNotFoundException {
        Class result;
        block6: {
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "].findImportedClass(" + name + ")");
            }
            result = null;
            try {
                PackageSource source = this.getImportPackageSource(packageName);
                if (source != null && (result = source.loadClass(name, packageName)) == null) {
                    throw new ImportClassNotFoundException(name);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (result == null) {
                    if (!Debug.DEBUG_LOADER) throw throwable;
                    Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
                    throw throwable;
                }
                if (!Debug.DEBUG_LOADER) throw throwable;
                Debug.println("BundleLoader[" + this + "] found imported class " + name);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (result != null) break block6;
                if (!Debug.DEBUG_LOADER) return result;
            }
            Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
            return result;
        }
        if (!Debug.DEBUG_LOADER) return result;
        Debug.println("BundleLoader[" + this + "] found imported class " + name);
        return result;
    }

    protected void addExportedProvidersFor(String packageName, ArrayList result, KeyedHashSet visited) {
        if (!visited.add(this.bundle)) {
            return;
        }
        PackageSource local = null;
        if (this.isProvidedPackage(packageName)) {
            local = this.proxy.getPackageSource(packageName);
        }
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            int i = 0;
            while (i < this.requiredBundles.length) {
                if (local != null) {
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                } else if (reexportIndex < size && this.reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                }
                ++i;
            }
        }
        if (local != null) {
            result.add(local);
        }
    }

    protected PackageSource getProvidersFor(String packageName) {
        PackageSource result;
        if (this.requiredPackagesCache != null && (result = (PackageSource)this.requiredPackagesCache.getByKey(packageName)) != null) {
            if (result.isNullSource()) {
                return null;
            }
            return result;
        }
        if (this.requiredBundles == null) {
            return null;
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        ArrayList result2 = new ArrayList(3);
        int i = 0;
        while (i < this.requiredBundles.length) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(packageName, result2, visited);
            ++i;
        }
        if (this.requiredPackagesCache == null) {
            this.requiredPackagesCache = new KeyedHashSet();
        }
        if (result2.size() == 0) {
            this.requiredPackagesCache.add(new NullPackageSource(packageName));
            return null;
        }
        if (result2.size() == 1) {
            PackageSource source = (PackageSource)result2.get(0);
            this.requiredPackagesCache.add(source);
            return source;
        }
        PackageSource[] sources = result2.toArray(new PackageSource[result2.size()]);
        PackageSource source = BundleLoader.createMultiSource(packageName, sources);
        this.requiredPackagesCache.add(source);
        return source;
    }

    protected Class findRequiredClass(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredClass(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        return source.loadClass(name, packageName);
    }

    protected boolean isProvidedPackage(String name) {
        return this.providedPackages == null ? false : this.providedPackages.contains(name);
    }

    protected URL findImportedResource(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResource(" + name + ")");
        }
        if ((source = this.getImportPackageSource(packageName)) != null) {
            URL url = source.getResource(name, packageName);
            if (url != null) {
                return url;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] resource " + name + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(name);
        }
        return null;
    }

    protected URL findRequiredResource(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        return source.getResource(name, packageName);
    }

    protected Enumeration findImportedResources(String name, String packageName) throws IOException {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResources(" + name + ")");
        }
        if ((source = this.getImportPackageSource(packageName)) != null) {
            return source.getResources(name, packageName);
        }
        return null;
    }

    protected Enumeration findRequiredResources(String name, String packageName) throws IOException {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResources(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        return source.getResources(name, packageName);
    }

    private void addDynamicImportPackage(ImportPackageSpecification[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if (packages[i].getResolution() == 4) {
                dynamicImports.add(packages[i].getName());
            }
            ++i;
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    private void addDynamicImportPackage(String[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null && SystemBundleLoader.getSystemPackages() == null) {
            return;
        }
        this.hasDynamicImports = true;
        if (this.importedPackages == null) {
            this.importedPackages = new KeyedHashSet();
        }
        if (packages == null) {
            return;
        }
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            int i2 = 0;
            while (i2 < this.dynamicImportPackageStems.length) {
                stems.add(this.dynamicImportPackageStems[i2]);
                ++i2;
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                names.add(this.dynamicImportPackages[i]);
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            String name = packages[i];
            if (!this.isDynamicallyImported(name)) {
                if (name.equals("*")) {
                    this.dynamicImportPackageAll = true;
                    return;
                }
                if (name.endsWith(".*")) {
                    stems.add(name.substring(0, name.length() - 1));
                } else {
                    names.add(name);
                }
            }
            ++i;
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    public void addDynamicImportPackage(ManifestElement[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        int i = 0;
        while (i < packages.length) {
            dynamicImports.add(packages[i].getValue());
            ++i;
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    protected void clear() {
        this.providedPackages = null;
        this.requiredBundles = null;
        this.requiredPackagesCache = null;
        this.reexportTable = null;
        this.importedPackages = null;
        this.dynamicImportPackages = null;
        this.dynamicImportPackageStems = null;
    }

    protected void attachFragment(BundleFragment fragment) throws BundleException {
        this.initializeFragment(fragment);
        if (this.classloader == null) {
            return;
        }
        try {
            String[] classpath = fragment.getBundleData().getClassPath();
            if (classpath != null) {
                this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
            } else {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected FilterImpl createFilter(String filterString) throws InvalidSyntaxException {
        if (filterString == null) {
            return null;
        }
        int length = filterString.length();
        if (length <= 2) {
            throw new InvalidSyntaxException(Msg.formatter.getString("FILTER_INVALID"), filterString);
        }
        return new FilterImpl(filterString);
    }

    PackageSource getPackageSource(String pkgname) {
        PackageSource localSource;
        PackageSource result = this.getImportPackageSource(pkgname);
        if (result != null) {
            return result;
        }
        PackageSource requireSource = this.getProvidersFor(pkgname);
        PackageSource packageSource = localSource = this.isProvidedPackage(pkgname) ? this.proxy.getPackageSource(pkgname) : null;
        if (localSource instanceof BundleLoaderProxy.ReexportPackageSource) {
            localSource = new SingleSourcePackage(pkgname, this.proxy);
        }
        if (requireSource == null) {
            return localSource;
        }
        if (localSource == null) {
            return requireSource;
        }
        return BundleLoader.createMultiSource(pkgname, new PackageSource[]{requireSource, localSource});
    }
}

