/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.FilteredSourcePackage;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

public class BundleLoaderProxy
implements RequiredBundle {
    BundleLoader loader;
    private BundleHost bundle;
    private BundleDescription description;
    private boolean stale = false;
    private KeyedHashSet pkgSources;

    public BundleLoaderProxy(BundleHost bundle, BundleDescription description) {
        this.bundle = bundle;
        this.description = description;
        this.pkgSources = new KeyedHashSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            BundleLoaderProxy bundleLoaderProxy = this;
            synchronized (bundleLoaderProxy) {
                if (this.loader == null) {
                    try {
                        this.loader = this.bundle.getBundleId() == 0L ? new SystemBundleLoader(this.bundle, this) : new BundleLoader(this.bundle, this);
                    }
                    catch (BundleException e) {
                        this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
                        return null;
                    }
                }
            }
        }
        return this.loader;
    }

    public BundleLoader getBasicBundleLoader() {
        return this.loader;
    }

    public AbstractBundle getBundleHost() {
        return this.bundle;
    }

    public void setStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String toString() {
        String symbolicName = this.bundle.getSymbolicName();
        StringBuffer sb = new StringBuffer(symbolicName == null ? this.bundle.getLocation() : symbolicName);
        sb.append("; ").append("bundle-version");
        sb.append("=\"").append(this.description.getVersion().toString()).append("\"");
        return sb.toString();
    }

    public Bundle getBundle() {
        if (this.isStale()) {
            return null;
        }
        return this.bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.isStale()) {
            return null;
        }
        BundleDescription[] dependents = this.description.getDependents();
        if (dependents == null || dependents.length == 0) {
            return null;
        }
        ArrayList result = new ArrayList(dependents.length);
        int i = 0;
        while (i < dependents.length) {
            this.addRequirers(dependents[i], result);
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new Bundle[result.size()]);
    }

    void addRequirers(BundleDescription dependent, ArrayList result) {
        if (dependent.getHost() != null) {
            return;
        }
        BundleLoaderProxy dependentProxy = this.getBundleLoader().getLoaderProxy(dependent);
        if (dependentProxy == null) {
            return;
        }
        if (result.contains(dependentProxy.bundle)) {
            return;
        }
        BundleLoader dependentLoader = dependentProxy.getBundleLoader();
        BundleLoaderProxy[] requiredBundles = dependentLoader.requiredBundles;
        int[] reexportTable = dependentLoader.reexportTable;
        if (requiredBundles == null) {
            return;
        }
        int size = reexportTable == null ? 0 : reexportTable.length;
        int reexportIndex = 0;
        int i = 0;
        while (i < requiredBundles.length) {
            if (requiredBundles[i] == this) {
                result.add(dependentProxy.bundle);
                if (reexportIndex < size && reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    BundleDescription[] dependents = dependent.getDependents();
                    if (dependents == null) {
                        return;
                    }
                    int j = 0;
                    while (j < dependents.length) {
                        dependentProxy.addRequirers(dependents[j], result);
                        ++j;
                    }
                }
                return;
            }
            ++i;
        }
    }

    public String getSymbolicName() {
        return this.description.getSymbolicName();
    }

    public Version getVersion() {
        return this.description.getVersion();
    }

    public boolean isRemovalPending() {
        return this.description.isRemovalPending();
    }

    public BundleDescription getBundleDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource getPackageSource(String pkgName) {
        PackageSource pkgSource = (PackageSource)this.pkgSources.getByKey(pkgName);
        if (pkgSource == null) {
            KeyedHashSet keyedHashSet = this.pkgSources;
            synchronized (keyedHashSet) {
                pkgSource = new SingleSourcePackage(pkgName, this);
                this.pkgSources.add(pkgSource);
            }
        }
        return pkgSource;
    }

    public boolean inUse() {
        return this.description.getDependents().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource createPackageSource(ExportPackageDescription export, boolean storeSource) {
        PackageSource pkgSource = null;
        if (!export.isRoot()) {
            pkgSource = new ReexportPackageSource(export.getName());
        } else {
            String includes = export.getInclude();
            String excludes = export.getExclude();
            if (includes != null || excludes != null) {
                pkgSource = new FilteredSourcePackage(export.getName(), this, includes, excludes);
            }
        }
        if (storeSource) {
            if (pkgSource != null && this.pkgSources.getByKey(export.getName()) == null) {
                KeyedHashSet keyedHashSet = this.pkgSources;
                synchronized (keyedHashSet) {
                    this.pkgSources.add(pkgSource);
                }
            }
        } else if (pkgSource == null) {
            pkgSource = this.getPackageSource(export.getName());
        }
        return pkgSource;
    }

    class ReexportPackageSource
    extends PackageSource {
        public ReexportPackageSource(String id) {
            super(id);
        }

        public synchronized SingleSourcePackage[] getSuppliers() {
            PackageSource source = BundleLoaderProxy.this.getBundleLoader().getPackageSource(this.id);
            if (source == null) {
                return null;
            }
            return source.getSuppliers();
        }

        public Class loadClass(String name, String pkgName) {
            try {
                return BundleLoaderProxy.this.getBundleLoader().findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public URL getResource(String name, String pkgName) {
            return BundleLoaderProxy.this.getBundleLoader().findResource(name);
        }

        public Enumeration getResources(String name, String pkgName) throws IOException {
            return BundleLoaderProxy.this.getBundleLoader().findResources(name);
        }
    }
}

