/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
implements ExportedPackage {
    String specVersion;
    ExportPackageDescription exportedPackage;
    BundleLoaderProxy supplier;

    public ExportedPackageImpl(ExportPackageDescription exportedPackage, BundleLoaderProxy supplier) {
        this.exportedPackage = exportedPackage;
        this.supplier = supplier;
        Version version = exportedPackage.getVersion();
        if (version != null) {
            this.specVersion = version.toString();
        }
    }

    public String getName() {
        return this.exportedPackage.getName();
    }

    public Bundle getExportingBundle() {
        if (this.supplier.isStale()) {
            return null;
        }
        return this.supplier.getBundleHost();
    }

    public Bundle[] getImportingBundles() {
        if (this.supplier.isStale()) {
            return null;
        }
        BundleDescription[] dependentBundles = this.supplier.getBundleDescription().getDependents();
        ArrayList importingBundles = new ArrayList();
        int i = 0;
        while (i < dependentBundles.length) {
            BundleLoaderProxy proxy;
            if (dependentBundles[i].getHost() == null && (proxy = this.supplier.getBundleLoader().getLoaderProxy(dependentBundles[i])) != null) {
                this.addImporters(proxy, importingBundles);
            }
            ++i;
        }
        Bundle[] result = new AbstractBundle[importingBundles.size()];
        importingBundles.toArray(result);
        return result;
    }

    private void addImporters(BundleLoaderProxy proxy, ArrayList importingBundles) {
        if (importingBundles.contains(proxy.getBundle())) {
            return;
        }
        if (this.isImportedBy(proxy.getBundleLoader())) {
            importingBundles.add(proxy.getBundle());
            return;
        }
        if (this.isRequiredBy(proxy.getBundleLoader())) {
            this.supplier.addRequirers(proxy.getBundleDescription(), importingBundles);
        }
    }

    private boolean isImportedBy(BundleLoader loader) {
        return loader.importedPackages != null && loader.importedPackages.getByKey(this.getName()) != null;
    }

    private boolean isRequiredBy(BundleLoader loader) {
        BundleLoaderProxy[] requiredBundles = loader.requiredBundles;
        if (requiredBundles == null) {
            return false;
        }
        int i = 0;
        while (i < requiredBundles.length) {
            if (requiredBundles[i] == this.supplier) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public boolean isRemovalPending() {
        return this.isRemovalPending(this.exportedPackage);
    }

    private boolean isRemovalPending(ExportPackageDescription exportDescription) {
        BundleDescription exporter = exportDescription.getExporter();
        if (exporter != null) {
            return exporter.isRemovalPending();
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getName());
        if (this.specVersion != null) {
            result.append("; ").append("specification-version");
            result.append("=\"").append(this.specVersion).append("\"");
        }
        return result.toString();
    }

    BundleLoaderProxy getSuppler() {
        return this.supplier;
    }
}

