/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

public class MessageResourceBundle {
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String bundleName, ClassLoader loader, Field[] fields) {
        String[] variants = MessageResourceBundle.buildVariants(bundleName);
        int i = variants.length;
        while (--i >= 0) {
            Object var7_7;
            InputStream input = loader.getResourceAsStream(variants[i]);
            if (input == null) continue;
            try {
                try {
                    MessagesProperties properties = new MessagesProperties(fields, bundleName);
                    properties.load(input);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                var7_7 = null;
                if (input == null) continue;
            }
            try {}
            catch (IOException iOException) {}
            input.close();
        }
        return;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final Map fields;
        private final String bundleName;

        public MessagesProperties(Field[] fieldArray, String bundleName) {
            this.bundleName = bundleName;
            int len = fieldArray.length;
            this.fields = new HashMap(len * 2);
            int i = 0;
            while (i < len) {
                this.fields.put(fieldArray[i].getName(), fieldArray[i]);
                ++i;
            }
        }

        public synchronized Object put(Object key, Object value) {
            try {
                Field field = (Field)this.fields.get(key);
                if (field == null) {
                    if (NLS.DEBUG_MESSAGE_BUNDLES) {
                        System.out.println("Unused message: " + key + " in: " + this.bundleName);
                    }
                    return null;
                }
                if ((field.getModifiers() & 0x19) != 9) {
                    return null;
                }
                try {
                    field.set(null, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

