/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.osgi.framework.BundleException;

public class DefaultBundleData
extends AbstractBundleData {
    public void setManifest(String manifest) {
        Hashtable<String, String> dic = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(manifest, ":\n");
        while (st.hasMoreTokens()) {
            String key = st.nextToken().trim();
            String value = st.nextToken().trim();
            dic.put(key, value);
        }
        this.manifest = dic;
    }

    public void initializeExistingBundle() throws BundleException, IOException {
        File delete = new File(this.getBundleStoreDir(), ".delete");
        if (delete.exists()) {
            throw new IOException();
        }
        this.createBaseBundleFile();
        this.loadFromManifest();
    }

    public DefaultBundleData(DefaultAdaptor adaptor, long id) {
        super(adaptor, id);
    }

    public String toString() {
        return this.getLocation();
    }

    public synchronized void save() throws IOException {
        ((DefaultAdaptor)this.adaptor).saveMetaDataFor(this);
    }

    protected File createBundleStoreDir() {
        if (!this.getBundleStoreDir().exists() && !this.getBundleStoreDir().mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println("Unable to create bundle store directory: " + this.getBundleStoreDir().getPath());
        }
        return this.getBundleStoreDir();
    }
}

