/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;

public class ResolverImport {
    private ImportPackageSpecification importPackageSpecification;
    private ResolverExport matchingExport;
    private ResolverBundle bundle;
    private ArrayList unresolvableWirings = new ArrayList();
    private String name = null;

    ResolverImport(ResolverBundle bundle, ImportPackageSpecification ips) {
        this.bundle = bundle;
        this.importPackageSpecification = ips;
    }

    boolean isFromFragment() {
        return this.importPackageSpecification.getBundle().getHost() != null;
    }

    String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.importPackageSpecification.getName();
    }

    void setName(String name) {
        this.name = name;
    }

    ResolverBundle getBundle() {
        return this.bundle;
    }

    BundleDescription getActualBundle() {
        return this.bundle.getBundle();
    }

    boolean isSatisfiedBy(ResolverExport re) {
        if (!this.bundle.getResolver().getPermissionChecker().checkImportPermission(this.importPackageSpecification, re.getExportPackageDescription())) {
            return false;
        }
        return this.importPackageSpecification.isSatisfiedBy(re.getExportPackageDescription());
    }

    ResolverExport getMatchingExport() {
        return this.matchingExport;
    }

    void setMatchingExport(ResolverExport matchingExport) {
        this.matchingExport = matchingExport;
    }

    ResolverExport getRoot() {
        ResolverImport ri = this;
        ResolverExport re = ri.getMatchingExport();
        while (re != null && !re.getExportPackageDescription().isRoot()) {
            ResolverBundle reExporter = re.getExporter();
            ri = reExporter.getImport(re.getName());
            re = ri != null ? ri.getMatchingExport() : this.getRootRequires(re, reExporter);
        }
        return re;
    }

    private ResolverExport getRootRequires(ResolverExport re, ResolverBundle reExporter) {
        BundleConstraint[] requires = reExporter.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    if (re.getName().equals(exports[j].getName())) {
                        return exports[j];
                    }
                    ++j;
                }
                if ((re = this.getRootRequires(re, requires[i].getMatchingBundle())).getExportPackageDescription().isRoot()) {
                    return re;
                }
            }
            ++i;
        }
        return re;
    }

    /*
     * Unable to fully structure code
     */
    boolean isOnRootPath(ResolverBundle rb) {
        ri = this;
        re = ri.getMatchingExport();
        if (re.getExporter() != rb) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            reExporter = re.getExporter();
            ri = reExporter.getImport(re.getName());
            if (!(ri != null ? (re = ri.getMatchingExport()).getExporter() == rb : (re = this.getRootRequires(re, reExporter)).getExporter() == rb)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (re != null && !re.getExportPackageDescription().isRoot())
        }
lbl10:
        // 1 sources

        return false;
    }

    boolean isOnRootPathSplit(ResolverBundle bundle, ResolverBundle toFind) {
        if (bundle == null) {
            return false;
        }
        BundleConstraint[] requires = bundle.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() == toFind) {
                return true;
            }
            if (this.isOnRootPathSplit(requires[i].getMatchingBundle(), toFind)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void addUnresolvableWiring(ResolverBundle module) {
        this.unresolvableWirings.add(module);
    }

    void removeUnresolvableWiring(ResolverBundle module) {
        this.unresolvableWirings.remove(module);
    }

    void clearUnresolvableWirings() {
        this.unresolvableWirings = new ArrayList();
    }

    boolean isNotAnUnresolvableWiring(ResolverExport exp) {
        return !this.unresolvableWirings.contains(exp.getExporter());
    }

    ImportPackageSpecification getImportPackageSpecification() {
        return this.importPackageSpecification;
    }

    boolean isOptional() {
        return (this.importPackageSpecification.getResolution() & 2) != 0;
    }

    boolean isDynamic() {
        return (this.importPackageSpecification.getResolution() & 4) != 0;
    }

    public String toString() {
        return this.importPackageSpecification.toString();
    }
}

