/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDeltaImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;

public class StateDeltaImpl
implements StateDelta {
    private State state;
    private Map changes = new HashMap();

    public StateDeltaImpl(State state) {
        this.state = state;
    }

    public BundleDelta[] getChanges() {
        return this.changes.values().toArray(new BundleDelta[this.changes.size()]);
    }

    public BundleDelta[] getChanges(int mask, boolean exact) {
        ArrayList<BundleDelta> result = new ArrayList<BundleDelta>();
        Iterator changesIter = this.changes.values().iterator();
        while (changesIter.hasNext()) {
            BundleDelta change = (BundleDelta)changesIter.next();
            if (mask != change.getType() && (exact || (change.getType() & mask) != mask)) continue;
            result.add(change);
        }
        return result.toArray(new BundleDelta[result.size()]);
    }

    public State getState() {
        return this.state;
    }

    void recordBundleAdded(BundleDescriptionImpl added) {
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(added);
        if (change == null) {
            this.changes.put(added, new BundleDeltaImpl(added, 1));
            return;
        }
        if (change.getType() == 2) {
            this.changes.remove(added);
            return;
        }
        int newType = change.getType();
        if ((newType & 2) != 0) {
            newType &= 0xFFFFFFFD;
        }
        change.setType(newType | 1);
        change.setBundle(added);
    }

    void recordBundleUpdated(BundleDescriptionImpl updated) {
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(updated);
        if (change == null) {
            this.changes.put(updated, new BundleDeltaImpl(updated, 4));
            return;
        }
        if ((change.getType() & 3) != 0) {
            return;
        }
        change.setType(change.getType() | 4);
        change.setBundle(updated);
    }

    void recordBundleRemoved(BundleDescriptionImpl removed) {
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(removed);
        if (change == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 2));
            return;
        }
        if (change.getType() == 1) {
            this.changes.remove(removed);
            return;
        }
        int newType = change.getType();
        if ((newType & 1) != 0) {
            newType &= 0xFFFFFFFE;
        }
        change.setType(newType | 2);
    }

    void recordBundleRemovalPending(BundleDescriptionImpl removed) {
        removed.setStateBit((byte)4, true);
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(removed);
        if (change == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 128));
            return;
        }
        int newType = change.getType();
        if ((newType & 0x100) != 0) {
            newType &= 0xFFFFFEFF;
        }
        change.setType(newType | 0x80);
    }

    void recordBundleRemovalComplete(BundleDescriptionImpl removed) {
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(removed);
        if (change == null) {
            this.changes.put(removed, new BundleDeltaImpl(removed, 256));
            return;
        }
        int newType = change.getType();
        if ((newType & 0x80) != 0) {
            newType &= 0xFFFFFF7F;
        }
        change.setType(newType | 0x100);
    }

    void recordBundleResolved(BundleDescriptionImpl resolved, boolean result) {
        int newType;
        if (resolved.isResolved() == result) {
            return;
        }
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(resolved);
        int n = newType = result ? 8 : 16;
        if (change == null) {
            change = new BundleDeltaImpl(resolved, newType);
            this.changes.put(resolved, change);
            return;
        }
        change.setType(newType |= change.getType() & 0xFFFFFFE7);
        change.setBundle(resolved);
    }
}

