/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateReader {
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    protected Map objectTable = new HashMap();
    private File stateFile;
    private File lazyFile;
    private boolean lazyLoad = true;
    private int lazyDataOffset;
    private int numBundles;
    public static final byte STATE_CACHE_VERSION = 14;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;
    private WeakHashMap stringCache = new WeakHashMap();

    public StateReader() {
        this.lazyLoad = false;
    }

    public StateReader(File stateDirectory) {
        if (!stateDirectory.exists()) {
            stateDirectory.mkdirs();
        }
        this.stateFile = new File(stateDirectory, STATE_FILE);
        this.lazyFile = new File(stateDirectory, LAZY_FILE);
        this.lazyLoad = false;
    }

    public StateReader(File stateFile, File lazyFile, boolean lazyLoad) {
        this.stateFile = stateFile;
        this.lazyFile = lazyFile;
        this.lazyLoad = lazyLoad;
    }

    private int addToObjectTable(Object object, int index) {
        this.objectTable.put(new Integer(index), object);
        return index;
    }

    private Object getFromObjectTable(int index) {
        return this.objectTable.get(new Integer(index));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readState(StateImpl state, File stateFile, File lazyFile, long expectedTimestamp) throws IOException {
        DataInputStream in;
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                in = new DataInputStream(new BufferedInputStream(SecureAction.getFileInputStream(stateFile), 65536));
                                try {
                                    if (in.readByte() != 14) {
                                        Object var15_6 = null;
                                        break block13;
                                    }
                                    byte tag = this.readTag(in);
                                    if (tag != 1) {
                                        break block14;
                                    }
                                    int index = in.readInt();
                                    long timestampRead = in.readLong();
                                    if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
                                        break block15;
                                    }
                                    this.addToObjectTable(state, index);
                                    Hashtable<String, Object> props = new Hashtable<String, Object>(4);
                                    int numProps = in.readInt();
                                    int i = 0;
                                    while (true) {
                                        if (i >= numProps) {
                                            state.setPlatformProperties(props);
                                            this.numBundles = in.readInt();
                                            if (this.numBundles != 0) break;
                                            break block16;
                                        }
                                        Object value = this.readPlatformProp(in);
                                        if (value != null) {
                                            props.put(StateImpl.PROPS[i], value);
                                        }
                                        ++i;
                                    }
                                    i = 0;
                                    while (true) {
                                        if (i >= this.numBundles) {
                                            state.setTimeStamp(timestampRead);
                                            state.setResolved(in.readBoolean());
                                            if (!this.lazyLoad) break;
                                            break block17;
                                        }
                                        BundleDescriptionImpl bundle = this.readBundleDescription(in);
                                        state.basicAddBundle(bundle);
                                        if (bundle.isResolved()) {
                                            state.addResolvedBundle(bundle);
                                        }
                                        ++i;
                                    }
                                    in = new DataInputStream(new BufferedInputStream(SecureAction.getFileInputStream(lazyFile), 65536));
                                    i = 0;
                                    while (i < this.numBundles) {
                                        this.readBundleDescriptionLazyData(in, null);
                                        ++i;
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    Object var15_11 = null;
                                    in.close();
                                    throw throwable;
                                }
                            }
                            in.close();
                            return false;
                        }
                        Object var15_7 = null;
                        in.close();
                        return false;
                    }
                    Object var15_8 = null;
                    in.close();
                    return false;
                }
                Object var15_9 = null;
                in.close();
                return true;
            }
            Object var15_10 = null;
            in.close();
            return true;
        }
        Object var15_12 = null;
        in.close();
        return true;
    }

    private boolean readStateDeprecated(StateImpl state, DataInputStream in, long expectedTimestamp) throws IOException {
        if (in.readByte() != 14) {
            return false;
        }
        byte tag = this.readTag(in);
        if (tag != 1) {
            return false;
        }
        int index = in.readInt();
        long timestampRead = in.readLong();
        if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
            return false;
        }
        this.addToObjectTable(state, index);
        Hashtable<String, Object> props = new Hashtable<String, Object>(4);
        int numProps = in.readInt();
        int i = 0;
        while (i < numProps) {
            Object value = this.readPlatformProp(in);
            if (value != null) {
                props.put(StateImpl.PROPS[i], value);
            }
            ++i;
        }
        state.setPlatformProperties(props);
        this.numBundles = in.readInt();
        if (this.numBundles == 0) {
            return true;
        }
        i = 0;
        while (i < this.numBundles) {
            BundleDescriptionImpl bundle = this.readBundleDescription(in);
            state.basicAddBundle(bundle);
            if (bundle.isResolved()) {
                state.addResolvedBundle(bundle);
            }
            ++i;
        }
        state.setTimeStamp(timestampRead);
        state.setResolved(in.readBoolean());
        this.lazyDataOffset = in.readInt();
        if (this.lazyLoad) {
            return true;
        }
        i = 0;
        while (i < this.numBundles) {
            this.readBundleDescriptionLazyData(in, null);
            ++i;
        }
        return true;
    }

    private Object readPlatformProp(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int num = in.readInt();
        if (num == 1) {
            return this.readString(in, false);
        }
        String[] result = new String[num];
        int i = 0;
        while (i < result.length) {
            result[i] = this.readString(in, false);
            ++i;
        }
        return result;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream in) throws IOException {
        BaseDescription[] hosts;
        HostSpecificationImpl hostSpec;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (BundleDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        this.addToObjectTable(result, in.readInt());
        result.setBundleId(in.readLong());
        this.readBaseDescription(result, in);
        result.setStateBit((byte)1, in.readBoolean());
        result.setStateBit((byte)2, in.readBoolean());
        result.setStateBit((byte)32, in.readBoolean());
        result.setHost(this.readHostSpec(in));
        int numDeps = in.readInt();
        if (numDeps > 0) {
            BaseDescription[] deps = new BundleDescription[numDeps];
            int i = 0;
            while (i < numDeps) {
                deps[i] = this.readBundleDescription(in);
                ++i;
            }
            result.addDependencies(deps);
        }
        if ((hostSpec = (HostSpecificationImpl)result.getHost()) != null && (hosts = hostSpec.getHosts()) != null) {
            int i = 0;
            while (i < hosts.length) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(result);
                ++i;
            }
            result.addDependencies(hosts);
        }
        result.setFullyLoaded(false);
        return result;
    }

    private BundleDescriptionImpl readBundleDescriptionLazyData(DataInputStream in, List toLoad) throws IOException {
        int resolvedRequiredCount;
        int resolvedCount;
        int selectedCount;
        int requiredBundleCount;
        int importCount;
        boolean shouldLoad;
        int index = in.readInt();
        BundleDescriptionImpl result = (BundleDescriptionImpl)this.getFromObjectTable(index);
        boolean bl = shouldLoad = toLoad == null ? true : toLoad.remove(result);
        if (result.isFullyLoaded()) {
            in.skipBytes(result.getLazyDataSize());
            in.readInt();
            return result;
        }
        if (!shouldLoad) {
            this.skipBundleDescriptionLazyData(result, in);
            return result;
        }
        result.setLocation(this.readString(in, false));
        result.setPlatformFilter(this.readString(in, false));
        int exportCount = in.readInt();
        if (exportCount > 0) {
            ExportPackageDescription[] exports = new ExportPackageDescription[exportCount];
            int i = 0;
            while (i < exports.length) {
                exports[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setExportPackages(exports);
        }
        if ((importCount = in.readInt()) > 0) {
            ImportPackageSpecification[] imports = new ImportPackageSpecification[importCount];
            int i = 0;
            while (i < imports.length) {
                imports[i] = this.readImportPackageSpec(in);
                ++i;
            }
            result.setImportPackages(imports);
        }
        if ((requiredBundleCount = in.readInt()) > 0) {
            BundleSpecification[] requiredBundles = new BundleSpecification[requiredBundleCount];
            int i = 0;
            while (i < requiredBundles.length) {
                requiredBundles[i] = this.readBundleSpec(in);
                ++i;
            }
            result.setRequiredBundles(requiredBundles);
        }
        if ((selectedCount = in.readInt()) > 0) {
            ExportPackageDescription[] selected = new ExportPackageDescription[selectedCount];
            int i = 0;
            while (i < selected.length) {
                selected[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setSelectedExports(selected);
        }
        if ((resolvedCount = in.readInt()) > 0) {
            ExportPackageDescription[] resolved = new ExportPackageDescription[resolvedCount];
            int i = 0;
            while (i < resolved.length) {
                resolved[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setResolvedImports(resolved);
        }
        if ((resolvedRequiredCount = in.readInt()) > 0) {
            BundleDescription[] resolved = new BundleDescription[resolvedRequiredCount];
            int i = 0;
            while (i < resolved.length) {
                resolved[i] = this.readBundleDescription(in);
                ++i;
            }
            result.setResolvedRequires(resolved);
        }
        result.setLazyDataSize(in.readInt());
        result.setFullyLoaded(true);
        return result;
    }

    private void skipBundleDescriptionLazyData(BundleDescriptionImpl result, DataInputStream in) throws IOException {
        int resolvedRequiredCount;
        int resolvedCount;
        int selectedCount;
        int requiredBundleCount;
        int importCount;
        if (result.getLazyDataSize() > 0) {
            in.skipBytes(result.getLazyDataSize());
            in.readInt();
            return;
        }
        this.skipString(in);
        this.skipString(in);
        int exportCount = in.readInt();
        if (exportCount > 0) {
            int i = 0;
            while (i < exportCount) {
                this.skipExportPackageDesc(in);
                ++i;
            }
        }
        if ((importCount = in.readInt()) > 0) {
            int i = 0;
            while (i < importCount) {
                this.skipImportPackageSpec(in);
                ++i;
            }
        }
        if ((requiredBundleCount = in.readInt()) > 0) {
            int i = 0;
            while (i < requiredBundleCount) {
                this.skipBundleSpec(in);
                ++i;
            }
        }
        if ((selectedCount = in.readInt()) > 0) {
            int i = 0;
            while (i < selectedCount) {
                this.skipExportPackageDesc(in);
                ++i;
            }
        }
        if ((resolvedCount = in.readInt()) > 0) {
            int i = 0;
            while (i < resolvedCount) {
                this.skipExportPackageDesc(in);
                ++i;
            }
        }
        if ((resolvedRequiredCount = in.readInt()) > 0) {
            int i = 0;
            while (i < resolvedRequiredCount) {
                this.readBundleDescription(in);
                ++i;
            }
        }
        result.setLazyDataSize(in.readInt());
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream in) throws IOException {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readBundleDescription(in));
        result.setExported(in.readBoolean());
        result.setOptional(in.readBoolean());
        return result;
    }

    private void skipBundleSpec(DataInputStream in) throws IOException {
        this.skipVersionConstraint(in);
        this.readBundleDescription(in);
        in.readBoolean();
        in.readBoolean();
    }

    private ExportPackageDescriptionImpl readExportPackageDesc(DataInputStream in) throws IOException {
        int mandatoryCount;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (ExportPackageDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        ExportPackageDescriptionImpl exportPackageDesc = new ExportPackageDescriptionImpl();
        this.addToObjectTable(exportPackageDesc, in.readInt());
        this.readBaseDescription(exportPackageDesc, in);
        exportPackageDesc.setGrouping(this.readString(in, false));
        exportPackageDesc.setInclude(this.readString(in, false));
        exportPackageDesc.setExclude(this.readString(in, false));
        exportPackageDesc.setRoot(in.readBoolean());
        int attrCount = in.readInt();
        if (attrCount > 0) {
            HashMap<String, String> attributes = new HashMap<String, String>(attrCount);
            int i = 0;
            while (i < attrCount) {
                attributes.put(this.readString(in, false), this.readString(in, false));
                ++i;
            }
            exportPackageDesc.setAttributes(attributes);
        }
        if ((mandatoryCount = in.readInt()) > 0) {
            String[] mandatory = new String[mandatoryCount];
            int i = 0;
            while (i < mandatoryCount) {
                mandatory[i] = this.readString(in, false);
                ++i;
            }
            exportPackageDesc.setMandatory(mandatory);
        }
        return exportPackageDesc;
    }

    private void skipExportPackageDesc(DataInputStream in) throws IOException {
        int mandatoryCount;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return;
        }
        if (tag == 2) {
            in.readInt();
            return;
        }
        in.readInt();
        this.skipBaseDescription(in);
        this.skipString(in);
        this.skipString(in);
        this.skipString(in);
        in.readBoolean();
        int attrCount = in.readInt();
        if (attrCount > 0) {
            int i = 0;
            while (i < attrCount) {
                this.skipString(in);
                this.skipString(in);
                ++i;
            }
        }
        if ((mandatoryCount = in.readInt()) > 0) {
            int i = 0;
            while (i < mandatoryCount) {
                this.skipString(in);
                ++i;
            }
        }
    }

    private void readBaseDescription(BaseDescriptionImpl root, DataInputStream in) throws IOException {
        root.setName(this.readString(in, false));
        root.setVersion(this.readVersion(in));
    }

    private void skipBaseDescription(DataInputStream in) throws IOException {
        this.skipString(in);
        this.skipVersion(in);
    }

    private ImportPackageSpecificationImpl readImportPackageSpec(DataInputStream in) throws IOException {
        int attrCount;
        ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readExportPackageDesc(in));
        result.setBundleSymbolicName(this.readString(in, false));
        result.setBundleVersionRange(this.readVersionRange(in));
        result.setResolution(in.readInt());
        int propagateCount = in.readInt();
        if (propagateCount > 0) {
            String[] propagate = new String[propagateCount];
            int i = 0;
            while (i < propagateCount) {
                propagate[i] = this.readString(in, false);
                ++i;
            }
            result.setPropagate(propagate);
        }
        if ((attrCount = in.readInt()) > 0) {
            HashMap<String, String> attributes = new HashMap<String, String>(attrCount);
            int i = 0;
            while (i < attrCount) {
                attributes.put(this.readString(in, false), this.readString(in, false));
                ++i;
            }
            result.setAttributes(attributes);
        }
        return result;
    }

    private void skipImportPackageSpec(DataInputStream in) throws IOException {
        int attrCount;
        this.skipVersionConstraint(in);
        this.skipExportPackageDesc(in);
        this.skipString(in);
        this.skipVersionRange(in);
        in.readInt();
        int propagateCount = in.readInt();
        if (propagateCount > 0) {
            int i = 0;
            while (i < propagateCount) {
                this.skipString(in);
                ++i;
            }
        }
        if ((attrCount = in.readInt()) > 0) {
            int i = 0;
            while (i < attrCount) {
                this.skipString(in);
                this.skipString(in);
                ++i;
            }
        }
    }

    private HostSpecificationImpl readHostSpec(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        this.readVersionConstraint(result, in);
        int hostCount = in.readInt();
        if (hostCount > 0) {
            BundleDescription[] hosts = new BundleDescription[hostCount];
            int i = 0;
            while (i < hosts.length) {
                hosts[i] = this.readBundleDescription(in);
                ++i;
            }
            result.setHosts(hosts);
        }
        return result;
    }

    private void readVersionConstraint(VersionConstraintImpl version, DataInputStream in) throws IOException {
        version.setName(this.readString(in, false));
        version.setVersionRange(this.readVersionRange(in));
    }

    private void skipVersionConstraint(DataInputStream in) throws IOException {
        this.skipString(in);
        this.skipVersionRange(in);
    }

    private Version readVersion(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return Version.emptyVersion;
        }
        int majorComponent = in.readInt();
        int minorComponent = in.readInt();
        int serviceComponent = in.readInt();
        String qualifierComponent = this.readString(in, false);
        Version result = new Version(majorComponent, minorComponent, serviceComponent, qualifierComponent);
        return result;
    }

    private void skipVersion(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return;
        }
        in.readInt();
        in.readInt();
        in.readInt();
        this.skipString(in);
    }

    private VersionRange readVersionRange(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        return new VersionRange(this.readVersion(in), in.readBoolean(), this.readVersion(in), in.readBoolean());
    }

    private void skipVersionRange(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return;
        }
        this.skipVersion(in);
        in.readBoolean();
        this.skipVersion(in);
        in.readBoolean();
    }

    public final boolean loadStateDeprecated(StateImpl state, DataInputStream input, long expectedTimestamp) throws IOException {
        boolean bl;
        try {
            bl = this.readStateDeprecated(state, input, expectedTimestamp);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return bl;
    }

    public final boolean loadState(StateImpl state, long expectedTimestamp) throws IOException {
        return this.readState(state, this.stateFile, this.lazyFile, expectedTimestamp);
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        String result = intern ? in.readUTF().intern() : in.readUTF();
        WeakReference ref = (WeakReference)this.stringCache.get(result);
        if (ref != null) {
            String refString = (String)ref.get();
            if (refString != null) {
                result = refString;
            }
        } else {
            this.stringCache.put(result, new WeakReference<String>(result));
        }
        return result;
    }

    private void skipString(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return;
        }
        int utfLength = in.readUnsignedShort();
        byte[] bytearr = new byte[utfLength];
        in.readFully(bytearr, 0, utfLength);
    }

    private byte readTag(DataInputStream in) throws IOException {
        return in.readByte();
    }

    private DataInputStream openLazyFile() throws IOException {
        if (this.lazyFile == null) {
            throw new IOException();
        }
        return new DataInputStream(new BufferedInputStream(SecureAction.getFileInputStream(this.lazyFile), 65536));
    }

    boolean isLazyLoaded() {
        return this.lazyLoad;
    }

    /*
     * Exception decompiling
     */
    synchronized void fullyLoad() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 65->69)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    synchronized void fullyLoad(BundleDescriptionImpl target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 79->83)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addDependencies(BundleDescriptionImpl target, List toLoad) {
        if (toLoad.contains(target)) {
            return;
        }
        toLoad.add(target);
        List deps = target.getBundleDependencies();
        Iterator iter = deps.iterator();
        while (iter.hasNext()) {
            this.addDependencies((BundleDescriptionImpl)iter.next(), toLoad);
        }
    }
}

