/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.condpermadmin.Condition;

public class BundleSymbolicNameCondition
implements Condition {
    private boolean satisfied;

    public BundleSymbolicNameCondition(Bundle bundle, String nameExp) throws InvalidSyntaxException {
        FilterImpl filter = new FilterImpl("(name=" + nameExp + ")");
        Hashtable<String, String> dict = new Hashtable<String, String>(1);
        dict.put("name", bundle.getSymbolicName());
        this.satisfied = filter.match(dict);
    }

    public BundleSymbolicNameCondition(Bundle bundle, String nameExp, String versionExp) throws InvalidSyntaxException {
        this(bundle, nameExp);
        if (this.satisfied) {
            AbstractBundle realBundle = (AbstractBundle)bundle;
            VersionRange range = new VersionRange(versionExp);
            this.satisfied = range.isIncluded(realBundle.getVersion());
        }
    }

    public boolean isEvaluated() {
        return true;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isSatisfied(Condition[] conds, Dictionary context) {
        int i = 0;
        while (i < conds.length) {
            if (!conds[i].isSatisfied()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

