/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    private TableItem[] selection = new TableItem[0];
    private int currentEffect = 0;
    private TableItem dropSelection;
    private TableItem scrollItem;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 400;
    private static final int SCROLL_WIDTH = 100;

    TableDragUnderEffect(Table table) {
        this.table = table;
    }

    void show(int effect, int x, int y) {
        TableItem item = this.findItem(x, y);
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect == 0 && effect != 0) {
            this.selection = this.table.getSelection();
            this.table.deselectAll();
        }
        this.scrollHover(effect, item, x, y);
        this.setDragUnderEffect(effect, item);
        if (this.currentEffect != 0 && effect == 0) {
            this.table.setSelection(this.selection);
            this.selection = new TableItem[0];
        }
        this.currentEffect = effect;
    }

    private TableItem findItem(int x, int y) {
        if (this.table == null) {
            return null;
        }
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item != null) {
            return item;
        }
        Rectangle area = this.table.getClientArea();
        int x1 = area.x;
        while (x1 < area.x + area.width) {
            coordinates = new Point(x1, y);
            item = this.table.getItem(coordinates = this.table.toControl(coordinates));
            if (item != null) {
                return item;
            }
            ++x1;
        }
        return null;
    }

    private void setDragUnderEffect(int effect, TableItem item) {
        if ((effect & 1) != 0) {
            this.setDropSelection(item);
            return;
        }
        if ((this.currentEffect & 1) != 0) {
            this.setDropSelection(null);
        }
    }

    private void setDropSelection(TableItem item) {
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null) {
            this.table.deselectAll();
        }
        this.dropSelection = item;
        if (this.dropSelection != null) {
            this.table.setSelection(new TableItem[]{this.dropSelection});
        }
    }

    private void scrollHover(int effect, TableItem item, int x, int y) {
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
            return;
        }
        if (this.scrollItem == item && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                this.scroll(item, x, y);
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
            return;
        }
        this.scrollBeginTime = System.currentTimeMillis() + 400L;
        this.scrollItem = item;
    }

    private void scroll(TableItem item, int x, int y) {
        if (item == null) {
            return;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        Rectangle area = this.table.getClientArea();
        TableItem showItem = null;
        int itemIndex = this.table.indexOf(item);
        if (coordinates.y - area.y < 100) {
            showItem = this.table.getItem(Math.max(0, itemIndex - 1));
        } else if (area.y + area.height - coordinates.y < 100) {
            showItem = this.table.getItem(Math.min(this.table.getItemCount() - 1, itemIndex + 1));
        }
        if (showItem != null) {
            this.table.showItem(showItem);
        }
    }
}

