/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private int currentEffect = 0;
    private TreeItem[] selection = new TreeItem[0];
    private TreeItem dropSelection = null;
    private TreeItem insertMark = null;
    private boolean insertBefore = false;
    private TreeItem scrollItem;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 400;
    private static final int SCROLL_WIDTH = 100;
    private TreeItem expandItem;
    private long expandBeginTime;
    private static final int EXPAND_HYSTERESIS = 1000;

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
    }

    void show(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        TreeItem item = this.findItem(x, y);
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect == 0 && effect != 0) {
            this.selection = this.tree.getSelection();
            this.tree.deselectAll();
        }
        this.scrollHover(effect, item, x, y);
        this.expandHover(effect, item, x, y);
        this.setDragUnderEffect(effect, item);
        if (this.currentEffect != 0 && effect == 0) {
            this.tree.setSelection(this.selection);
            this.selection = new TreeItem[0];
        }
        this.currentEffect = effect;
    }

    private int checkEffect(int effect) {
        int mask = 7;
        int bits = effect & mask;
        if (bits == 4 || bits == 2 || bits == 1) {
            return effect;
        }
        return effect & ~mask;
    }

    private TreeItem findItem(int x, int y) {
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        Rectangle area = this.tree.getClientArea();
        if (!area.contains(coordinates)) {
            return null;
        }
        TreeItem item = this.tree.getItem(coordinates);
        if (item != null) {
            return item;
        }
        int x1 = area.x;
        while (x1 < area.x + area.width) {
            coordinates = new Point(x1, coordinates.y);
            item = this.tree.getItem(coordinates);
            if (item != null) {
                return item;
            }
            ++x1;
        }
        coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        if (coordinates.y > area.y + area.height - this.tree.getItemHeight()) {
            int y1 = area.y + area.height - this.tree.getItemHeight();
            coordinates = new Point(coordinates.x, y1);
            item = this.tree.getItem(coordinates);
            if (item != null) {
                return item;
            }
            int x12 = area.x;
            while (x12 < area.x + area.width) {
                coordinates = new Point(x12, y1);
                item = this.tree.getItem(coordinates);
                if (item != null) {
                    return item;
                }
                ++x12;
            }
        }
        return null;
    }

    private void setDragUnderEffect(int effect, TreeItem item) {
        if ((effect & 1) != 0) {
            if ((this.currentEffect & 4) != 0 || (this.currentEffect & 2) != 0) {
                this.tree.setInsertMark(null, false);
            }
            this.setDropSelection(item);
            return;
        }
        if ((effect & 4) != 0 || (effect & 2) != 0) {
            if ((this.currentEffect & 1) != 0) {
                this.setDropSelection(null);
            }
            this.setInsertMark(item, (effect & 2) != 0);
            return;
        }
        this.setInsertMark(null, false);
        this.setDropSelection(null);
    }

    private void setDropSelection(TreeItem item) {
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null) {
            this.tree.deselectAll();
        }
        this.dropSelection = item;
        if (this.dropSelection != null) {
            this.tree.setSelection(new TreeItem[]{this.dropSelection});
        }
    }

    private void setInsertMark(TreeItem item, boolean before) {
        if (item == this.insertMark && before == this.insertBefore) {
            return;
        }
        this.insertMark = item;
        this.insertBefore = before;
        this.tree.setInsertMark(item, before);
    }

    private void scrollHover(int effect, TreeItem item, int x, int y) {
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
            return;
        }
        if (this.scrollItem == item && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                this.scroll(item, x, y);
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
            return;
        }
        this.scrollBeginTime = System.currentTimeMillis() + 400L;
        this.scrollItem = item;
    }

    private void scroll(TreeItem item, int x, int y) {
        if (item == null) {
            return;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        Rectangle area = this.tree.getClientArea();
        TreeItem showItem = null;
        if (coordinates.y - area.y < 100) {
            showItem = this.getPreviousVisibleItem(item);
        } else if (area.y + area.height - coordinates.y < 100) {
            showItem = this.getNextVisibleItem(item, true);
        }
        if (showItem != null) {
            this.tree.showItem(showItem);
        }
    }

    private void expandHover(int effect, TreeItem item, int x, int y) {
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
            return;
        }
        if (this.expandItem == item && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                this.expand(item, x, y);
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
            return;
        }
        this.expandBeginTime = System.currentTimeMillis() + 1000L;
        this.expandItem = item;
    }

    private void expand(TreeItem item, int x, int y) {
        if (item == null || item.getExpanded()) {
            return;
        }
        Event event = new Event();
        event.x = x;
        event.y = y;
        event.item = item;
        event.time = (int)System.currentTimeMillis();
        this.tree.notifyListeners(17, event);
        if (item.isDisposed()) {
            return;
        }
        item.setExpanded(true);
    }

    private TreeItem getNextVisibleItem(TreeItem item, boolean includeChildren) {
        if (includeChildren && item.getItemCount() > 0 && item.getExpanded()) {
            return item.getItems()[0];
        }
        TreeItem parent = item.getParentItem();
        TreeItem[] peers = parent != null ? parent.getItems() : this.tree.getItems();
        int i = 0;
        while (i < peers.length - 1) {
            if (peers[i] == item) {
                return peers[i + 1];
            }
            ++i;
        }
        if (parent != null) {
            return this.getNextVisibleItem(parent, false);
        }
        return null;
    }

    private TreeItem getPreviousVisibleItem(TreeItem item) {
        TreeItem parent = item.getParentItem();
        TreeItem[] peers = parent != null ? parent.getItems() : this.tree.getItems();
        int i = peers.length - 1;
        while (i > 0) {
            if (peers[i] == item) {
                TreeItem peer = peers[i - 1];
                if (!peer.getExpanded() || peer.getItemCount() == 0) {
                    return peer;
                }
                TreeItem[] peerItems = peer.getItems();
                return peerItems[peerItems.length - 1];
            }
            --i;
        }
        return parent;
    }
}

