/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    short[] getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        int width = this.caret.width;
        if (width <= 0) {
            width = 2;
        }
        return new short[]{(short)(this.caret.x + width), (short)(this.caret.y + this.caret.height)};
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        boolean disjoint;
        int xDisplay;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        XAnyEvent xEvent = new XAnyEvent();
        OS.XSync(xDisplay, false);
        OS.XSync(xDisplay, false);
        while (OS.XCheckWindowEvent(xDisplay, xWindow, 32768, xEvent)) {
            OS.XtDispatchEvent(xEvent);
        }
        int xGC = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XCopyArea(xDisplay, xWindow, xWindow, xGC, x, y, width, height, destX, destY);
        OS.XFreeGC(xDisplay, xGC);
        boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
        if (disjoint) {
            OS.XClearArea(xDisplay, xWindow, x, y, width, height, true);
        } else {
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                OS.XClearArea(xDisplay, xWindow, newX, y, Math.abs(deltaX), height, true);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                OS.XClearArea(xDisplay, xWindow, x, newY, width, Math.abs(deltaY), true);
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.caret != null) {
            this.caret.setFont(font);
        }
    }

    void updateCaret() {
        if (this.caret == null) {
            return;
        }
        if (!OS.IsDBLocale) {
            return;
        }
        short[] point = this.getIMCaretPos();
        int ptr = OS.XtMalloc(4);
        OS.memmove(ptr, point, 4);
        int[] argList = new int[]{OS.XmNspotLocation, ptr};
        OS.XmImSetValues(this.handle, argList, argList.length / 2);
        if (ptr != 0) {
            OS.XtFree(ptr);
        }
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.XExposure(w, client_data, call_data, continue_to_dispatch);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusIn() {
        int result = super.xFocusIn();
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusOut() {
        int result = super.xFocusOut();
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }
}

