/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.PlatformURLConfigConnection;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLMetaConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.service.systembundle.EntryLocator;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static final String NL_SYSTEM_BUNDLE = "org.eclipse.osgi.nl";
    private static final String NL_PROP_EXT = ".properties";
    private static BundleContext context;
    private ServiceReference environmentServiceReference;
    private ServiceReference urlServiceReference;
    private ServiceReference logServiceReference;
    private ServiceReference packageAdminReference;
    private ServiceRegistration entryLocatorRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext runtimeContext) throws Exception {
        context = runtimeContext;
        this.acquireInfoService();
        this.acquireURLConverterService();
        this.acquireFrameworkLogService();
        this.acquirePackageAdminService();
        this.registerEntryLocator();
        this.startInternalPlatform();
        this.startRegistry(runtimeContext);
        ContentTypeManager.startup();
        this.installPlatformURLSupport();
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(runtimeContext);
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLMetaConnection.startup();
        PlatformURLConfigConnection.startup();
        PlatformURLBaseConnection.startup(InternalPlatform.getDefault().getInstallURL());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.url.URLStreamHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)new PlatformURLHandler(), properties);
    }

    private void startRegistry(BundleContext runtimeContext) {
        InternalPlatform.getDefault().setExtensionRegistry(new ExtensionRegistry());
    }

    public void stop(BundleContext runtimeContext) {
        ContentTypeManager.shutdown();
        this.stopRegistry(runtimeContext);
        this.unregisterEntryLocator();
        this.environmentInfoServiceReleased(this.environmentServiceReference);
        this.urlServiceReleased(this.urlServiceReference);
        this.logServiceReleased(this.logServiceReference);
        this.packageAdminServiceReleased(this.packageAdminReference);
        InternalPlatform.getDefault().stop(runtimeContext);
        InternalPlatform.getDefault().setRuntimeInstance(null);
        InternalPlatform.getDefault().getRuntimeFileManager().close();
    }

    private void stopRegistry(BundleContext runtimeContext) {
        ExtensionRegistry registry = (ExtensionRegistry)InternalPlatform.getDefault().getRegistry();
        if (registry == null) {
            return;
        }
        registry.stop();
        InternalPlatform.getDefault().setExtensionRegistry(null);
    }

    private void acquireInfoService() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.environmentServiceReference = context.getServiceReference(clazz.getName());
        if (this.environmentServiceReference == null) {
            return;
        }
        InternalPlatform.infoService = (EnvironmentInfo)context.getService(this.environmentServiceReference);
    }

    private void acquireURLConverterService() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.urlconversion.URLConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.urlServiceReference = context.getServiceReference(clazz.getName());
        if (this.urlServiceReference == null) {
            return;
        }
        InternalPlatform.urlConverter = (URLConverter)context.getService(this.urlServiceReference);
    }

    private void acquireFrameworkLogService() throws Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logServiceReference = context.getServiceReference(clazz.getName());
        if (this.logServiceReference == null) {
            return;
        }
        InternalPlatform.frameworkLog = (FrameworkLog)context.getService(this.logServiceReference);
    }

    private void acquirePackageAdminService() throws Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminReference = context.getServiceReference(clazz.getName());
        if (this.packageAdminReference == null) {
            return;
        }
        InternalPlatform.packageAdmin = (PackageAdmin)context.getService(this.packageAdminReference);
    }

    private void startInternalPlatform() throws IOException {
        InternalPlatform.getDefault().start(context);
    }

    private void environmentInfoServiceReleased(ServiceReference reference) {
        if (this.environmentServiceReference == null) {
            return;
        }
        if (this.environmentServiceReference != reference) {
            return;
        }
        InternalPlatform.infoService = null;
        context.ungetService(this.environmentServiceReference);
        this.environmentServiceReference = null;
    }

    private void urlServiceReleased(ServiceReference reference) {
        if (this.urlServiceReference == null) {
            return;
        }
        if (this.urlServiceReference != reference) {
            return;
        }
        InternalPlatform.urlConverter = null;
        context.ungetService(this.urlServiceReference);
        this.urlServiceReference = null;
    }

    private void logServiceReleased(ServiceReference reference) {
        if (this.logServiceReference == null) {
            return;
        }
        if (this.logServiceReference != reference) {
            return;
        }
        InternalPlatform.frameworkLog = null;
        context.ungetService(this.logServiceReference);
        this.logServiceReference = null;
    }

    private void packageAdminServiceReleased(ServiceReference reference) {
        if (this.packageAdminReference == null) {
            return;
        }
        if (this.packageAdminReference != reference) {
            return;
        }
        InternalPlatform.packageAdmin = null;
        context.ungetService(this.packageAdminReference);
        this.packageAdminReference = null;
    }

    private void registerApplicationService() {
        ParameterizedRunnable work = new ParameterizedRunnable(){

            public Object run(Object arg) throws Exception {
                Object result;
                IProduct product;
                IPlatformRunnable application = null;
                String applicationId = System.getProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION);
                if (applicationId == null && (product = InternalPlatform.getDefault().getProduct()) != null && (applicationId = product.getApplication()) != null) {
                    System.setProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION, applicationId);
                }
                if (applicationId == null) {
                    throw new RuntimeException(Messages.application_noIdFound);
                }
                IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
                IExtension applicationExtension = registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                if (applicationExtension == null) {
                    IExtension[] availableApps = registry.getExtensionPoint("org.eclipse.core.runtime.applications").getExtensions();
                    String availableAppsString = "<NONE>";
                    if (availableApps.length != 0) {
                        availableAppsString = availableApps[0].getUniqueIdentifier();
                        int i = 1;
                        while (i < availableApps.length) {
                            availableAppsString = String.valueOf(availableAppsString) + ", " + availableApps[i].getUniqueIdentifier();
                            ++i;
                        }
                    }
                    throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)applicationId, (Object)availableAppsString));
                }
                IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                if (configs.length == 0) {
                    throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)applicationId));
                }
                IConfigurationElement config = configs[0];
                application = (IPlatformRunnable)config.createExecutableExtension("run");
                if (arg == null) {
                    arg = InternalPlatform.getDefault().getApplicationArgs();
                }
                int exitCode = (result = application.run(arg)) instanceof Integer ? (Integer)result : 0;
                System.setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
                if (InternalPlatform.DEBUG) {
                    System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{applicationId, result == null ? "null" : result.toString()}));
                }
                return result;
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put(PROP_ECLIPSE_APPLICATION, "default");
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)work, properties);
    }

    private void registerEntryLocator() {
        EntryLocator systemResources = new EntryLocator(){

            public URL getProperties(String basename, Locale locale) {
                basename = basename.replace('.', '/');
                Path propertiesPath = new Path("org.eclipse.osgi.nl/" + basename + '_' + locale.getLanguage() + '_' + locale.getCountry() + PlatformActivator.NL_PROP_EXT);
                URL result = Platform.find(PlatformActivator.getContext().getBundle(), propertiesPath);
                if (result != null) {
                    return result;
                }
                propertiesPath = new Path("org.eclipse.osgi.nl/" + basename + '_' + locale.getLanguage() + PlatformActivator.NL_PROP_EXT);
                return Platform.find(PlatformActivator.getContext().getBundle(), propertiesPath);
            }
        };
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.osgi.service.systembundle.EntryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.entryLocatorRegistration = context.registerService(clazz.getName(), (Object)systemResources, null);
    }

    private void unregisterEntryLocator() {
        if (this.entryLocatorRegistration != null) {
            this.entryLocatorRegistration.unregister();
            this.entryLocatorRegistration = null;
        }
    }
}

