/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class PlatformURLConfigConnection
extends PlatformURLConnection {
    private static boolean isRegistered = false;
    public static final String CONFIG = "config";
    static /* synthetic */ Class class$0;

    public PlatformURLConfigConnection(URL url) {
        super(url);
    }

    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(CONFIG)) {
            throw new IOException(NLS.bind((String)Messages.url_badVariant, (Object)this.url.toString()));
        }
        String path = spec.substring(CONFIG.length() + 1);
        return new URL(Platform.getConfigurationLocation().getURL(), path);
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLConfigConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(CONFIG, clazz);
        isRegistered = true;
    }

    public OutputStream getOutputStream() throws IOException {
        String fileString;
        URL resolved = this.getResolvedURL();
        if (resolved != null && (fileString = resolved.getFile()) != null) {
            File file = new File(fileString);
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

