/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.argosdic.action.ActionMap;
import org.argosdic.action.BaseAction;
import org.argosdic.action.program.BackAction;
import org.argosdic.action.program.ForwardAction;
import org.argosdic.action.program.SearchAction;
import org.argosdic.action.program.SpeakAction;
import org.argosdic.action.program.SpellCheckAction;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryManager;
import org.argosdic.dictionary.DictionaryServer;
import org.argosdic.dictionary.HistoryListener;
import org.argosdic.dictionary.SearchHistory;
import org.argosdic.preference.ArgosDicPreferenceStore;
import org.argosdic.resource.ResourceManager;
import org.argosdic.speech.SpeechManager;
import org.argosdic.util.ExceptionHandler;
import org.argosdic.widget.ArgosDicMenuManager;
import org.argosdic.widget.ArgosDicToolBarManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class ArgosDic
extends ApplicationWindow {
    private static Log log = LogFactory.getLog(ArgosDic.class);
    private DictionaryServer server;
    private Browser browser;
    private List list;
    private Button searchButton;
    private Text combo;
    private ActionMap actionMap;
    private boolean skipTextModifiedEvent = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public ArgosDic() {
        super(null);
    }

    protected void configureShell(Shell shell) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring shell...");
        }
        this.actionMap = this.createActionMap();
        ResourceManager resources = ResourceManager.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing preference store...");
        }
        try {
            ArgosDicPreferenceStore preferences = new ArgosDicPreferenceStore();
            JFacePreferences.setPreferenceStore((IPreferenceStore)preferences);
        }
        catch (IOException e) {
            String msg = resources.getString("error.message.preferences");
            ExceptionHandler.handleException(msg, e);
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializing speech manager...");
                }
                SpeechManager manager = SpeechManager.getInstance();
            }
        });
        thread.start();
        this.setBlockOnOpen(true);
        this.addMenuBar();
        this.addToolBar(0x800000);
        this.addStatusLine();
        super.configureShell(shell);
        Window.setExceptionHandler((Window.IExceptionHandler)new ExceptionHandler());
        shell.setText(resources.getString("application.title"));
        shell.setImage(resources.getImage("application.icon").createImage());
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        shell.setBounds(location.x, location.y, size.x, size.y);
        try {
            this.server = new DictionaryServer();
            this.server.start();
        }
        catch (IOException e) {
            String msg = resources.getString("error.message.server");
            ExceptionHandler.handleException(msg, e);
            System.exit(-1);
        }
        SearchHistory history = this.server.getSearchHistory();
        history.addHistoryListener(new HistoryListener(){

            public void historyUpdated(Event event) {
                SearchHistory history = ArgosDic.this.server.getSearchHistory();
                ArgosDic.this.actionMap.get(BackAction.class.getName()).setEnabled(history.isBackEnabled());
                ArgosDic.this.actionMap.get(ForwardAction.class.getName()).setEnabled(history.isForwardEnabled());
            }
        });
    }

    protected ActionMap createActionMap() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing action map...");
        }
        ActionMap map = new ActionMap();
        ResourceManager resources = ResourceManager.getInstance();
        Collection actions = resources.getActionNames();
        for (String name : actions) {
            try {
                Constructor<?> constructor = Class.forName(name).getConstructors()[0];
                BaseAction action = (BaseAction)((Object)constructor.newInstance(new Object[]{this}));
                map.put(action);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to instantiate action class " + name), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loaded " + actions.size() + " action classes."));
        }
        return map;
    }

    private void showDefinition(String word) {
        this.combo.setText(word);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.server.getUrl());
        buffer.append("/");
        buffer.append(word);
        buffer.append(".dic");
        this.browser.setUrl(buffer.toString());
    }

    public void search() {
        String word = this.combo.getText();
        if (word != null && word.trim().length() > 0) {
            this.search(word, true);
        }
    }

    public void fuzzySearch() {
        String word = this.combo.getText();
        if (word != null && word.trim().length() > 0 && DictionaryServer.isSimpleQuery(word)) {
            word = word.concat("~");
            this.search(word, true);
        }
    }

    public void search(String word) {
        this.search(word, true);
    }

    public void search(String word, boolean updateHistory) {
        if (word != null) {
            try {
                if (!word.equals(this.combo.getText())) {
                    this.combo.setText(word);
                }
                this.run(true, false, new SearchWorker(word, updateHistory));
            }
            catch (Exception e) {
                ResourceManager resources = ResourceManager.getInstance();
                String msg = resources.getString("error.message.unknown");
                ExceptionHandler.handleException(msg, e);
            }
        }
    }

    protected MenuManager createMenuManager() {
        return new ArgosDicMenuManager(this);
    }

    protected ToolBarManager createToolBarManager(int style) {
        return new ArgosDicToolBarManager(this);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        ResourceManager resources = ResourceManager.getInstance();
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 1;
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        gridLayout1.horizontalSpacing = 0;
        gridLayout1.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout1);
        Composite panel = new Composite(composite, 0);
        panel.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        panel.setLayout((Layout)gridLayout2);
        Label label = new Label(panel, 0);
        GridData gridData1 = new GridData();
        gridData1.horizontalIndent = 3;
        label.setText(resources.getString("label.word"));
        label.setLayoutData((Object)gridData1);
        this.combo = new Text(panel, 2048);
        GridData gridData2 = new GridData(768);
        this.combo.setLayoutData((Object)gridData2);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArgosDic.this.handleTextModified();
            }
        });
        this.searchButton = new Button(panel, 8);
        this.searchButton.setEnabled(false);
        this.searchButton.setText(resources.getString("label.search"));
        this.searchButton.setToolTipText(resources.getString("label.search.tooltip"));
        this.searchButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ArgosDic.this.search();
            }
        });
        GridData gridData3 = new GridData();
        gridData3.widthHint = 100;
        this.searchButton.setLayoutData((Object)gridData3);
        this.getShell().setDefaultButton(this.searchButton);
        SashForm sash = new SashForm(composite, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.list = new List((Composite)sash, 2564);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (ArgosDic.this.list.getSelectionCount() > 0) {
                    String word = ArgosDic.this.list.getSelection()[0];
                    ArgosDic.this.showDefinition(word);
                }
            }
        });
        this.browser = new Browser((Composite)sash, 2112);
        this.browser.setUrl(String.valueOf(this.server.getUrl()) + "/index.html");
        sash.setWeights(new int[]{20, 80});
        this.combo.setFocus();
        Tray tray = this.getShell().getDisplay().getSystemTray();
        if (tray != null) {
            TrayItem trayItem = new TrayItem(tray, 0);
            trayItem.setText(this.getShell().getText());
            trayItem.setImage(resources.getImage("image.dictionary").createImage());
            trayItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    Shell shell;
                    shell.setVisible(!(shell = ArgosDic.this.getShell()).isVisible());
                }
            });
        }
        return composite;
    }

    protected Point getInitialLocation(Point initialSize) {
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        int x = preferences.getInt("location.x");
        int y = preferences.getInt("location.y");
        return new Point(x, y);
    }

    protected Point getInitialSize() {
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        int x = preferences.getInt("size.width");
        int y = preferences.getInt("size.height");
        return new Point(x, y);
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public String getSearchWord() {
        return this.combo.getText();
    }

    public SearchHistory getSearchHistory() {
        return this.server.getSearchHistory();
    }

    private void handleTextModified() {
        String keyword = this.combo.getText();
        int length = keyword.trim().length();
        boolean enabled = length > 0;
        this.searchButton.setEnabled(enabled);
        this.actionMap.get(SearchAction.class.getName()).setEnabled(enabled);
        this.actionMap.get(SpeakAction.class.getName()).setEnabled(enabled);
        this.actionMap.get(SpellCheckAction.class.getName()).setEnabled(DictionaryServer.isSimpleQuery(keyword));
    }

    protected void handleShellCloseEvent() {
        block7: {
            String msg;
            block6: {
                Shell shell = this.getShell();
                Point location = shell.getLocation();
                Point size = shell.getSize();
                super.handleShellCloseEvent();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Saving user preferences...");
                }
                ArgosDicPreferenceStore preferences = (ArgosDicPreferenceStore)JFacePreferences.getPreferenceStore();
                preferences.setValue("location.x", location.x);
                preferences.setValue("location.y", location.y);
                preferences.setValue("size.width", size.x);
                preferences.setValue("size.height", size.y);
                DictionaryManager manager = DictionaryManager.getInstance();
                Dictionary dictionary = manager.getSelectedDictionary();
                if (dictionary != null) {
                    preferences.setValue("default.dictionary", dictionary.getId());
                }
                SpeechManager.getInstance().dispose();
                try {
                    preferences.save();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block6;
                    msg = "Failed to save user preferences data.";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
            try {
                this.server.stop();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block7;
                msg = "Failed to stop dictionary server.";
                log.warn((Object)msg, (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            try {
                ArgosDic application = new ArgosDic();
                application.open();
            }
            catch (Throwable t) {
                if (log.isFatalEnabled()) {
                    String msg = "Unable to initialize application.";
                    log.fatal((Object)msg, t);
                }
            }
        }
        finally {
            Display.getCurrent().dispose();
            System.exit(0);
        }
    }

    private class SearchWorker
    implements IRunnableWithProgress,
    Runnable {
        private String word;
        private boolean updateHistory;
        private Hits hits;

        SearchWorker(String word, boolean updateHistory) {
            Assert.isNotNull((Object)word);
            this.word = word;
            this.updateHistory = updateHistory;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    ResourceManager resources = ResourceManager.getInstance();
                    monitor.beginTask(resources.getString("label.progress"), -1);
                    this.hits = ArgosDic.this.server.search(this.word, this.updateHistory);
                    ArgosDic.this.getShell().getDisplay().syncExec((Runnable)this);
                }
                catch (Exception e) {
                    ArgosDic.this.getShell().getDisplay().syncExec(new Runnable(this, e){
                        final /* synthetic */ SearchWorker this$1;
                        private final /* synthetic */ Exception val$e;
                        {
                            this.this$1 = searchWorker;
                            this.val$e = exception;
                        }

                        public void run() {
                            ResourceManager resources = ResourceManager.getInstance();
                            String msg = resources.getString("error.message.unknown");
                            ExceptionHandler.handleException(msg, this.val$e);
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
        }

        public void run() {
            Assert.isNotNull((Object)this.hits);
            if (this.hits == null || this.hits.length() == 0) {
                ArgosDic.this.browser.setUrl(String.valueOf(ArgosDic.this.server.getUrl()) + "/index.html");
            } else {
                try {
                    int count = this.hits.length();
                    Object[] items = new String[count];
                    int i = 0;
                    while (i < count) {
                        Document document = this.hits.doc(i);
                        String entry = document.getField("word").stringValue();
                        if (count == 1) {
                            ArgosDic.this.skipTextModifiedEvent = true;
                            ArgosDic.this.combo.setText(entry);
                            ArgosDic.this.skipTextModifiedEvent = false;
                        }
                        items[i] = entry;
                        ++i;
                    }
                    Arrays.sort(items);
                    ArgosDic.this.list.setItems((String[])items);
                    ArgosDic.this.showDefinition(this.word);
                }
                catch (Exception e) {
                    ResourceManager resources = ResourceManager.getInstance();
                    String msg = resources.getString("error.message.unknown");
                    ExceptionHandler.handleException(msg, e);
                }
            }
        }
    }
}

