/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.widget;

import java.util.Iterator;
import org.argosdic.ArgosDic;
import org.argosdic.action.ActionMap;
import org.argosdic.action.dictionary.RefreshDictionariesAction;
import org.argosdic.action.dictionary.SetDictionaryAction;
import org.argosdic.action.help.AboutAction;
import org.argosdic.action.program.BackAction;
import org.argosdic.action.program.ForwardAction;
import org.argosdic.action.program.QuitAction;
import org.argosdic.action.program.SearchAction;
import org.argosdic.action.program.SettingsAction;
import org.argosdic.action.program.SpeakAction;
import org.argosdic.action.program.SpellCheckAction;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryEvent;
import org.argosdic.dictionary.DictionaryListener;
import org.argosdic.dictionary.DictionaryManager;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.Assert;

public class ArgosDicMenuManager
extends MenuManager {
    protected ActionMap actions;
    private ArgosDic application;
    private ResourceManager resources;
    private MenuManager dictionaryMenu;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public ArgosDicMenuManager(ArgosDic application) {
        Assert.isNotNull((Object)((Object)application));
        this.application = application;
        this.actions = application.getActionMap();
        this.resources = ResourceManager.getInstance();
        this.initialize();
    }

    protected void initialize() {
        this.add((IContributionItem)this.createProgramMenu());
        this.add((IContributionItem)this.createDictionaryMenu());
        this.add((IContributionItem)this.createHelpMenu());
        DictionaryManager manager = DictionaryManager.getInstance();
        manager.addDictionaryListener(new DictionaryListener(){

            public void dictionaryUpdated(DictionaryEvent event) {
                ArgosDicMenuManager.this.refreshDictionaryMenu();
            }

            public void dictionaryChanged(DictionaryEvent event) {
            }
        });
    }

    protected MenuManager createProgramMenu() {
        String name = this.resources.getString("menu.program");
        MenuManager manager = new MenuManager(name);
        manager.add((IAction)this.actions.get(SearchAction.class.getName()));
        manager.add((IAction)this.actions.get(SpellCheckAction.class.getName()));
        manager.add((IAction)this.actions.get(SpeakAction.class.getName()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.get(BackAction.class.getName()));
        manager.add((IAction)this.actions.get(ForwardAction.class.getName()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.get(SettingsAction.class.getName()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.get(QuitAction.class.getName()));
        return manager;
    }

    protected MenuManager createDictionaryMenu() {
        String name = this.resources.getString("menu.dictionary");
        this.dictionaryMenu = new MenuManager(name);
        this.refreshDictionaryMenu();
        return this.dictionaryMenu;
    }

    public void refreshDictionaryMenu() {
        if (this.dictionaryMenu != null) {
            this.dictionaryMenu.removeAll();
            this.dictionaryMenu.add((IContributionItem)new GroupMarker("dictionary"));
            IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
            String defaultId = preferences.getString("default.dictionary");
            DictionaryManager manager = DictionaryManager.getInstance();
            if (manager.getDictionary(defaultId) == null) {
                defaultId = null;
            }
            Iterator it = manager.getDictionaries();
            while (it.hasNext()) {
                Dictionary dictionary = (Dictionary)it.next();
                SetDictionaryAction action = new SetDictionaryAction(this.application, dictionary);
                if (defaultId == null) {
                    defaultId = dictionary.getId();
                }
                if (defaultId.equals(dictionary.getId())) {
                    manager.setSelectedDictionary(defaultId);
                    action.setChecked(true);
                }
                this.dictionaryMenu.appendToGroup("dictionary", (IAction)action);
            }
            this.dictionaryMenu.add((IContributionItem)new Separator());
            this.dictionaryMenu.add((IAction)this.actions.get(RefreshDictionariesAction.class.getName()));
        }
    }

    protected MenuManager createHelpMenu() {
        String name = this.resources.getString("menu.help");
        MenuManager manager = new MenuManager(name);
        manager.add((IAction)this.actions.get(AboutAction.class.getName()));
        return manager;
    }
}

