/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class MetaData {
    Properties properties = new Properties();
    File datafile;
    String header;

    public MetaData(File datafile, String header) {
        this.datafile = datafile;
        this.header = header;
    }

    public String get(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    public int getInt(String key, int def) {
        String result = this.get(key, null);
        if (result == null) {
            return def;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public long getLong(String key, long def) {
        String result = this.get(key, null);
        if (result == null) {
            return def;
        }
        try {
            return Long.parseLong(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public boolean getBoolean(String key, boolean def) {
        String result = this.get(key, null);
        if (result == null) {
            return def;
        }
        return Boolean.valueOf(result);
    }

    public void set(String key, String val) {
        this.properties.put(key, val);
    }

    public void setInt(String key, int val) {
        this.properties.put(key, Integer.toString(val));
    }

    public void setLong(String key, long val) {
        this.properties.put(key, Long.toString(val));
    }

    public void setBoolean(String key, boolean val) {
        this.properties.put(key, new Boolean(val).toString());
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.datafile);
        try {
            this.properties.store(fos, this.header);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            fos.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        fos.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws IOException {
        this.properties.clear();
        if (!this.datafile.exists()) return;
        FileInputStream fis = new FileInputStream(this.datafile);
        try {
            this.properties.load(fis);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            fis.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        fis.close();
    }

    public String toString() {
        return this.properties.toString();
    }
}

