/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Version;

public class ResolverExport
implements VersionSupplier {
    private ResolverBundle exporter;
    private ExportPackageDescription exportPackageDescription;
    private boolean reprovide = false;

    ResolverExport(ResolverBundle bundle, ExportPackageDescription export) {
        this.exporter = bundle;
        this.exportPackageDescription = export;
    }

    ResolverExport(ResolverBundle bundle, ExportPackageDescription export, boolean reprovide) {
        this(bundle, export);
        this.reprovide = reprovide;
    }

    public String getName() {
        return this.exportPackageDescription.getName();
    }

    public Version getVersion() {
        return this.exportPackageDescription.getVersion();
    }

    public BundleDescription getBundle() {
        return this.exportPackageDescription.getExporter();
    }

    ResolverBundle getExporter() {
        return this.exporter;
    }

    String getGrouping() {
        return this.exportPackageDescription.getGrouping();
    }

    ExportPackageDescription getExportPackageDescription() {
        return this.exportPackageDescription;
    }

    ResolverExport getRoot() {
        ResolverExport re = this;
        while (re != null && !re.getExportPackageDescription().isRoot()) {
            ResolverBundle reExporter = re.getExporter();
            ResolverImport ri = reExporter.getImport(re.getName());
            if (ri != null) {
                re = ri.getMatchingExport();
                continue;
            }
            ResolverExport root = this.getRootRequires(re, reExporter);
            if (root == re) continue;
            return root;
        }
        return re;
    }

    private ResolverExport getRootRequires(ResolverExport re, ResolverBundle reExporter) {
        BundleConstraint[] requires = reExporter.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    if (re.getName().equals(exports[j].getName())) {
                        return exports[j];
                    }
                    ++j;
                }
                if ((re = this.getRootRequires(re, requires[i].getMatchingBundle())).getExportPackageDescription().isRoot()) {
                    return re;
                }
            }
            ++i;
        }
        return re;
    }

    /*
     * Unable to fully structure code
     */
    boolean isOnRootPath(ResolverBundle rb) {
        re = this;
        if (re.getExporter() != rb) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            reExporter = re.getExporter();
            ri = reExporter.getImport(re.getName());
            if (!(ri != null ? (re = ri.getMatchingExport()).getExporter() == rb : (re = this.getRootRequires(re, reExporter)).getExporter() == rb)) continue;
            return true;
lbl8:
            // 2 sources

            ** while (re != null && !re.getExportPackageDescription().isRoot())
        }
lbl9:
        // 1 sources

        return false;
    }

    boolean isReprovide() {
        return this.reprovide;
    }

    public String toString() {
        return this.exportPackageDescription.toString();
    }
}

