/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;

public final class ExternalActionManager {
    private static ExternalActionManager instance;
    private ICallback callback;

    public static ExternalActionManager getInstance() {
        if (instance == null) {
            instance = new ExternalActionManager();
        }
        return instance;
    }

    private ExternalActionManager() {
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback callbackToUse) {
        this.callback = callbackToUse;
    }

    public static final class CommandCallback
    implements IBindingManagerListener,
    ICallback {
        private static final ResourceBundle RESOURCE_BUNDLE;
        private final IActiveChecker activeChecker;
        private final BindingManager bindingManager;
        private boolean bindingManagerListenerAttached = false;
        private final CommandManager commandManager;
        private final Set loggedCommandIds = new HashSet();
        private final Map registeredListeners = new HashMap();
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.action.ExternalActionManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager) {
            this(bindingManager, commandManager, new IActiveChecker(){

                public boolean isActive(String commandId) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker activeChecker) {
            if (bindingManager == null) {
                throw new NullPointerException("The callback needs a binding manager");
            }
            if (commandManager == null) {
                throw new NullPointerException("The callback needs a command manager");
            }
            if (activeChecker == null) {
                throw new NullPointerException("The callback needs an active callback");
            }
            this.activeChecker = activeChecker;
            this.bindingManager = bindingManager;
            this.commandManager = commandManager;
        }

        public final void addPropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            this.registeredListeners.put(commandId, listener);
            if (!this.bindingManagerListenerAttached) {
                this.bindingManager.addBindingManagerListener(this);
                this.bindingManagerListenerAttached = true;
            }
        }

        public final void bindingManagerChanged(BindingManagerEvent event) {
            if (event.haveActiveBindingsChanged()) {
                Iterator listenerItr = this.registeredListeners.values().iterator();
                while (listenerItr.hasNext()) {
                    IPropertyChangeListener listener = (IPropertyChangeListener)listenerItr.next();
                    listener.propertyChange(new PropertyChangeEvent(event.getManager(), "text", null, null));
                }
            }
        }

        public final Integer getAccelerator(String commandId) {
            Collection activeBindings = this.bindingManager.getActiveBindingsFor(commandId);
            Iterator bindingItr = activeBindings.iterator();
            Integer accelerator = null;
            while (bindingItr.hasNext()) {
                Trigger trigger;
                TriggerSequence triggerSequence = (TriggerSequence)bindingItr.next();
                List triggers = triggerSequence.getTriggers();
                if (triggers.size() != 1 || !((trigger = (Trigger)triggers.get(0)) instanceof KeyStroke)) continue;
                accelerator = new Integer(SWTKeySupport.convertKeyStrokeToAccelerator((KeyStroke)trigger));
                break;
            }
            return accelerator;
        }

        public final String getAcceleratorText(String commandId) {
            Collection activeBindings = this.bindingManager.getActiveBindingsFor(commandId);
            Iterator bindingItr = activeBindings.iterator();
            String acceleratorText = null;
            if (bindingItr.hasNext()) {
                TriggerSequence triggerSequence = (TriggerSequence)bindingItr.next();
                acceleratorText = triggerSequence.format();
            }
            return acceleratorText;
        }

        public final boolean isAcceleratorInUse(int accelerator) {
            KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(accelerator));
            return this.bindingManager.isPerfectMatch(keySequence) || this.bindingManager.isPartialMatch(keySequence);
        }

        public final boolean isActive(String commandId) {
            if (commandId != null) {
                Command command = this.commandManager.getCommand(commandId);
                if (!command.isDefined() && !this.loggedCommandIds.contains(commandId)) {
                    String message = MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "undefinedCommand.WarningMessage", null), command.getId());
                    Status status = new Status(4, "org.eclipse.jface", 0, message, (Throwable)new Exception());
                    Policy.getLog().log((IStatus)status);
                    this.loggedCommandIds.add(commandId);
                    command.addCommandListener(new ICommandListener(this, command, commandId){
                        final /* synthetic */ CommandCallback this$1;
                        private final /* synthetic */ Command val$command;
                        private final /* synthetic */ String val$commandId;
                        {
                            this.this$1 = commandCallback;
                            this.val$command = command;
                            this.val$commandId = string;
                        }

                        public final void commandChanged(CommandEvent commandEvent) {
                            if (this.val$command.isDefined()) {
                                this.val$command.removeCommandListener((ICommandListener)this);
                                CommandCallback.access$0(this.this$1).remove(this.val$commandId);
                            }
                        }
                    });
                    return true;
                }
                return this.activeChecker.isActive(commandId);
            }
            return true;
        }

        public final void removePropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            IPropertyChangeListener existingListener = (IPropertyChangeListener)this.registeredListeners.get(commandId);
            if (existingListener == listener) {
                this.registeredListeners.remove(commandId);
                if (this.registeredListeners.isEmpty()) {
                    this.bindingManager.removeBindingManagerListener(this);
                    this.bindingManagerListenerAttached = false;
                }
            }
        }

        static /* synthetic */ Set access$0(CommandCallback commandCallback) {
            return commandCallback.loggedCommandIds;
        }
    }

    public static interface IActiveChecker {
        public boolean isActive(String var1);
    }

    public static interface ICallback {
        public void addPropertyChangeListener(String var1, IPropertyChangeListener var2);

        public Integer getAccelerator(String var1);

        public String getAcceleratorText(String var1);

        public boolean isAcceleratorInUse(int var1);

        public boolean isActive(String var1);

        public void removePropertyChangeListener(String var1, IPropertyChangeListener var2);
    }
}

