package org.argosdic.search;

import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

/**
 * EnglishAnalyzer.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/21 14:38:05 $
 */
public class EnglishAnalyzer extends Analyzer {
    /**
     * @see org.apache.lucene.analysis.Analyzer#tokenStream(java.lang.String, java.io.Reader)
     */
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream stream = new StandardTokenizer(reader);
        stream = new StandardFilter(stream);
        stream = new LowerCaseFilter(stream);
        stream = new PorterStemFilter(stream);

        return stream;
    }
}
