/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.BaseEngine;
import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.synthesis.BaseSynthesizerProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.BaseVoice;
import com.sun.speech.engine.synthesis.VoiceList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.speech.EngineListener;
import javax.speech.EngineModeDesc;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.synthesis.JSMLException;
import javax.speech.synthesis.Speakable;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerEvent;
import javax.speech.synthesis.SynthesizerListener;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;

public abstract class BaseSynthesizer
extends BaseEngine
implements Synthesizer,
SpeechEventDispatcher {
    protected Vector speakableListeners = new Vector();
    protected VoiceList voiceList;

    public BaseSynthesizer(SynthesizerModeDesc synthesizerModeDesc) {
        super((EngineModeDesc)synthesizerModeDesc);
        this.voiceList = new VoiceList(synthesizerModeDesc);
    }

    public void speak(Speakable speakable, SpeakableListener speakableListener) throws JSMLException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this.createQueueItem();
        baseSynthesizerQueueItem.setData(this, speakable, speakableListener);
        this.appendQueue(baseSynthesizerQueueItem);
    }

    public void speak(URL uRL, SpeakableListener speakableListener) throws JSMLException, MalformedURLException, IOException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this.createQueueItem();
        baseSynthesizerQueueItem.setData(this, uRL, speakableListener);
        this.appendQueue(baseSynthesizerQueueItem);
    }

    public void speak(String string, SpeakableListener speakableListener) throws JSMLException, EngineStateError {
        this.checkEngineState(9L);
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this.createQueueItem();
        baseSynthesizerQueueItem.setData(this, string, false, speakableListener);
        this.appendQueue(baseSynthesizerQueueItem);
    }

    public void speakPlainText(String string, SpeakableListener speakableListener) throws EngineStateError {
        this.checkEngineState(9L);
        try {
            BaseSynthesizerQueueItem baseSynthesizerQueueItem = this.createQueueItem();
            baseSynthesizerQueueItem.setData(this, string, true, speakableListener);
            this.appendQueue(baseSynthesizerQueueItem);
        }
        catch (JSMLException jSMLException) {
            throw new RuntimeException("JSMLException should never occur");
        }
    }

    protected String stateToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((l & 0x10000L) != 0L) {
            stringBuffer.append(" QUEUE_EMPTY ");
        }
        if ((l & 0x20000L) != 0L) {
            stringBuffer.append(" QUEUE_NOT_EMPTY ");
        }
        return super.stateToString(l) + stringBuffer.toString();
    }

    protected abstract void appendQueue(BaseSynthesizerQueueItem var1);

    public String phoneme(String string) throws EngineStateError {
        this.checkEngineState(9L);
        return null;
    }

    public abstract Enumeration enumerateQueue() throws EngineStateError;

    public abstract void cancel() throws EngineStateError;

    public abstract void cancel(Object var1) throws IllegalArgumentException, EngineStateError;

    public abstract void cancelAll() throws EngineStateError;

    public SynthesizerProperties getSynthesizerProperties() {
        this.checkEngineState(9L);
        return (SynthesizerProperties)this.getEngineProperties();
    }

    public void addSpeakableListener(SpeakableListener speakableListener) {
        if (!this.speakableListeners.contains(speakableListener)) {
            this.speakableListeners.addElement(speakableListener);
        }
    }

    public void removeSpeakableListener(SpeakableListener speakableListener) {
        this.speakableListeners.removeElement(speakableListener);
    }

    protected BaseEngineProperties createEngineProperties() {
        SynthesizerModeDesc synthesizerModeDesc = (SynthesizerModeDesc)this.engineModeDesc;
        BaseVoice baseVoice = (BaseVoice)synthesizerModeDesc.getVoices()[0];
        float f = baseVoice.defaultPitch;
        float f2 = baseVoice.defaultPitchRange;
        float f3 = baseVoice.defaultSpeakingRate;
        float f4 = baseVoice.defaultVolume;
        return new BaseSynthesizerProperties(baseVoice, f, f2, f3, f4);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new BaseSynthesizerQueueItem();
    }

    protected VoiceList getVoiceList() {
        return this.voiceList;
    }

    public void postQueueUpdated(boolean bl, long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SynthesizerEvent((Synthesizer)this, 701, bl, l, l2));
    }

    public void fireQueueUpdated(SynthesizerEvent synthesizerEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            if (!(engineListener instanceof SynthesizerListener)) continue;
            SynthesizerListener synthesizerListener = (SynthesizerListener)engineListener;
            synthesizerListener.queueUpdated(synthesizerEvent);
        }
    }

    public void postQueueEmptied(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SynthesizerEvent((Synthesizer)this, 700, false, l, l2));
    }

    public void fireQueueEmptied(SynthesizerEvent synthesizerEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            if (!(engineListener instanceof SynthesizerListener)) continue;
            SynthesizerListener synthesizerListener = (SynthesizerListener)engineListener;
            synthesizerListener.queueEmptied(synthesizerEvent);
        }
    }

    public void dispatchSpeechEvent(SpeechEvent speechEvent) {
        switch (speechEvent.getId()) {
            case 700: {
                this.fireQueueEmptied((SynthesizerEvent)speechEvent);
                break;
            }
            case 701: {
                this.fireQueueUpdated((SynthesizerEvent)speechEvent);
                break;
            }
            default: {
                super.dispatchSpeechEvent(speechEvent);
            }
        }
    }
}

