/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.EngineMonitor;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.speech.Engine;
import javax.speech.EngineEvent;
import javax.speech.EngineListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerEvent;
import javax.speech.synthesis.SynthesizerListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SynthesizerMonitor
extends EngineMonitor {
    protected JLabel queueEmptyLabel;
    protected JLabel queueNotEmptyLabel;
    protected JLabel queueSizeLabel;

    public SynthesizerMonitor(Synthesizer synthesizer) {
        super((Engine)synthesizer);
    }

    protected EngineListener getEngineListener() {
        if (this.engineListener == null) {
            this.engineListener = new SynthesizerMonitorEngineListener();
        }
        return this.engineListener;
    }

    public Component getStatePanel() {
        if (this.statePanel == null) {
            this.statePanel = (JPanel)super.getStatePanel();
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Synthesizer State:"));
            jPanel.setLayout(new GridLayout(4, 1));
            this.queueEmptyLabel = new JLabel("QUEUE_EMPTY");
            this.queueNotEmptyLabel = new JLabel("QUEUE_NOT_EMPTY");
            this.queueSizeLabel = new JLabel("Queue Size: XXX");
            jPanel.add(this.queueEmptyLabel);
            jPanel.add(this.queueNotEmptyLabel);
            jPanel.add(this.queueSizeLabel);
            this.statePanel.add(jPanel);
        }
        return this.statePanel;
    }

    protected void updateGUIComponents() {
        super.updateGUIComponents();
        if (this.statePanel != null) {
            this.queueEmptyLabel.setEnabled(this.engine.testEngineState(65536L));
            this.queueNotEmptyLabel.setEnabled(this.engine.testEngineState(131072L));
            Synthesizer synthesizer = (Synthesizer)this.engine;
            int n = this.countElements(synthesizer.enumerateQueue());
            this.queueSizeLabel.setText("Queue Size: " + n + "  ");
        }
    }

    private int countElements(Enumeration enumeration) {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    protected String engineStateString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBuffer(stringBuffer, super.engineStateString(l));
        if ((l & 0x10000L) != 0L) {
            this.appendBuffer(stringBuffer, "QUEUE_EMPTY");
        }
        if ((l & 0x20000L) != 0L) {
            this.appendBuffer(stringBuffer, "QUEUE_NOT_EMPTY");
        }
        return stringBuffer.toString();
    }

    protected void handleEvent(EngineEvent engineEvent) {
        super.handleEvent(engineEvent);
    }

    class SynthesizerMonitorEngineListener
    extends EngineMonitor.EngineMonitorEngineListener
    implements SynthesizerListener {
        public SynthesizerMonitorEngineListener() {
            super(SynthesizerMonitor.this);
        }

        public void queueEmptied(SynthesizerEvent synthesizerEvent) {
            SynthesizerMonitor.this.handleEvent((EngineEvent)synthesizerEvent);
        }

        public void queueUpdated(SynthesizerEvent synthesizerEvent) {
            SynthesizerMonitor.this.handleEvent((EngineEvent)synthesizerEvent);
        }
    }
}

