/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis.text;

import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.text.TextSynthesizerQueueItem;
import java.util.Enumeration;
import java.util.Vector;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SynthesizerModeDesc;

public class TextSynthesizer
extends BaseSynthesizer {
    OutputHandler outputHandler = new OutputHandler();

    public TextSynthesizer(SynthesizerModeDesc synthesizerModeDesc) {
        super(synthesizerModeDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAllocate() {
        long[] lArray;
        Object object = this.engineStateLock;
        synchronized (object) {
            long l = 516L;
            lArray = this.setEngineState(-1L, l |= this.outputHandler.isQueueEmpty() ? 65536L : 131072L);
        }
        this.outputHandler.start();
        this.postEngineAllocated(lArray[0], lArray[1]);
    }

    protected void handleDeallocate() {
        long[] lArray = this.setEngineState(-1L, 1L);
        this.cancelAll();
        this.outputHandler.terminate();
        this.postEngineDeallocated(lArray[0], lArray[1]);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new TextSynthesizerQueueItem();
    }

    public Enumeration enumerateQueue() throws EngineStateError {
        this.checkEngineState(9L);
        return this.outputHandler.enumerateQueue();
    }

    protected void appendQueue(BaseSynthesizerQueueItem baseSynthesizerQueueItem) {
        this.outputHandler.appendQueue((TextSynthesizerQueueItem)baseSynthesizerQueueItem);
    }

    public void cancel() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem();
    }

    public void cancel(Object object) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem(object);
    }

    public void cancelAll() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelAllItems();
    }

    protected void handlePause() {
        this.outputHandler.pauseItem();
    }

    protected void handleResume() {
        this.outputHandler.resumeItem();
    }

    static /* synthetic */ long[] access$101(TextSynthesizer textSynthesizer, long l, long l2) {
        return super.setEngineState(l, l2);
    }

    static /* synthetic */ long[] access$201(TextSynthesizer textSynthesizer, long l, long l2) {
        return super.setEngineState(l, l2);
    }

    static /* synthetic */ long[] access$301(TextSynthesizer textSynthesizer, long l, long l2) {
        return super.setEngineState(l, l2);
    }

    public class OutputHandler
    extends Thread {
        protected boolean done = false;
        protected Vector queue;
        TextSynthesizerQueueItem currentItem = null;
        protected Object currentItemLock = new Object();
        int rate = 100;
        protected int command;
        protected static final int PAUSE = 0;
        protected static final int RESUME = 1;
        protected static final int CANCEL = 2;
        protected static final int CANCEL_ALL = 3;
        protected static final int CANCEL_COMPLETE = 4;
        protected Object commandLock = new Object();

        public OutputHandler() {
            this.queue = new Vector();
        }

        public void terminate() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration enumerateQueue() {
            Vector vector = this.queue;
            synchronized (vector) {
                Enumeration enumeration = this.queue.elements();
                return enumeration;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isQueueEmpty() {
            Vector vector = this.queue;
            synchronized (vector) {
                boolean bl = this.queue.size() == 0;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendQueue(TextSynthesizerQueueItem textSynthesizerQueueItem) {
            boolean bl;
            Vector vector = this.queue;
            synchronized (vector) {
                bl = this.queue.size() == 0;
                this.queue.addElement(textSynthesizerQueueItem);
                this.queue.notifyAll();
            }
            if (bl) {
                long[] lArray = TextSynthesizer.super.setEngineState(65536L, 131072L);
                TextSynthesizer.this.postQueueUpdated(bl, lArray[0], lArray[1]);
            }
        }

        protected void cancelItem() {
            this.cancelItem(2);
        }

        protected void cancelAllItems() {
            this.cancelItem(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem(int n) {
            Vector vector = this.queue;
            synchronized (vector) {
                if (this.queue.size() == 0) {
                    return;
                }
            }
            Object object = this.commandLock;
            synchronized (object) {
                this.command = n;
                this.commandLock.notifyAll();
                while (this.command != 4) {
                    try {
                        this.commandLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.command = TextSynthesizer.this.testEngineState(256L) ? 0 : 1;
                this.commandLock.notifyAll();
            }
        }

        protected void cancelItem(Object object) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pauseItem() {
            Object object = this.commandLock;
            synchronized (object) {
                if (this.command != 0) {
                    this.command = 0;
                    this.commandLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resumeItem() {
            Object object = this.commandLock;
            synchronized (object) {
                if (this.command != 1) {
                    this.command = 1;
                    this.commandLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            this.command = TextSynthesizer.this.testEngineState(256L) ? 0 : 1;
            while (!this.done) {
                block19: {
                    var1_1 = this.getQueueItem();
                    var1_1.postTopOfQueue();
                    var2_2 = this.outputItem(var1_1);
                    if (var2_2 != 3) break block19;
                    var4_4 = new Vector<TextSynthesizerQueueItem>();
                    var4_4.add(var1_1);
                    var5_5 = this.queue;
                    synchronized (var5_5) {
                        this.queue.remove(0);
                        while (this.queue.size() > 0) {
                            var4_4.add(this.queue.remove(0));
                        }
                    }
                    var6_6 = this.commandLock;
                    synchronized (var6_6) {
                        this.command = 4;
                        this.commandLock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[1, 7, 12] lbl29 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (true) ** GOTO lbl34
                    }
                    do {
                        var1_1 = (TextSynthesizerQueueItem)var4_4.remove(0);
                        var1_1.postSpeakableCancelled();
lbl34:
                        // 2 sources

                    } while (var4_4.size() > 0);
                    var7_8 = TextSynthesizer.access$101(TextSynthesizer.this, 131072L, 65536L);
                    TextSynthesizer.this.postQueueEmptied(var7_8[0], var7_8[1]);
                    continue;
                }
                if (var2_2 == 2) {
                    var4_4 = this.commandLock;
                    synchronized (var4_4) {
                        this.command = 4;
                        this.commandLock.notifyAll();
                    }
                    var1_1.postSpeakableCancelled();
                } else if (var2_2 == 0 || var2_2 == 1) {
                    var1_1.postSpeakableEnded();
                }
                var4_4 = this.queue;
                synchronized (var4_4) {
                    this.queue.remove(0);
                    var3_3 = this.queue.size() == 0;
                    this.queue.notifyAll();
                }
                if (var3_3) {
                    var9_10 = TextSynthesizer.access$201(TextSynthesizer.this, 131072L, 65536L);
                    TextSynthesizer.this.postQueueEmptied(var9_10[0], var9_10[1]);
                    continue;
                }
                var9_10 = TextSynthesizer.access$301(TextSynthesizer.this, 131072L, 131072L);
                TextSynthesizer.this.postQueueUpdated(true, var9_10[0], var9_10[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected TextSynthesizerQueueItem getQueueItem() {
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return (TextSynthesizerQueueItem)this.queue.elementAt(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int outputItem(TextSynthesizerQueueItem textSynthesizerQueueItem) {
            int n;
            boolean bl = false;
            System.out.println("----- BEGIN: " + textSynthesizerQueueItem.getTypeString() + "-----");
            String string = textSynthesizerQueueItem.getEngineText();
            int n2 = 0;
            Object object = this.commandLock;
            synchronized (object) {
                n = this.command;
            }
            while (n2 < string.length()) {
                Object object2;
                if (n == 0) {
                    if (n2 > 0) {
                        textSynthesizerQueueItem.postSpeakablePaused();
                        bl = true;
                    }
                    object2 = this.commandLock;
                    synchronized (object2) {
                        while (this.command == 0) {
                            try {
                                this.commandLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        n = this.command;
                    }
                }
                if (n != 1) break;
                if (n2 == 0) {
                    textSynthesizerQueueItem.postSpeakableStarted();
                } else if (bl) {
                    textSynthesizerQueueItem.postSpeakableResumed();
                    bl = false;
                }
                n2 = this.isCommand(string, n2) ? this.processCommand(textSynthesizerQueueItem, string, n2) : (this.isWhitespace(string, n2) ? this.processWhitespace(string, n2) : this.processNormalText(textSynthesizerQueueItem, string, n2));
                object2 = this.commandLock;
                synchronized (object2) {
                    n = this.command;
                }
            }
            System.out.println("\n----- END: " + textSynthesizerQueueItem.getTypeString() + "-----\n");
            return n;
        }

        protected boolean isCommand(String string, int n) {
            if (!string.substring(n, n + 1).equals("/")) {
                return false;
            }
            int n2 = 0;
            while (n2 < TextSynthesizerQueueItem.ELEMENTS.length) {
                if (string.startsWith("/" + TextSynthesizerQueueItem.ELEMENTS[n2], n)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected int processCommand(TextSynthesizerQueueItem textSynthesizerQueueItem, String string, int n) {
            int n2 = 0;
            while (n2 < TextSynthesizerQueueItem.ELEMENTS.length) {
                if (string.startsWith("/" + TextSynthesizerQueueItem.ELEMENTS[n2], n)) {
                    int n3 = string.indexOf("/", n + 1) + 1;
                    String string2 = string.substring(n, n3);
                    System.out.print(string2);
                    System.out.flush();
                    return n3;
                }
                ++n2;
            }
            return n;
        }

        protected boolean isWhitespace(String string, int n) {
            return Character.isWhitespace(string.charAt(n));
        }

        protected int processWhitespace(String string, int n) {
            int n2 = n;
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            System.out.print(string.substring(n, n2));
            System.out.flush();
            try {
                Thread.sleep(60000 / this.rate);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return n2;
        }

        protected int processNormalText(TextSynthesizerQueueItem textSynthesizerQueueItem, String string, int n) {
            int n2 = n + 1;
            while (n2 < string.length() && string.charAt(n2) != '/' && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string2 = string.substring(n, n2);
            textSynthesizerQueueItem.postWordStarted(string2, n, n2);
            System.out.print(string2);
            System.out.flush();
            return n2;
        }
    }
}

