/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FreeTTS;
import com.sun.speech.freetts.InputMode;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.en.us.CMUTimeAWBVoice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class FreeTTSTime
extends FreeTTS {
    private static final String VERSION = "FreeTTSTime Version 1.0, September  21, 2001";

    public FreeTTSTime() {
        super(new CMUTimeAWBVoice());
    }

    public static void usage() {
        System.out.println(VERSION);
        System.out.println("Usage:");
        System.out.println("    -dumpWave file  : dump the final wave to file");
        System.out.println("    -dumpAudio file : dump audio to file ");
        System.out.println("    -help           : shows usage information");
        System.out.println("    -detailedMetrics: turn on detailed metrics");
        System.out.println("    -dumpRelations  : dump the relations ");
        System.out.println("    -dumpUtterance  : dump the final utterance");
        System.out.println("    -metrics        : turn on metrics");
        System.out.println("    -run  name      : sets the name of the run");
        System.out.println("    -silent         : don't say anything");
        System.out.println("    -verbose        : verbose output");
        System.out.println("    -version        : shows version number");
        System.out.println("    -timeTest       : runs a lengthy time test");
        System.out.println("    -iter count     : run for count iterations");
        System.out.println("    -time XX:XX     : speak the given time");
        System.out.println("    -time now       : speak the current time");
        System.out.println("    -period secs    : period of iter");
        System.out.println("    -clockMode      : tells time every 5 mins");
        System.exit(0);
    }

    private static void interactiveMode(FreeTTSTime freeTTSTime) {
        try {
            while (true) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Enter time: ");
                System.out.flush();
                String string = bufferedReader.readLine();
                if (string == null || string.length() == 0 || string.equals("quit")) {
                    freeTTSTime.shutdown();
                    System.exit(0);
                    continue;
                }
                freeTTSTime.getVoice().startBatch();
                freeTTSTime.safeTimeToSpeech(string);
                freeTTSTime.getVoice().endBatch();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static String timeApprox(int n, int n2) {
        int n3 = n2 % 5;
        if (n3 == 0 || n3 == 4) {
            return "exactly";
        }
        if (n3 == 1) {
            return "just after";
        }
        if (n3 == 2) {
            return "a little after";
        }
        return "almost";
    }

    private static String timeMin(int n, int n2) {
        int n3 = n2 / 5;
        if (n2 % 5 > 2) {
            ++n3;
        }
        if ((n3 *= 5) > 55) {
            n3 = 0;
        }
        if (n3 == 0) {
            return "";
        }
        if (n3 == 5) {
            return "five past";
        }
        if (n3 == 10) {
            return "ten past";
        }
        if (n3 == 15) {
            return "quarter past";
        }
        if (n3 == 20) {
            return "twenty past";
        }
        if (n3 == 25) {
            return "twenty-five past";
        }
        if (n3 == 30) {
            return "half past";
        }
        if (n3 == 35) {
            return "twenty-five to";
        }
        if (n3 == 40) {
            return "twenty to";
        }
        if (n3 == 45) {
            return "quarter to";
        }
        if (n3 == 50) {
            return "ten to";
        }
        if (n3 == 55) {
            return "five to";
        }
        return "five to";
    }

    private static String timeHour(int n, int n2) {
        int n3 = n;
        if (n2 > 32) {
            ++n3;
        }
        if (n3 == 24) {
            n3 = 0;
        }
        if (n3 > 12) {
            n3 -= 12;
        }
        if (n3 == 0) {
            return "midnight";
        }
        if (n3 == 1) {
            return "one";
        }
        if (n3 == 2) {
            return "two";
        }
        if (n3 == 3) {
            return "three";
        }
        if (n3 == 4) {
            return "four";
        }
        if (n3 == 5) {
            return "five";
        }
        if (n3 == 6) {
            return "six";
        }
        if (n3 == 7) {
            return "seven";
        }
        if (n3 == 8) {
            return "eight";
        }
        if (n3 == 9) {
            return "nine";
        }
        if (n3 == 10) {
            return "ten";
        }
        if (n3 == 11) {
            return "eleven";
        }
        if (n3 == 12) {
            return "twelve";
        }
        return "twelve";
    }

    private static String timeOfDay(int n, int n2) {
        int n3 = n;
        if (n2 > 58) {
            ++n3;
        }
        if (n3 == 24) {
            return "";
        }
        if (n3 > 17) {
            return "in the evening";
        }
        if (n3 > 11) {
            return "in the afternoon";
        }
        return "in the morning";
    }

    public static String timeToString(String string) {
        String string2 = null;
        if (Pattern.matches("[012][0-9]:[0-5][0-9]", string)) {
            int n = Integer.parseInt(string.substring(0, 2));
            int n2 = Integer.parseInt(string.substring(3));
            string2 = FreeTTSTime.timeToString(n, n2);
        }
        return string2;
    }

    public static String timeToString(int n, int n2) {
        String string = "The time is now, " + FreeTTSTime.timeApprox(n, n2) + " " + FreeTTSTime.timeMin(n, n2) + " " + FreeTTSTime.timeHour(n, n2) + ", " + FreeTTSTime.timeOfDay(n, n2) + ".";
        return string;
    }

    public void timeToSpeech(String string) {
        String string2 = FreeTTSTime.timeToString(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Bad time format");
        }
        this.textToSpeech(string2);
    }

    public void timeToSpeech(int n, int n2) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Bad time format: hour");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Bad time format: min");
        }
        String string = FreeTTSTime.timeToString(n, n2);
        this.textToSpeech(string);
    }

    public void safeTimeToSpeech(String string) {
        try {
            if (string.equals("now")) {
                this.speakNow();
            } else {
                this.timeToSpeech(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Bad time format");
        }
    }

    public void speakNow() {
        long l = System.currentTimeMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        this.timeToSpeech(n, n2);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        FreeTTSTime freeTTSTime = new FreeTTSTime();
        Voice voice = freeTTSTime.getVoice();
        FeatureSet featureSet = voice.getFeatures();
        boolean bl = false;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals("-metrics")) {
                voice.setMetrics(true);
            } else if (stringArray[n3].equals("-detailedMetrics")) {
                voice.setDetailedMetrics(true);
            } else if (stringArray[n3].equals("-silent")) {
                freeTTSTime.setSilentMode(true);
            } else if (stringArray[n3].equals("-period")) {
                if (++n3 < stringArray.length) {
                    try {
                        n2 = Integer.parseInt(stringArray[n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Bad clock period");
                        FreeTTSTime.usage();
                    }
                }
            } else if (stringArray[n3].equals("-verbose")) {
                voice.setVerbose(true);
            } else if (stringArray[n3].equals("-dumpUtterance")) {
                voice.setDumpUtterance(true);
            } else if (stringArray[n3].equals("-dumpRelations")) {
                voice.setDumpRelations(true);
            } else if (stringArray[n3].equals("-clockMode")) {
                n = Integer.MAX_VALUE;
                n2 = 300;
            } else if (stringArray[n3].equals("-timeTest")) {
                bl = true;
                n = 100;
            } else if (stringArray[n3].equals("-dumpAudio")) {
                if (++n3 < stringArray.length) {
                    freeTTSTime.setAudioFile(stringArray[n3]);
                } else {
                    FreeTTSTime.usage();
                }
            } else if (stringArray[n3].equals("-iter")) {
                if (++n3 < stringArray.length) {
                    try {
                        n = Integer.parseInt(stringArray[n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Bad iteration format");
                        FreeTTSTime.usage();
                    }
                } else {
                    FreeTTSTime.usage();
                }
            } else if (stringArray[n3].equals("-dumpWave")) {
                if (++n3 < stringArray.length) {
                    string2 = stringArray[n3];
                    voice.setWaveDumpFile(stringArray[n3]);
                } else {
                    FreeTTSTime.usage();
                }
            } else if (stringArray[n3].equals("-version")) {
                System.out.println(VERSION);
            } else if (stringArray[n3].equals("-help")) {
                FreeTTSTime.usage();
            } else if (stringArray[n3].equals("-time")) {
                freeTTSTime.setInputMode(InputMode.TEXT);
                if (++n3 < stringArray.length) {
                    string = stringArray[n3];
                } else {
                    FreeTTSTime.usage();
                }
            } else if (stringArray[n3].equals("-run")) {
                if (++n3 < stringArray.length) {
                    voice.setRunTitle(stringArray[n3]);
                } else {
                    FreeTTSTime.usage();
                }
            } else {
                System.out.println("Unknown option:" + stringArray[n3]);
            }
            ++n3;
        }
        freeTTSTime.startup();
        if (string != null) {
            freeTTSTime.getVoice().startBatch();
            int n4 = 0;
            while (n4 < n) {
                freeTTSTime.safeTimeToSpeech(string);
                try {
                    Thread.sleep((long)n2 * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ++n4;
            }
            freeTTSTime.getVoice().endBatch();
        } else {
            FreeTTSTime.interactiveMode(freeTTSTime);
        }
        freeTTSTime.shutdown();
        System.exit(0);
    }
}

