/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.lexicon.Lexicon;
import java.util.ArrayList;

public class Segmenter
implements UtteranceProcessor {
    private static final String STRESS = "1";
    private static final String NO_STRESS = "0";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$speech$freetts$Segmenter;

    public void processUtterance(Utterance utterance) throws ProcessException {
        if (utterance.getRelation("Word") == null) {
            throw new IllegalStateException("Word relation has not been set");
        }
        if (utterance.getRelation("Syllable") != null) {
            throw new IllegalStateException("Syllable relation has already been set");
        }
        if (utterance.getRelation("SylStructure") != null) {
            throw new IllegalStateException("SylStructure relation has already been set");
        }
        if (utterance.getRelation("Segment") != null) {
            throw new IllegalStateException("Segment relation has already been set");
        }
        String string = NO_STRESS;
        Relation relation = utterance.createRelation("Syllable");
        Relation relation2 = utterance.createRelation("SylStructure");
        Relation relation3 = utterance.createRelation("Segment");
        Lexicon lexicon = utterance.getVoice().getLexicon();
        ArrayList<String> arrayList = null;
        Item item = utterance.getRelation("Word").getHead();
        while (item != null) {
            Item item2 = relation2.appendItem(item);
            Item item3 = null;
            Item item4 = null;
            Item item5 = null;
            String[] stringArray = null;
            Item item6 = item.getItemAs("Token");
            FeatureSet featureSet = null;
            if (item6 != null) {
                Item item7 = item6.getParent();
                featureSet = item7.getFeatures();
            }
            stringArray = featureSet != null && featureSet.isPresent("phones") ? (String[])featureSet.getObject("phones") : lexicon.getPhones(item.toString(), null);
            if (!$assertionsDisabled && stringArray == null) {
                throw new AssertionError();
            }
            int n = 0;
            while (n < stringArray.length) {
                if (item3 == null) {
                    item3 = relation.appendItem();
                    item5 = item2.addDaughter(item3);
                    string = NO_STRESS;
                    arrayList = new ArrayList<String>();
                }
                item4 = relation3.appendItem();
                if (this.isStressed(stringArray[n])) {
                    string = STRESS;
                    stringArray[n] = this.deStress(stringArray[n]);
                }
                item4.getFeatures().setString("name", stringArray[n]);
                item5.addDaughter(item4);
                arrayList.add(stringArray[n]);
                if (lexicon.isSyllableBoundary(arrayList, stringArray, n + 1)) {
                    item3 = null;
                    if (item5 != null) {
                        item5.getFeatures().setString("stress", string);
                    }
                }
                ++n;
            }
            item = item.getNext();
        }
        if (!$assertionsDisabled && utterance.getRelation("Word") == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && utterance.getRelation("Syllable") == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && utterance.getRelation("SylStructure") == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && utterance.getRelation("Segment") == null) {
            throw new AssertionError();
        }
    }

    protected boolean isStressed(String string) {
        return string.endsWith(STRESS);
    }

    protected String deStress(String string) {
        String string2 = string;
        if (this.isStressed(string)) {
            string2 = string.substring(0, string.length() - 1);
        }
        return string2;
    }

    public String toString() {
        return "Segmenter";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$speech$freetts$Segmenter == null ? (class$com$sun$speech$freetts$Segmenter = Segmenter.class$("com.sun.speech.freetts.Segmenter")) : class$com$sun$speech$freetts$Segmenter).desiredAssertionStatus();
    }
}

