/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.FeatureProcessor;
import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.FreeTTSSpeakable;
import com.sun.speech.freetts.FreeTTSSpeakableImpl;
import com.sun.speech.freetts.OutputQueue;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Token;
import com.sun.speech.freetts.Tokenizer;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.lexicon.Lexicon;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class Voice
implements UtteranceProcessor,
Dumpable {
    public static final String DATABASE_NAME = "databaseName";
    private List utteranceProcessors;
    private Map featureProcessors;
    private FeatureSetImpl features;
    private boolean verbose = false;
    private boolean metrics = false;
    private boolean detailedMetrics = false;
    private boolean dumpUtterance = false;
    private boolean dumpRelations = false;
    private String runTitle = "unnamed run";
    private Lexicon lexicon = null;
    private AudioPlayer audioPlayer;
    private UtteranceProcessor audioOutput;
    private OutputQueue outputQueue = null;
    private String waveDumpFile = null;
    private BulkTimer runTimer = new BulkTimer();
    private BulkTimer threadTimer = new BulkTimer();
    private boolean externalOutputQueue = false;
    private float nominalRate = 150.0f;
    private float pitch = 100.0f;
    private float range = 10.0f;
    private float pitchShift = 1.0f;
    private float volume = 0.8f;
    private float durationStretch = 1.0f;
    private boolean loaded = false;
    public static final String PROP_PREFIX = "com.sun.speech.freetts.voice.";
    public static final String FEATURE_SILENCE = "silence";
    public static final String FEATURE_JOIN_TYPE = "join_type";

    public Voice() {
        this.utteranceProcessors = Collections.synchronizedList(new ArrayList());
        this.features = new FeatureSetImpl();
        this.featureProcessors = new HashMap();
        try {
            this.nominalRate = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.speakingRate", "150"));
            this.pitch = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.pitch", "100"));
            this.range = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.range", "10"));
            this.volume = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.volume", "1.0"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.outputQueue = null;
    }

    public boolean speak(String string) {
        return this.speak(new FreeTTSSpeakableImpl(string));
    }

    public boolean speak(Document document) {
        return this.speak(new FreeTTSSpeakableImpl(document));
    }

    public boolean speak(InputStream inputStream) {
        return this.speak(new FreeTTSSpeakableImpl(inputStream));
    }

    public boolean speak(FreeTTSSpeakable freeTTSSpeakable) {
        this.log("speak(FreeTTSSpeakable) called");
        boolean bl = true;
        boolean bl2 = false;
        this.audioPlayer.startFirstSampleTimer();
        Iterator iterator = this.tokenize(freeTTSSpeakable);
        while (!freeTTSSpeakable.isCompleted() && iterator.hasNext()) {
            try {
                Utterance utterance = (Utterance)iterator.next();
                if (utterance == null) continue;
                this.processUtterance(utterance);
                bl2 = true;
            }
            catch (ProcessException processException) {
                bl = false;
            }
        }
        if (bl && bl2) {
            this.runTimer.start("WaitAudio");
            bl = freeTTSSpeakable.waitCompleted();
            this.runTimer.stop("WaitAudio");
        }
        this.log("speak(FreeTTSSpeakable) completed");
        return bl;
    }

    public void load() {
        if (this.isLoaded()) {
            return;
        }
        BulkTimer.LOAD.start();
        if (!this.lexicon.isLoaded()) {
            try {
                this.lexicon.load();
            }
            catch (IOException iOException) {
                this.error("Can't load voice " + iOException);
            }
        }
        try {
            this.audioOutput = this.getAudioOutput();
        }
        catch (IOException iOException) {
            this.error("Can't load audio output handler for voice " + iOException);
        }
        if (this.outputQueue == null) {
            this.outputQueue = Voice.createOutputThread();
        }
        try {
            this.loader();
        }
        catch (IOException iOException) {
            this.error("Can't load voice " + iOException);
        }
        BulkTimer.LOAD.stop();
        if (this.isMetrics()) {
            BulkTimer.LOAD.show("loading " + this.toString() + " for " + this.getRunTitle());
        }
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        if (this.utteranceProcessors == null) {
            return;
        }
        if (utterance == null) {
            throw new ProcessException("Utterance is null.");
        }
        this.runTimer.start("processing");
        UtteranceProcessor[] utteranceProcessorArray = new UtteranceProcessor[this.utteranceProcessors.size()];
        utteranceProcessorArray = this.utteranceProcessors.toArray(utteranceProcessorArray);
        this.log("Processing Utterance: " + utterance.getString("input_text"));
        try {
            int n = 0;
            while (n < utteranceProcessorArray.length) {
                this.runProcessor(utteranceProcessorArray[n], utterance, this.runTimer);
                ++n;
            }
            if (this.outputQueue == null) {
                this.log("To AudioOutput");
                this.outputUtterance(utterance, this.runTimer);
            } else {
                this.runTimer.start("..post");
                this.outputQueue.post(utterance);
                this.runTimer.stop("..post");
            }
        }
        catch (ProcessException processException) {
            System.err.println("Processing Utterance: " + processException);
        }
        catch (Exception exception) {
            System.err.println("Trouble while processing utterance " + exception);
            exception.printStackTrace();
            utterance.getSpeakable().cancelled();
        }
        this.log("Done Processing Utterance: " + utterance.getString("input_text"));
        this.runTimer.stop("processing");
        if (this.dumpUtterance) {
            utterance.dump("Utterance");
        }
        if (this.dumpRelations) {
            utterance.dumpRelations("Utterance");
        }
        this.dumpWave(utterance);
    }

    private void dumpWave(Utterance utterance) {
        if (this.waveDumpFile != null) {
            LPCResult lPCResult = (LPCResult)utterance.getObject("target_lpcres");
            try {
                if (this.waveDumpFile.equals("-")) {
                    lPCResult.dumpWave();
                } else {
                    lPCResult.dumpWave(this.waveDumpFile);
                }
            }
            catch (IOException iOException) {
                this.error("Can't dump file to " + this.waveDumpFile + " " + iOException);
            }
        }
    }

    public static OutputQueue createOutputThread() {
        final OutputQueue outputQueue = new OutputQueue();
        Thread thread = new Thread(){

            public void run() {
                Utterance utterance = null;
                do {
                    if ((utterance = outputQueue.pend()) == null) continue;
                    Voice voice = utterance.getVoice();
                    voice.log("OUT: " + utterance.getString("input_text"));
                    voice.outputUtterance(utterance, voice.threadTimer);
                } while (utterance != null);
            }
        };
        thread.setDaemon(true);
        thread.start();
        return outputQueue;
    }

    private boolean outputUtterance(Utterance utterance, BulkTimer bulkTimer) {
        boolean bl = true;
        FreeTTSSpeakable freeTTSSpeakable = utterance.getSpeakable();
        if (!freeTTSSpeakable.isCompleted()) {
            if (utterance.isFirst()) {
                this.audioPlayer.reset();
                freeTTSSpeakable.started();
                this.log(" --- started ---");
            }
            try {
                this.runProcessor(this.audioOutput, utterance, bulkTimer);
            }
            catch (ProcessException processException) {
                bl = false;
            }
            if (bl && utterance.isLast()) {
                this.audioPlayer.drain();
                freeTTSSpeakable.completed();
                this.log(" --- completed ---");
            } else if (!bl) {
                this.audioPlayer.drain();
                freeTTSSpeakable.cancelled();
                this.log(" --- cancelled ---");
            } else {
                this.log(" --- not last: " + freeTTSSpeakable.getText() + " --- ");
            }
            this.log("Calling speakable.completed() on " + freeTTSSpeakable.getText());
        } else {
            bl = false;
            this.log("STRANGE: speakable already completed: " + freeTTSSpeakable.getText());
        }
        return bl;
    }

    private void runProcessor(UtteranceProcessor utteranceProcessor, Utterance utterance, BulkTimer bulkTimer) throws ProcessException {
        if (utteranceProcessor != null) {
            String string = ".." + utteranceProcessor.toString();
            this.log("   Running " + string);
            bulkTimer.start(string);
            utteranceProcessor.processUtterance(utterance);
            bulkTimer.stop(string);
        }
    }

    public abstract Tokenizer getTokenizer();

    public List getUtteranceProcessors() {
        return this.utteranceProcessors;
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    public void startBatch() {
        this.runTimer.setVerbose(this.detailedMetrics);
        this.runTimer.start();
    }

    public void endBatch() {
        this.runTimer.stop();
        if (this.metrics) {
            this.runTimer.show(this.getRunTitle() + " run");
            this.threadTimer.show(this.getRunTitle() + " thread");
            this.audioPlayer.showMetrics();
            long l = Runtime.getRuntime().totalMemory();
            System.out.println("Memory Use    : " + (l - Runtime.getRuntime().freeMemory()) / 1024L + "k  of " + l / 1024L + "k");
        }
    }

    public void setOutputQueue(OutputQueue outputQueue) {
        this.externalOutputQueue = true;
        this.outputQueue = outputQueue;
    }

    public OutputQueue getOutputQueue() {
        return this.outputQueue;
    }

    protected abstract void loader() throws IOException;

    private Iterator tokenize(FreeTTSSpeakable freeTTSSpeakable) {
        return new FreeTTSSpeakableTokenizer(freeTTSSpeakable).iterator();
    }

    private String documentToString(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        this.linearize(document, stringBuffer);
        return stringBuffer.toString();
    }

    private void linearize(Node node, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = this.processNode(node, stringBuffer);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.linearize(node2, stringBuffer);
            node2 = node2.getNextSibling();
        }
        if (stringBuffer2 != null) {
            stringBuffer.append(stringBuffer2);
        }
    }

    protected StringBuffer processNode(Node node, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = null;
        short s = node.getNodeType();
        switch (s) {
            case 2: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                stringBuffer.append(((Text)node).getData());
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 11: {
                break;
            }
        }
        return stringBuffer2;
    }

    public void dump(PrintWriter printWriter, int n, String string) {
        Utilities.dump(printWriter, n, string);
        this.features.dump(printWriter, n + 4, string + " Features");
        this.dumpProcessors(printWriter, n + 4, string + " Processors");
    }

    public void dumpProcessors(PrintWriter printWriter, int n, String string) {
        if (this.utteranceProcessors == null) {
            return;
        }
        UtteranceProcessor[] utteranceProcessorArray = new UtteranceProcessor[this.utteranceProcessors.size()];
        utteranceProcessorArray = this.utteranceProcessors.toArray(utteranceProcessorArray);
        Utilities.dump(printWriter, n, string);
        int n2 = 0;
        while (n2 < utteranceProcessorArray.length) {
            Utilities.dump(printWriter, n + 4, utteranceProcessorArray[n2].toString());
            ++n2;
        }
    }

    public FeatureProcessor getFeatureProcessor(String string) {
        return (FeatureProcessor)this.featureProcessors.get(string);
    }

    public void addFeatureProcessor(String string, FeatureProcessor featureProcessor) {
        this.featureProcessors.put(string, featureProcessor);
    }

    public void log(String string) {
        if (this.verbose) {
            System.out.println(this.toString() + ": " + string);
        }
    }

    public void warn(String string) {
        System.err.println("Warning: " + string);
    }

    public void error(String string) {
        System.err.println("Error: " + string);
        throw new Error(string);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        this.log("Verbose mode is " + bl);
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public void setMetrics(boolean bl) {
        this.metrics = bl;
        this.log("Metrics mode is " + bl);
    }

    public boolean isDetailedMetrics() {
        return this.detailedMetrics;
    }

    public void setDetailedMetrics(boolean bl) {
        this.detailedMetrics = bl;
        this.log("DetailedMetrics mode is " + bl);
    }

    public boolean isDumpUtterance() {
        return this.dumpUtterance;
    }

    public void setDumpUtterance(boolean bl) {
        this.dumpUtterance = bl;
        this.log("DumpUtterance mode is " + bl);
    }

    public boolean isDumpRelations() {
        return this.dumpRelations;
    }

    public void setDumpRelations(boolean bl) {
        this.dumpRelations = bl;
        this.log("DumpRelations mode is " + bl);
    }

    public void setRunTitle(String string) {
        this.runTitle = string;
    }

    public String getRunTitle() {
        return this.runTitle;
    }

    public String getPhoneFeature(String string, String string2) {
        return null;
    }

    public void close() {
        this.setLoaded(false);
        if (!this.externalOutputQueue) {
            this.outputQueue.post(null);
        }
    }

    public void setPitch(float f) {
        this.pitch = f;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitchRange(float f) {
        this.range = f;
    }

    public float getPitchRange() {
        return this.range;
    }

    public void setPitchShift(float f) {
        this.pitchShift = f;
    }

    public float getPitchShift() {
        return this.pitchShift;
    }

    public void setDurationStretch(float f) {
        this.durationStretch = f;
    }

    public float getDurationStretch() {
        return this.durationStretch;
    }

    public void setRate(float f) {
        if (f > 0.0f && f < 1000.0f) {
            this.setDurationStretch(this.nominalRate / f);
        }
    }

    public float getRate() {
        return this.durationStretch * this.nominalRate;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public float getVolume() {
        return this.volume;
    }

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    public void setWaveDumpFile(String string) {
        this.waveDumpFile = string;
    }

    public String getWaveDumpFile() {
        return this.waveDumpFile;
    }

    private void traceStack() {
        new Throwable().printStackTrace();
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    protected URL getResource(String string) {
        return this.getClass().getResource(string);
    }

    public String toString() {
        return "Voice";
    }

    protected abstract UtteranceProcessor getAudioOutput() throws IOException;

    private class FreeTTSSpeakableTokenizer {
        FreeTTSSpeakable speakable;
        Tokenizer tok;

        public FreeTTSSpeakableTokenizer(FreeTTSSpeakable freeTTSSpeakable) {
            this.tok = Voice.this.getTokenizer();
            this.speakable = freeTTSSpeakable;
            if (freeTTSSpeakable.isPlainText()) {
                this.tok.setInputText(freeTTSSpeakable.getText());
            } else if (freeTTSSpeakable.isStream()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(freeTTSSpeakable.getInputStream()));
                this.tok.setInputReader(bufferedReader);
            } else if (freeTTSSpeakable.isDocument()) {
                this.tok.setInputText(Voice.this.documentToString(freeTTSSpeakable.getDocument()));
            }
        }

        public Iterator iterator() {
            return new Iterator(this){
                boolean first;
                Token savedToken;
                private final /* synthetic */ FreeTTSSpeakableTokenizer this$1;
                {
                    this.this$1 = freeTTSSpeakableTokenizer;
                    this.first = true;
                    this.savedToken = null;
                }

                public boolean hasNext() {
                    return this.savedToken != null || this.this$1.tok.hasMoreTokens();
                }

                public Object next() {
                    ArrayList<Token> arrayList = new ArrayList<Token>();
                    Utterance utterance = null;
                    if (this.savedToken != null) {
                        arrayList.add(this.savedToken);
                        this.savedToken = null;
                    }
                    while (this.this$1.tok.hasMoreTokens()) {
                        Token token = this.this$1.tok.getNextToken();
                        if (token.getWord().length() == 0 || arrayList.size() > 500 || this.this$1.tok.isBreak()) {
                            this.savedToken = token;
                            break;
                        }
                        arrayList.add(token);
                    }
                    utterance = new Utterance(FreeTTSSpeakableTokenizer.access$300(this.this$1), arrayList);
                    utterance.setSpeakable(this.this$1.speakable);
                    utterance.setFirst(this.first);
                    this.first = false;
                    boolean bl = !this.this$1.tok.hasMoreTokens() && (this.savedToken == null || this.savedToken.getWord().length() == 0);
                    utterance.setLast(bl);
                    return utterance;
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        static /* synthetic */ Voice access$300(FreeTTSSpeakableTokenizer freeTTSSpeakableTokenizer) {
            return freeTTSSpeakableTokenizer.Voice.this;
        }
    }
}

