/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class JavaStreamingAudioPlayer
implements AudioPlayer {
    private volatile boolean paused;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private SourceDataLine line = null;
    private float volume = 1.0f;
    private long timeOffset = 0L;
    private BulkTimer timer = new BulkTimer();
    private AudioFormat defaultFormat;
    private AudioFormat currentFormat = this.defaultFormat = new AudioFormat(8000.0f, 16, 1, true, true);
    private boolean debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
    private boolean firstSample = true;
    private long cancelDelay = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.cancelDelay", 0L);
    private static final long DRAIN_DELAY = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.drainDelay", 150L);
    private static final int AUDIO_BUFFER_SIZE = Utilities.getInteger("com.sun.speech.freetts.audio.AudioPlayer.bufferSize", 8192);
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public JavaStreamingAudioPlayer() {
        this.setPaused(false);
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        this.currentFormat = audioFormat;
        this.debugPrint("AF changed to " + audioFormat);
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public void startFirstSampleTimer() {
        this.timer.start("firstAudio");
        this.firstSample = true;
    }

    private synchronized void openLine(AudioFormat audioFormat) {
        if (this.line != null) {
            this.drain();
            this.line.close();
            this.line = null;
        }
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaStreamingAudioPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat, AUDIO_BUFFER_SIZE);
            this.setVolume(this.line, this.volume);
            this.resetTime();
            if (this.isPaused() && this.line.isRunning()) {
                this.line.stop();
            } else {
                this.line.start();
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
            throw new UnsupportedOperationException("Can't get line");
        }
    }

    public synchronized void pause() {
        if (!this.isPaused()) {
            this.setPaused(true);
            if (this.line != null) {
                this.line.stop();
            }
        }
    }

    public synchronized void resume() {
        if (this.isPaused()) {
            this.setPaused(false);
            if (!this.isCancelled() && this.line != null) {
                this.line.start();
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        this.debugPrint("cancelling...");
        this.cancelled = true;
        try {
            Thread.sleep(this.cancelDelay);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (this.line != null) {
            SourceDataLine sourceDataLine = this.line;
            synchronized (sourceDataLine) {
                this.line.stop();
                this.line.flush();
            }
            this.notify();
        }
        this.debugPrint("...cancelled");
    }

    public synchronized void reset() {
        this.timer.start("audioOut");
        if (this.line != null) {
            this.waitResume();
            if (this.isCancelled() && !this.isDone()) {
                this.cancelled = false;
                this.line.start();
            }
        }
    }

    public synchronized void close() {
        this.done = true;
        if (this.line != null && this.line.isOpen()) {
            this.line.close();
            this.line = null;
            this.notify();
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.volume = f;
    }

    private void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean isPaused() {
        return this.paused;
    }

    private void setVolume(SourceDataLine sourceDataLine, float f) {
        if (sourceDataLine != null && sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl floatControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
            float f2 = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * f2 + floatControl.getMinimum());
        }
    }

    public void begin(int n) {
        this.debugPrint("opening Stream...");
        this.openLine(this.currentFormat);
        this.reset();
        this.debugPrint("...Stream opened");
    }

    public synchronized boolean end() {
        if (this.line != null) {
            this.drain();
            this.line.close();
            this.line = null;
            this.notify();
            this.debugPrint("ended stream...");
        }
        return true;
    }

    public boolean drain() {
        if (this.line != null) {
            this.debugPrint("started draining...");
            if (this.line.isOpen()) {
                this.line.drain();
                if (DRAIN_DELAY > 0L) {
                    try {
                        Thread.sleep(DRAIN_DELAY);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.debugPrint("...finished draining");
        }
        this.timer.stop("audioOut");
        return !this.isCancelled();
    }

    public synchronized long getTime() {
        return (this.line.getMicrosecondPosition() - this.timeOffset) / 1000L;
    }

    public synchronized void resetTime() {
        this.timeOffset = this.line.getMicrosecondPosition();
    }

    public boolean write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(byte[] byArray, int n, int n2) {
        if (this.line == null) {
            return false;
        }
        int n3 = n2;
        int n4 = n;
        if (this.firstSample) {
            this.firstSample = false;
            this.timer.stop("firstAudio");
        }
        this.debugPrint(" au write " + n3 + " pos " + this.line.getMicrosecondPosition() + " avail " + this.line.available() + " bsz " + this.line.getBufferSize());
        while (n3 > 0 && !this.isCancelled()) {
            int n5;
            if (!this.waitResume()) {
                return false;
            }
            this.debugPrint("   queueing cur " + n4 + " br " + n3);
            SourceDataLine sourceDataLine = this.line;
            synchronized (sourceDataLine) {
                n5 = this.line.write(byArray, n4, n3);
                if (n5 != n5) {
                    this.debugPrint("RETRY! bw" + n5 + " br " + n3);
                }
            }
            this.debugPrint("   wrote  cur " + (n4 += n5) + " br " + (n3 -= n5) + " bw " + n5);
        }
        return !this.isCancelled() && !this.isDone();
    }

    private synchronized boolean waitResume() {
        while (this.isPaused() && !this.isCancelled() && !this.isDone()) {
            try {
                this.debugPrint("   paused waiting ");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !this.isCancelled() && !this.isDone();
    }

    public String toString() {
        return "JavaStreamingAudioPlayer";
    }

    private void debugPrint(String string) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + string);
        }
    }

    public void showMetrics() {
        this.timer.show("JavaStreamingAudioPlayer");
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized boolean isDone() {
        return this.done;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

