/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SingleFileAudioPlayer
implements AudioPlayer {
    private boolean debug = false;
    private AudioFormat currentFormat = null;
    private String baseName;
    private byte[] outputData;
    private int curIndex = 0;
    private int totBytes = 0;
    private AudioFileFormat.Type outputType;
    private Vector outputList;

    public SingleFileAudioPlayer(String string, AudioFileFormat.Type type) {
        this.baseName = string + "." + type.getExtension();
        this.outputType = type;
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
        this.outputList = new Vector();
    }

    public SingleFileAudioPlayer() {
        this("freetts", AudioFileFormat.Type.WAVE);
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        this.currentFormat = audioFormat;
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public void pause() {
    }

    public synchronized void resume() {
    }

    public synchronized void cancel() {
    }

    public synchronized void reset() {
    }

    public void startFirstSampleTimer() {
    }

    public synchronized void close() {
        try {
            File file = new File(this.baseName);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(this.outputList.elements());
            AudioInputStream audioInputStream = new AudioInputStream(sequenceInputStream, this.currentFormat, this.totBytes / this.currentFormat.getFrameSize());
            AudioSystem.write(audioInputStream, this.outputType, file);
        }
        catch (IOException iOException) {
            System.err.println("Can't write audio to " + this.baseName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Can't write audio type " + this.outputType);
        }
    }

    public float getVolume() {
        return 1.0f;
    }

    public void setVolume(float f) {
    }

    public void begin(int n) {
        this.outputData = new byte[n];
        this.curIndex = 0;
    }

    public boolean end() {
        this.outputList.add(new ByteArrayInputStream(this.outputData));
        this.totBytes += this.outputData.length;
        return true;
    }

    public boolean drain() {
        return true;
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public boolean write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public boolean write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.outputData, this.curIndex, n2);
        this.curIndex += n2;
        return true;
    }

    private synchronized boolean waitResume() {
        return true;
    }

    public String toString() {
        return "FileAudioPlayer";
    }

    private void debugPrint(String string) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + string);
        }
    }

    public void showMetrics() {
    }
}

