/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.relp.Sample;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Diphone {
    private static final int MAGIC = 262988031;
    private static final int NAME_LENGTH = 8;
    private String name;
    private int midPoint;
    private Sample[] samples;
    private int unitSizePart1;
    private int unitSizePart2;

    public Diphone(String string, Sample[] sampleArray, int n) {
        this.name = string;
        this.midPoint = n;
        this.samples = sampleArray;
        this.unitSizePart1 = 0;
        this.unitSizePart2 = 0;
        int n2 = 0;
        while (n2 < n) {
            this.unitSizePart1 += sampleArray[n2].getResidualSize();
            ++n2;
        }
        int n3 = n;
        while (n3 < sampleArray.length) {
            this.unitSizePart2 += sampleArray[n3].getResidualSize();
            ++n3;
        }
    }

    public Sample[] getSamples() {
        return this.samples;
    }

    public Sample getSamples(int n) {
        return this.samples[n];
    }

    public String getName() {
        return this.name;
    }

    public int getMidPoint() {
        return this.midPoint;
    }

    public int getPbPositionMillis() {
        return this.getMidPoint();
    }

    public Sample nearestSample(float f, int n) {
        int n2 = 0;
        int n3 = n == 1 ? 0 : this.midPoint;
        int n4 = n == 1 ? this.midPoint : this.samples.length;
        int n5 = n3;
        while (n5 < n4) {
            int n6 = n2 + this.samples[n5].getResidualSize();
            if (Math.abs(f - (float)n2) < Math.abs(f - (float)n6)) {
                return this.samples[n5];
            }
            n2 = n6;
            ++n5;
        }
        return this.samples[n4 - 1];
    }

    public int getUnitSize(int n) {
        if (n == 1) {
            return this.unitSizePart1;
        }
        return this.unitSizePart2;
    }

    public void dump() {
        System.out.println("Diphone: " + this.name);
        System.out.println("    MP : " + this.midPoint);
        int n = 0;
        while (n < this.samples.length) {
            this.samples[n].dump();
            ++n;
        }
    }

    public void dumpBinary(ByteBuffer byteBuffer) throws IOException {
        char[] cArray = (this.name + "        ").toCharArray();
        byteBuffer.putInt(262988031);
        int n = 0;
        while (n < 8) {
            byteBuffer.putChar(cArray[n]);
            ++n;
        }
        byteBuffer.putInt(this.midPoint);
        byteBuffer.putInt(this.samples.length);
        int n2 = 0;
        while (n2 < this.samples.length) {
            this.samples[n2].dumpBinary(byteBuffer);
            ++n2;
        }
    }

    boolean compare(Diphone diphone) {
        if (!this.name.equals(diphone.getName())) {
            return false;
        }
        if (this.midPoint != diphone.getMidPoint()) {
            return false;
        }
        if (this.samples.length != diphone.getSamples().length) {
            return false;
        }
        int n = 0;
        while (n < this.samples.length) {
            if (!this.samples[n].compare(diphone.getSamples(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Diphone loadBinary(ByteBuffer byteBuffer) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (byteBuffer.getInt() != 262988031) {
            throw new Error("Bad magic number in diphone");
        }
        int n2 = 0;
        while (n2 < 8) {
            n = byteBuffer.getChar();
            if (!Character.isWhitespace((char)n)) {
                stringBuffer.append((char)n);
            }
            ++n2;
        }
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        Sample[] sampleArray = new Sample[n4];
        n = 0;
        while (n < n4) {
            sampleArray[n] = Sample.loadBinary(byteBuffer);
            ++n;
        }
        return new Diphone(stringBuffer.toString().trim(), sampleArray, n3);
    }

    public static Diphone loadBinary(DataInputStream dataInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (dataInputStream.readInt() != 262988031) {
            throw new Error("Bad magic number in diphone");
        }
        int n2 = 0;
        while (n2 < 8) {
            n = dataInputStream.readChar();
            if (!Character.isWhitespace((char)n)) {
                stringBuffer.append((char)n);
            }
            ++n2;
        }
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        Sample[] sampleArray = new Sample[n4];
        n = 0;
        while (n < n4) {
            sampleArray[n] = Sample.loadBinary(dataInputStream);
            ++n;
        }
        return new Diphone(stringBuffer.toString().trim(), sampleArray, n3);
    }
}

