/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XImage;

public final class Image
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    Device device;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int width, int height) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, width, height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        int xDisplay = device.xDisplay;
        this.type = srcImage.type;
        this.mask = 0;
        int[] unused = new int[1];
        int[] w = new int[1];
        int[] h = new int[1];
        OS.XGetGeometry(xDisplay, srcImage.pixmap, unused, unused, unused, w, h, unused, unused);
        int width = w[0];
        int height = h[0];
        int drawable = OS.XDefaultRootWindow(xDisplay);
        if (flag != 2 && (srcImage.mask != 0 || srcImage.transparentPixel != -1)) {
            if (srcImage.transparentPixel != -1) {
                srcImage.createMask();
            }
            int mask = OS.XCreatePixmap(xDisplay, drawable, width, height, 1);
            int gc = OS.XCreateGC(xDisplay, mask, 0, null);
            OS.XCopyArea(xDisplay, srcImage.mask, mask, gc, 0, 0, width, height, 0, 0);
            OS.XFreeGC(xDisplay, gc);
            this.mask = mask;
            if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
                srcImage.destroyMask();
            }
        }
        switch (flag) {
            case 0: {
                int[] depth = new int[1];
                OS.XGetGeometry(xDisplay, srcImage.pixmap, unused, unused, unused, unused, unused, unused, depth);
                int pixmap = OS.XCreatePixmap(xDisplay, drawable, width, height, depth[0]);
                int gc = OS.XCreateGC(xDisplay, pixmap, 0, null);
                OS.XCopyArea(xDisplay, srcImage.pixmap, pixmap, gc, 0, 0, width, height, 0, 0);
                OS.XFreeGC(xDisplay, gc);
                this.pixmap = pixmap;
                this.transparentPixel = srcImage.transparentPixel;
                this.alpha = srcImage.alpha;
                if (srcImage.alphaData != null) {
                    this.alphaData = new byte[srcImage.alphaData.length];
                    System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: {
                int pixmap;
                XImage srcXImage = new XImage();
                int srcXImagePtr = OS.XGetImage(xDisplay, srcImage.pixmap, 0, 0, width, height, -1, 2);
                OS.memmove(srcXImage, srcXImagePtr, 88);
                byte[] srcData = new byte[srcXImage.bytes_per_line * srcXImage.height];
                OS.memmove(srcData, srcXImage.data, srcData.length);
                int destPixmap = OS.XCreatePixmap(xDisplay, drawable, width, height, srcXImage.depth);
                XImage destXImage = new XImage();
                int destXImagePtr = OS.XGetImage(xDisplay, drawable, 0, 0, width, height, -1, 2);
                OS.memmove(destXImage, destXImagePtr, 88);
                byte[] destData = new byte[destXImage.bytes_per_line * destXImage.height];
                Color zeroColor = device.getSystemColor(18);
                Color oneColor = device.getSystemColor(22);
                int zeroPixel = zeroColor.handle.pixel;
                int onePixel = oneColor.handle.pixel;
                switch (srcXImage.bits_per_pixel) {
                    case 1: {
                        int gc = OS.XCreateGC(xDisplay, drawable, 0, null);
                        pixmap = OS.XCreatePixmap(xDisplay, drawable, width, height, 1);
                        OS.XCopyArea(xDisplay, srcImage.pixmap, pixmap, gc, 0, 0, width, height, 0, 0);
                        OS.XDestroyImage(srcXImagePtr);
                        OS.XDestroyImage(destXImagePtr);
                        OS.XFreeGC(xDisplay, gc);
                        return;
                    }
                    case 4: {
                        SWT.error(20);
                        break;
                    }
                    case 8: {
                        int index = 0;
                        XColor[] colors = new XColor[256];
                        int colormap = OS.XDefaultColormap(xDisplay, OS.XDefaultScreen(xDisplay));
                        int y = 0;
                        while (y < srcXImage.height) {
                            int x = 0;
                            while (x < srcXImage.bytes_per_line) {
                                int srcPixel = srcData[index + x] & 0xFF;
                                if (colors[srcPixel] == null) {
                                    XColor color = new XColor();
                                    color.pixel = srcPixel;
                                    OS.XQueryColor(xDisplay, colormap, color);
                                    colors[srcPixel] = color;
                                }
                                XColor xColor = colors[srcPixel];
                                int r = xColor.red >> 8 & 0xFF;
                                int g = xColor.green >> 8 & 0xFF;
                                int b = xColor.blue >> 8 & 0xFF;
                                destData[index + x] = r * r + g * g + b * b < 98304 ? (byte)zeroPixel : (byte)onePixel;
                                ++x;
                            }
                            index += srcXImage.bytes_per_line;
                            ++y;
                        }
                        break;
                    }
                    case 16: {
                        int index = 0;
                        Visual visual = new Visual();
                        int screenNum = OS.XDefaultScreen(xDisplay);
                        int visualPtr = OS.XDefaultVisual(xDisplay, screenNum);
                        OS.memmove(visual, visualPtr, 32);
                        int redMask = visual.red_mask;
                        int greenMask = visual.green_mask;
                        int blueMask = visual.blue_mask;
                        int[] shift = new int[1];
                        Image.getOffsetForMask(16, redMask, srcXImage.byte_order, shift);
                        int rShift = 24 - shift[0];
                        Image.getOffsetForMask(16, greenMask, srcXImage.byte_order, shift);
                        int gShift = 24 - shift[0];
                        Image.getOffsetForMask(16, blueMask, srcXImage.byte_order, shift);
                        int bShift = 24 - shift[0];
                        byte zeroLow = (byte)(zeroPixel & 0xFF);
                        byte zeroHigh = (byte)(zeroPixel >> 8 & 0xFF);
                        byte oneLow = (byte)(onePixel & 0xFF);
                        byte oneHigh = (byte)(onePixel >> 8 & 0xFF);
                        int y = 0;
                        while (y < srcXImage.height) {
                            int xIndex = 0;
                            int x = 0;
                            while (x < srcXImage.bytes_per_line) {
                                int srcPixel = (srcData[index + xIndex + 1] & 0xFF) << 8 | srcData[index + xIndex] & 0xFF;
                                int r = (srcPixel & redMask) << rShift >> 16;
                                int g = (srcPixel & greenMask) << gShift >> 16;
                                int b = (srcPixel & blueMask) << bShift >> 16;
                                if (r * r + g * g + b * b < 98304) {
                                    destData[index + xIndex] = zeroLow;
                                    destData[index + xIndex + 1] = zeroHigh;
                                } else {
                                    destData[index + xIndex] = oneLow;
                                    destData[index + xIndex + 1] = oneHigh;
                                }
                                xIndex += srcXImage.bits_per_pixel / 8;
                                x += 2;
                            }
                            index += srcXImage.bytes_per_line;
                            ++y;
                        }
                        break;
                    }
                    case 24: 
                    case 32: {
                        int index = 0;
                        Visual visual = new Visual();
                        int screenNum = OS.XDefaultScreen(xDisplay);
                        int visualPtr = OS.XDefaultVisual(xDisplay, screenNum);
                        OS.memmove(visual, visualPtr, 32);
                        int redMask = visual.red_mask;
                        int greenMask = visual.green_mask;
                        int blueMask = visual.blue_mask;
                        int[] shift = new int[1];
                        Image.getOffsetForMask(srcXImage.bits_per_pixel, redMask, srcXImage.byte_order, shift);
                        int rShift = shift[0];
                        Image.getOffsetForMask(srcXImage.bits_per_pixel, greenMask, srcXImage.byte_order, shift);
                        int gShift = shift[0];
                        Image.getOffsetForMask(srcXImage.bits_per_pixel, blueMask, srcXImage.byte_order, shift);
                        int bShift = shift[0];
                        byte zeroR = (byte)zeroColor.getRed();
                        byte zeroG = (byte)zeroColor.getGreen();
                        byte zeroB = (byte)zeroColor.getBlue();
                        byte oneR = (byte)oneColor.getRed();
                        byte oneG = (byte)oneColor.getGreen();
                        byte oneB = (byte)oneColor.getBlue();
                        int y = 0;
                        while (y < srcXImage.height) {
                            int xIndex = 0;
                            int x = 0;
                            while (x < srcXImage.width) {
                                int r = srcData[index + xIndex + rShift] & 0xFF;
                                int g = srcData[index + xIndex + gShift] & 0xFF;
                                int b = srcData[index + xIndex + bShift] & 0xFF;
                                if (r * r + g * g + b * b < 98304) {
                                    destData[index + xIndex + rShift] = zeroR;
                                    destData[index + xIndex + gShift] = zeroG;
                                    destData[index + xIndex + bShift] = zeroB;
                                } else {
                                    destData[index + xIndex + rShift] = oneR;
                                    destData[index + xIndex + gShift] = oneG;
                                    destData[index + xIndex + bShift] = oneB;
                                }
                                xIndex += destXImage.bits_per_pixel / 8;
                                ++x;
                            }
                            index += srcXImage.bytes_per_line;
                            ++y;
                        }
                        break;
                    }
                    default: {
                        SWT.error(40);
                    }
                }
                OS.memmove(destXImage.data, destData, destData.length);
                int gc = OS.XCreateGC(xDisplay, destPixmap, 0, null);
                OS.XPutImage(xDisplay, destPixmap, gc, destXImagePtr, 0, 0, 0, 0, width, height);
                OS.XDestroyImage(destXImagePtr);
                OS.XDestroyImage(srcXImagePtr);
                OS.XFreeGC(xDisplay, gc);
                this.pixmap = destPixmap;
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 2: {
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(width, height, 8, new PaletteData(rgbs));
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    int[] scanline = new int[width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, width, scanline, 0);
                        int x = 0;
                        while (x < width) {
                            int pixel = scanline[x];
                            int red = pixel & redMask;
                            red = redShift < 0 ? red >>> -redShift : red << redShift;
                            int green = pixel & greenMask;
                            green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                            int blue = pixel & blueMask;
                            blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            newData.data[offset++] = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            ++x;
                        }
                        ++y;
                    }
                }
                this.init(device, newData);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Rectangle bounds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData source, ImageData mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        if (mask.depth != 1) {
            SWT.error(5);
        }
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream stream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(stream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String filename) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(filename));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void createMask() {
        if (this.mask != 0) {
            return;
        }
        int xDisplay = this.device.xDisplay;
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int screenDepth = OS.XDefaultDepthOfScreen(OS.XDefaultScreenOfDisplay(xDisplay));
        int visual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
        ImageData maskImage = this.getImageData().getTransparencyMask();
        int maskPixmap = OS.XCreatePixmap(xDisplay, drawable, maskImage.width, maskImage.height, 1);
        XColor[] xcolors = this.device.xcolors;
        int gc = OS.XCreateGC(xDisplay, maskPixmap, 0, null);
        Image.putImage(maskImage, 0, 0, maskImage.width, maskImage.height, 0, 0, maskImage.width, maskImage.height, xDisplay, visual, screenDepth, xcolors, null, true, maskPixmap, gc);
        OS.XFreeGC(xDisplay, gc);
        this.mask = maskPixmap;
    }

    public void dispose() {
        if (this.pixmap == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        int xDisplay = this.device.xDisplay;
        if (this.pixmap != 0) {
            OS.XFreePixmap(xDisplay, this.pixmap);
        }
        if (this.mask != 0) {
            OS.XFreePixmap(xDisplay, this.mask);
        }
        this.memGC = null;
        this.mask = 0;
        this.pixmap = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.XFreePixmap(this.device.xDisplay, this.mask);
        this.mask = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        XColor xColor = new XColor();
        xColor.pixel = this.transparentPixel;
        int xDisplay = this.device.xDisplay;
        int colormap = OS.XDefaultColormap(xDisplay, OS.XDefaultScreen(xDisplay));
        OS.XQueryColor(xDisplay, colormap, xColor);
        return Color.motif_new(this.device, xColor);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] unused = new int[1];
        int[] width = new int[1];
        int[] height = new int[1];
        OS.XGetGeometry(this.device.xDisplay, this.pixmap, unused, unused, unused, width, height, unused, unused);
        return new Rectangle(0, 0, width[0], height[0]);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rectangle srcBounds = this.getBounds();
        int xDisplay = this.device.xDisplay;
        int width = srcBounds.width;
        int height = srcBounds.height;
        int xSrcImagePtr = OS.XGetImage(xDisplay, this.pixmap, 0, 0, width, height, -1, 2);
        if (xSrcImagePtr == 0) {
            SWT.error(2);
        }
        XImage xSrcImage = new XImage();
        OS.memmove(xSrcImage, xSrcImagePtr, 88);
        PaletteData palette = null;
        int length = xSrcImage.bytes_per_line * xSrcImage.height;
        byte[] srcData = new byte[length];
        OS.memmove(srcData, xSrcImage.data, length);
        switch (xSrcImage.bits_per_pixel) {
            case 1: {
                palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                break;
            }
            case 4: {
                SWT.error(38);
            }
            case 8: {
                byte[] normPixel = new byte[256];
                int index = 0;
                while (index < normPixel.length) {
                    normPixel[index] = 0;
                    ++index;
                }
                int numPixels = 1;
                int index2 = 0;
                int y = 0;
                while (y < xSrcImage.height) {
                    int x = 0;
                    while (x < xSrcImage.bytes_per_line) {
                        int srcPixel = srcData[index2 + x] & 0xFF;
                        if (srcPixel != 0 && normPixel[srcPixel] == 0) {
                            normPixel[srcPixel] = (byte)numPixels++;
                        }
                        srcData[index2 + x] = normPixel[srcPixel];
                        ++x;
                    }
                    index2 += xSrcImage.bytes_per_line;
                    ++y;
                }
                int colormap = OS.XDefaultColormap(xDisplay, OS.XDefaultScreen(xDisplay));
                RGB[] rgbs = new RGB[numPixels];
                XColor color = new XColor();
                int srcPixel = 0;
                while (srcPixel < normPixel.length) {
                    if (srcPixel == 0 || normPixel[srcPixel] != 0) {
                        color.pixel = srcPixel;
                        OS.XQueryColor(xDisplay, colormap, color);
                        int rgbIndex = normPixel[srcPixel] & 0xFF;
                        rgbs[rgbIndex] = new RGB(color.red >> 8 & 0xFF, color.green >> 8 & 0xFF, color.blue >> 8 & 0xFF);
                    }
                    ++srcPixel;
                }
                palette = new PaletteData(rgbs);
                break;
            }
            case 16: {
                byte b;
                if (xSrcImage.byte_order != 1) break;
                int i = 0;
                while (i < srcData.length) {
                    b = srcData[i];
                    srcData[i] = srcData[i + 1];
                    srcData[i + 1] = b;
                    i += 2;
                }
                break;
            }
            case 24: {
                break;
            }
            case 32: {
                byte b;
                if (xSrcImage.byte_order != 0) break;
                int i = 0;
                while (i < srcData.length) {
                    b = srcData[i];
                    srcData[i] = srcData[i + 3];
                    srcData[i + 3] = b;
                    b = srcData[i + 1];
                    srcData[i + 1] = srcData[i + 2];
                    srcData[i + 2] = b;
                    i += 4;
                }
                break;
            }
            default: {
                SWT.error(38);
            }
        }
        if (palette == null) {
            int visual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
            Visual v = new Visual();
            OS.memmove(v, visual, 32);
            palette = new PaletteData(v.red_mask, v.green_mask, v.blue_mask);
        }
        ImageData data = new ImageData(width, height, xSrcImage.bits_per_pixel, palette);
        data.data = srcData;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int xMaskPtr = OS.XGetImage(xDisplay, this.mask, 0, 0, width, height, -1, 2);
            if (xMaskPtr == 0) {
                SWT.error(2);
            }
            XImage xMask = new XImage();
            OS.memmove(xMask, xMaskPtr, 88);
            data.maskData = new byte[xMask.bytes_per_line * xMask.height];
            byte[] maskData = data.maskData;
            data.maskPad = xMask.bitmap_pad / 8;
            OS.memmove(maskData, xMask.data, maskData.length);
            OS.XDestroyImage(xMaskPtr);
            if (xMask.bitmap_bit_order == 0) {
                int i = 0;
                while (i < maskData.length) {
                    byte b = maskData[i];
                    maskData[i] = (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0x80) >> 7);
                    ++i;
                }
            }
        }
        data.transparentPixel = this.transparentPixel;
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        OS.XDestroyImage(xSrcImagePtr);
        return data;
    }

    static boolean getOffsetForMask(int bitspp, int mask, int byteOrder, int[] poff) {
        if (bitspp % 8 != 0) {
            return false;
        }
        switch (mask) {
            case 255: {
                poff[0] = 0;
                break;
            }
            case 65280: {
                poff[0] = 1;
                break;
            }
            case 0xFF0000: {
                poff[0] = 2;
                break;
            }
            case -16777216: {
                poff[0] = 3;
                break;
            }
            case 31: {
                poff[0] = 5;
                break;
            }
            case 992: {
                poff[0] = 10;
                break;
            }
            case 2016: {
                poff[0] = 11;
                break;
            }
            case 31744: {
                poff[0] = 15;
                break;
            }
            case 63488: {
                poff[0] = 16;
                break;
            }
            default: {
                return false;
            }
        }
        if (bitspp == 16) {
            return true;
        }
        if (poff[0] >= bitspp / 8) {
            return false;
        }
        if (byteOrder == 1) {
            poff[0] = bitspp / 8 - 1 - poff[0];
        }
        return true;
    }

    public int hashCode() {
        return this.pixmap;
    }

    void init(Device device, int width, int height) {
        this.device = device;
        if (width <= 0 | height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        int xDisplay = device.xDisplay;
        int screen = OS.XDefaultScreenOfDisplay(xDisplay);
        int depth = OS.XDefaultDepthOfScreen(screen);
        int screenNum = OS.XDefaultScreen(xDisplay);
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int pixmap = OS.XCreatePixmap(xDisplay, drawable, width, height, depth);
        if (pixmap == 0) {
            SWT.error(2);
        }
        int xGC = OS.XCreateGC(xDisplay, drawable, 0, null);
        OS.XSetForeground(xDisplay, xGC, OS.XWhitePixel(xDisplay, screenNum));
        OS.XFillRectangle(xDisplay, pixmap, xGC, 0, 0, width, height);
        OS.XFreeGC(xDisplay, xGC);
        this.pixmap = pixmap;
    }

    void init(Device device, ImageData image) {
        this.device = device;
        if (image == null) {
            SWT.error(4);
        }
        int xDisplay = device.xDisplay;
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int screenDepth = OS.XDefaultDepthOfScreen(OS.XDefaultScreenOfDisplay(xDisplay));
        int visual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
        int pixmap = OS.XCreatePixmap(xDisplay, drawable, image.width, image.height, screenDepth);
        if (pixmap == 0) {
            SWT.error(2);
        }
        int gc = OS.XCreateGC(xDisplay, pixmap, 0, null);
        int[] transPixel = null;
        if (image.transparentPixel != -1) {
            transPixel = new int[]{image.transparentPixel};
        }
        int error = Image.putImage(image, 0, 0, image.width, image.height, 0, 0, image.width, image.height, xDisplay, visual, screenDepth, device.xcolors, transPixel, false, pixmap, gc);
        OS.XFreeGC(xDisplay, gc);
        if (error != 0) {
            OS.XFreePixmap(xDisplay, pixmap);
            SWT.error(error);
        }
        if (image.getTransparencyType() == 2 || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                this.transparentPixel = transPixel[0];
            }
            ImageData maskImage = image.getTransparencyMask();
            int mask = OS.XCreatePixmap(xDisplay, drawable, image.width, image.height, 1);
            gc = OS.XCreateGC(xDisplay, mask, 0, null);
            error = Image.putImage(maskImage, 0, 0, maskImage.width, maskImage.height, 0, 0, maskImage.width, maskImage.height, xDisplay, visual, screenDepth, device.xcolors, null, true, mask, gc);
            OS.XFreeGC(xDisplay, gc);
            if (error != 0) {
                OS.XFreePixmap(xDisplay, pixmap);
                OS.XFreePixmap(xDisplay, mask);
                SWT.error(error);
            }
            this.mask = mask;
            this.type = image.getTransparencyType() == 2 ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = image.alpha;
            if (image.alpha == -1 && image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
        }
        this.pixmap = pixmap;
    }

    public int internal_new_GC(GCData data) {
        int xDisplay;
        int xGC;
        if (this.pixmap == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        if ((xGC = OS.XCreateGC(xDisplay = this.device.xDisplay, this.pixmap, 0, null)) == 0) {
            SWT.error(2);
        }
        if (data != null) {
            data.device = this.device;
            data.display = xDisplay;
            data.drawable = this.pixmap;
            data.fontList = this.device.systemFont.handle;
            data.codePage = this.device.systemFont.codePage;
            data.colormap = OS.XDefaultColormap(xDisplay, OS.XDefaultScreen(xDisplay));
            data.image = this;
        }
        return xGC;
    }

    public void internal_dispose_GC(int gc, GCData data) {
        int xDisplay = 0;
        if (data != null) {
            xDisplay = data.display;
        }
        if (xDisplay == 0 && this.device != null) {
            xDisplay = this.device.xDisplay;
        }
        if (xDisplay == 0) {
            SWT.error(2);
        }
        OS.XFreeGC(xDisplay, gc);
    }

    public boolean isDisposed() {
        return this.pixmap == 0;
    }

    public static Image motif_new(Device device, int type, int pixmap, int mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.device = device;
        image.type = type;
        image.pixmap = pixmap;
        image.mask = mask;
        return image;
    }

    static int putImage(ImageData image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, int display, int visual, int screenDepth, XColor[] xcolors, int[] transparentPixel, boolean isMask, int drawable, int gc) {
        int bufPtr;
        byte[] buf;
        int bufSize;
        XImage xImage;
        boolean screenDirect;
        boolean flipY;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            return 38;
        }
        boolean flipX = destWidth < 0;
        boolean bl = flipY = destHeight < 0;
        if (flipX) {
            destWidth = -destWidth;
            destX -= destWidth;
        }
        if (flipY) {
            destHeight = -destHeight;
            destY -= destHeight;
        }
        byte[] srcReds = null;
        byte[] srcGreens = null;
        byte[] srcBlues = null;
        if (!palette.isDirect) {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            srcReds = new byte[length];
            srcGreens = new byte[length];
            srcBlues = new byte[length];
            int i = 0;
            while (i < rgbs.length) {
                RGB rgb = rgbs[i];
                if (rgb != null) {
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ++i;
            }
        }
        byte[] destReds = null;
        byte[] destGreens = null;
        byte[] destBlues = null;
        int destRedMask = 0;
        int destGreenMask = 0;
        int destBlueMask = 0;
        if (screenDepth <= 8) {
            if (xcolors == null) {
                return 38;
            }
            destReds = new byte[xcolors.length];
            destGreens = new byte[xcolors.length];
            destBlues = new byte[xcolors.length];
            int i = 0;
            while (i < xcolors.length) {
                XColor color = xcolors[i];
                if (color != null) {
                    destReds[i] = (byte)(color.red >> 8 & 0xFF);
                    destGreens[i] = (byte)(color.green >> 8 & 0xFF);
                    destBlues[i] = (byte)(color.blue >> 8 & 0xFF);
                }
                ++i;
            }
            screenDirect = false;
        } else {
            Visual xVisual = new Visual();
            OS.memmove(xVisual, visual, 32);
            destRedMask = xVisual.red_mask;
            destGreenMask = xVisual.green_mask;
            destBlueMask = xVisual.blue_mask;
            screenDirect = true;
        }
        if (transparentPixel != null) {
            int transRed = 0;
            int transGreen = 0;
            int transBlue = 0;
            if (palette.isDirect) {
                RGB rgb = palette.getRGB(transparentPixel[0]);
                transRed = rgb.red;
                transGreen = rgb.green;
                transBlue = rgb.blue;
            } else {
                RGB[] rgbs = palette.getRGBs();
                if (transparentPixel[0] < rgbs.length) {
                    RGB rgb = rgbs[transparentPixel[0]];
                    transRed = rgb.red;
                    transGreen = rgb.green;
                    transBlue = rgb.blue;
                }
            }
            transparentPixel[0] = ImageData.closestMatch(screenDepth, (byte)transRed, (byte)transGreen, (byte)transBlue, destRedMask, destGreenMask, destBlueMask, destReds, destGreens, destBlues);
        }
        if (image.depth == 1) {
            int bufPtr2;
            int xImagePtr = OS.XCreateImage(display, visual, 1, 0, 0, 0, destWidth, destHeight, image.scanlinePad * 8, 0);
            if (xImagePtr == 0) {
                return 2;
            }
            xImage = new XImage();
            OS.memmove(xImage, xImagePtr, 88);
            bufSize = xImage.bytes_per_line * xImage.height;
            xImage.data = bufPtr2 = OS.XtMalloc(bufSize);
            OS.memmove(xImagePtr, xImage, 88);
            buf = new byte[bufSize];
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcX, srcY, srcWidth, srcHeight, null, null, null, 255, null, 0, srcX, srcY, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.bitmap_bit_order, 0, 0, destWidth, destHeight, null, null, null, flipX, flipY);
            OS.memmove(xImage.data, buf, bufSize);
            int foreground = 1;
            int background = 0;
            if (!isMask) {
                foreground = 0;
                if (srcReds.length > 1) {
                    foreground = ImageData.closestMatch(screenDepth, srcReds[1], srcGreens[1], srcBlues[1], destRedMask, destGreenMask, destBlueMask, destReds, destGreens, destBlues);
                }
                if (srcReds.length > 0) {
                    background = ImageData.closestMatch(screenDepth, srcReds[0], srcGreens[0], srcBlues[0], destRedMask, destGreenMask, destBlueMask, destReds, destGreens, destBlues);
                }
            }
            XGCValues values = new XGCValues();
            OS.XGetGCValues(display, gc, 12, values);
            OS.XSetForeground(display, gc, foreground);
            OS.XSetBackground(display, gc, background);
            OS.XPutImage(display, drawable, gc, xImagePtr, 0, 0, destX, destY, destWidth, destHeight);
            OS.XSetForeground(display, gc, values.foreground);
            OS.XSetBackground(display, gc, values.background);
            OS.XDestroyImage(xImagePtr);
            return 0;
        }
        int xImagePtr = OS.XCreateImage(display, visual, screenDepth, 2, 0, 0, destWidth, destHeight, image.scanlinePad * 8, 0);
        if (xImagePtr == 0) {
            return 2;
        }
        xImage = new XImage();
        OS.memmove(xImage, xImagePtr, 88);
        bufSize = xImage.bytes_per_line * xImage.height;
        xImage.data = bufPtr = OS.XtMalloc(bufSize);
        OS.memmove(xImagePtr, xImage, 88);
        buf = new byte[bufSize];
        if (palette.isDirect) {
            if (screenDirect) {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcX, srcY, srcWidth, srcHeight, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, srcX, srcY, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, xImage.red_mask, xImage.green_mask, xImage.blue_mask, flipX, flipY);
            } else {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcX, srcY, srcWidth, srcHeight, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, srcX, srcY, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, destReds, destGreens, destBlues, flipX, flipY);
            }
        } else if (screenDirect) {
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcX, srcY, srcWidth, srcHeight, srcReds, srcGreens, srcBlues, 255, null, 0, srcX, srcY, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, xImage.red_mask, xImage.green_mask, xImage.blue_mask, flipX, flipY);
        } else {
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcX, srcY, srcWidth, srcHeight, srcReds, srcGreens, srcBlues, 255, null, 0, srcX, srcY, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, destReds, destGreens, destBlues, flipX, flipY);
        }
        OS.memmove(xImage.data, buf, bufSize);
        OS.XPutImage(display, drawable, gc, xImagePtr, 0, 0, destX, destY, destWidth, destHeight);
        OS.XDestroyImage(xImagePtr);
        return 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        if (this.mask == 0) {
            this.createMask();
        }
        Rectangle bounds = this.getBounds();
        int[] unused = new int[1];
        int[] depth = new int[1];
        int xDisplay = this.device.xDisplay;
        OS.XGetGeometry(xDisplay, this.pixmap, unused, unused, unused, unused, unused, unused, depth);
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int tempPixmap = OS.XCreatePixmap(xDisplay, drawable, bounds.width, bounds.height, depth[0]);
        int xGC = OS.XCreateGC(xDisplay, tempPixmap, 0, null);
        OS.XSetForeground(xDisplay, xGC, color.handle.pixel);
        OS.XFillRectangle(xDisplay, tempPixmap, xGC, 0, 0, bounds.width, bounds.height);
        OS.XSetClipMask(xDisplay, xGC, this.mask);
        OS.XCopyArea(xDisplay, this.pixmap, tempPixmap, xGC, 0, 0, bounds.width, bounds.height, 0, 0);
        OS.XSetClipMask(xDisplay, xGC, 0);
        OS.XCopyArea(xDisplay, tempPixmap, this.pixmap, xGC, 0, 0, bounds.width, bounds.height, 0, 0);
        OS.XFreePixmap(xDisplay, tempPixmap);
        OS.XFreeGC(xDisplay, xGC);
        if (this.memGC != null) {
            this.destroyMask();
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

