/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class Label
extends Control {
    String text = "";
    Image image;
    Image bitmap;
    Image disabled;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 2) != 0) {
            style = Widget.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Widget.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                width += 64;
                height += 3;
            } else {
                width += 3;
                height += 64;
            }
            if (wHint != -1) {
                width = wHint + border * 2;
            }
            if (hHint != -1) {
                height = hHint + border * 2;
            }
            return new Point(width, height);
        }
        int[] argList = new int[]{OS.XmNlabelType, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int labelType = argList[1];
        if (labelType == 2 && (this.style & 0x40) != 0 && wHint != -1) {
            int[] argList4 = new int[]{OS.XmNmarginTop, 0, OS.XmNmarginBottom, 0, OS.XmNmarginHeight, 0, OS.XmNmarginWidth, 0};
            OS.XtGetValues(this.handle, argList4, argList4.length / 2);
            int unavailable = 2 * (argList4[7] + this.getBorderWidth());
            Display display = this.getDisplay();
            String string = display.wrapText(this.text, this.font, wHint - unavailable);
            GC gc = new GC(this);
            Point extent = gc.textExtent(string);
            gc.dispose();
            height = extent.y + argList4[1] + argList4[3] + argList4[5] * 2 + border * 2;
        } else {
            XtWidgetGeometry result = new XtWidgetGeometry();
            result.request_mode = 12;
            int[] argList2 = new int[]{OS.XmNrecomputeSize, 1};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            OS.XtQueryGeometry(this.handle, null, result);
            int[] argList3 = new int[]{OS.XmNrecomputeSize, 0};
            OS.XtSetValues(this.handle, argList3, argList3.length / 2);
            width += result.width;
            height += result.height;
        }
        if (labelType == 2 && this.text.length() == 0) {
            height += this.getFontHeight();
            width = 0;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        int borderWidth;
        this.state |= 0x800;
        int parentHandle = this.parent.handle;
        int n = borderWidth = (this.style & 0x800) != 0 ? 1 : 0;
        if ((this.style & 2) != 0) {
            int separatorType = this.separatorType();
            int orientation = (this.style & 0x100) != 0 ? 2 : 1;
            int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, borderWidth, OS.XmNorientation, orientation, OS.XmNseparatorType, separatorType};
            this.handle = OS.XmCreateSeparator(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int alignment = 0;
        if ((this.style & 0x1000000) != 0) {
            alignment = 1;
        }
        if ((this.style & 0x20000) != 0) {
            alignment = 2;
        }
        int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNrecomputeSize, 0, OS.XmNalignment, alignment, OS.XmNborderWidth, borderWidth};
        this.handle = OS.XmCreateLabel(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    int defaultBackground() {
        return this.getDisplay().labelBackground;
    }

    Font defaultFont() {
        return this.getDisplay().labelFont;
    }

    int defaultForeground() {
        return this.getDisplay().labelForeground;
    }

    public boolean forceFocus() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtraversalOn, 1};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.overrideTranslations();
        if (super.forceFocus()) {
            return true;
        }
        argList[1] = 0;
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        return false;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        int[] argList = new int[]{OS.XmNalignment, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int alignment = argList[1];
        if (alignment == 0) {
            return 16384;
        }
        if (alignment == 1) {
            return 0x1000000;
        }
        if (alignment == 2) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean mnemonicHit(char key) {
        Composite control = this.parent;
        while (control != null) {
            Control[] children = control._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        int[] argList = new int[]{OS.XmNlabelPixmap, 2, OS.XmNlabelInsensitivePixmap, 2};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        this.image = null;
    }

    int separatorType() {
        if ((this.style & 4) != 0) {
            return 5;
        }
        if ((this.style & 8) != 0) {
            return 6;
        }
        return 5;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNalignment, 0};
        if ((alignment & 0x1000000) != 0) {
            argList[1] = 1;
        }
        if ((alignment & 0x20000) != 0) {
            argList[1] = 2;
        }
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] argList = new int[]{OS.XmNlabelType, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 1) {
            this.setBitmap(this.image);
        }
    }

    void setBitmap(Image image) {
        int labelPixmap = 2;
        int labelInsensitivePixmap = 2;
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            Display display = this.getDisplay();
            switch (image.type) {
                case 0: {
                    labelPixmap = image.pixmap;
                    this.disabled = new Image((Device)display, image, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                case 1: {
                    Rectangle rect = image.getBounds();
                    this.bitmap = new Image((Device)display, rect.width, rect.height);
                    GC gc = new GC(this.bitmap);
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                    gc.drawImage(image, 0, 0);
                    gc.dispose();
                    labelPixmap = this.bitmap.pixmap;
                    this.disabled = new Image((Device)display, this.bitmap, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
        }
        int[] argList = new int[]{OS.XmNlabelType, 1, OS.XmNlabelPixmap, labelPixmap, OS.XmNlabelInsensitivePixmap, labelInsensitivePixmap};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize && (this.style & 0x40) != 0) {
            this.setText(this.text);
        }
        return changed;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if ((this.style & 0x40) != 0) {
            this.setText(this.text);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        this.setBitmap(this.image);
    }

    public void setText(String string) {
        byte[] buffer;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] unicode = new char[string.length()];
        string.getChars(0, unicode.length, unicode, 0);
        int i = 0;
        int j = 0;
        int mnemonic = 0;
        while (i < unicode.length) {
            if ((unicode[j++] = unicode[i++]) != '&' || i == unicode.length) continue;
            if (unicode[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == 0) {
                mnemonic = unicode[i];
            }
            --j;
        }
        while (j < unicode.length) {
            unicode[j++] = '\u0000';
        }
        if ((this.style & 0x40) != 0) {
            int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNmarginLeft, 0, OS.XmNmarginRight, 0, OS.XmNborderWidth, 0, OS.XmNmarginWidth, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int width = argList[1] - argList[3] - argList[5] - argList[7] * 2 - argList[9] * 2;
            Display display = this.getDisplay();
            if (mnemonic != 0) {
                string = new String(unicode);
            }
            string = display.wrapText(string, this.font, width);
            buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        } else {
            buffer = Converter.wcsToMbcs(this.getCodePage(), unicode, true);
        }
        int xmString = OS.XmStringGenerate(buffer, null, 0, null);
        if (xmString == 0) {
            this.error(13);
        }
        if (mnemonic == 0 || string.indexOf(10) != -1) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString, OS.XmNmnemonic, mnemonic};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (xmString != 0) {
            OS.XmStringFree(xmString);
        }
    }

    int xFocusOut() {
        int result = super.xFocusOut();
        if (this.handle == 0) {
            return result;
        }
        int[] argList = new int[]{OS.XmNtraversalOn, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] != 0) {
            argList[1] = 0;
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        }
        return result;
    }
}

