/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    Display display;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    int cursorOrientation = 0;
    int cursor;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
        this.display = parent.getDisplay();
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor(int xDisplay, int xWindow) {
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        Rectangle bounds = this.computeBounds();
        int newX = bounds.x + bounds.width / 2;
        int newY = bounds.y;
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor(int xDisplay, int xWindow) {
        Rectangle bounds = this.computeBounds();
        int newX = (this.cursorOrientation & 0x4000) != 0 ? bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? bounds.x + bounds.width : bounds.x + bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? bounds.y : ((this.cursorOrientation & 0x400) != 0 ? bounds.y + bounds.height : bounds.y + bounds.height / 2);
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        Rectangle bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            result[i] = new Rectangle((rects[i].x - bounds.x) * 100 / bounds.width, (rects[i].y - bounds.y) * 100 / bounds.height, rects[i].width * 100 / bounds.width, rects[i].height * 100 / bounds.height);
            ++i;
        }
        return result;
    }

    void drawRectangles() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int xDisplay = this.display.xDisplay;
        int color = OS.XWhitePixel(xDisplay, 0);
        int xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null) {
            xWindow = OS.XtWindow(this.parent.handle);
            if (xWindow == 0) {
                return;
            }
            int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0};
            OS.XtGetValues(this.parent.handle, argList, argList.length / 2);
            color = argList[1] ^ argList[3];
        }
        int gc = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XSetForeground(xDisplay, gc, color);
        OS.XSetSubwindowMode(xDisplay, gc, 1);
        OS.XSetFunction(xDisplay, gc, 6);
        int stipplePixmap = 0;
        if (this.stippled) {
            byte[] bits = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
            stipplePixmap = OS.XCreateBitmapFromData(xDisplay, xWindow, bits, 8, 8);
            OS.XSetStipple(xDisplay, gc, stipplePixmap);
            OS.XSetFillStyle(xDisplay, gc, 2);
            OS.XSetLineAttributes(xDisplay, gc, 3, 0, 1, 0);
        }
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle rect = this.rectangles[i];
            OS.XDrawRectangle(xDisplay, xWindow, gc, rect.x, rect.y, rect.width, rect.height);
            ++i;
        }
        if (this.stippled) {
            OS.XFreePixmap(xDisplay, stipplePixmap);
        }
        OS.XFreeGC(xDisplay, gc);
    }

    public Display getDisplay() {
        return this.display;
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        return this.rectangles;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            return;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            return;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            return;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            return;
        }
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        Point cursorPos;
        boolean mouseDown;
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        int xDisplay = this.display.xDisplay;
        int xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null && (xWindow = OS.XtWindow(this.parent.handle)) == 0) {
            return false;
        }
        boolean cancelled = false;
        this.tracking = true;
        this.drawRectangles();
        int[] oldX = new int[1];
        int[] oldY = new int[1];
        int[] unused = new int[1];
        int[] mask = new int[1];
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, oldX, oldY, unused, unused, mask);
        int mouseMasks = 1792;
        boolean bl = mouseDown = (mask[0] & mouseMasks) != 0;
        if (!mouseDown) {
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor(xDisplay, xWindow) : this.adjustMoveCursor(xDisplay, xWindow);
            oldX[0] = cursorPos.x;
            oldY[0] = cursorPos.y;
        }
        XAnyEvent xEvent = new XAnyEvent();
        int[] newX = new int[1];
        int[] newY = new int[1];
        int xtContext = OS.XtDisplayToApplicationContext(xDisplay);
        int ptrGrabResult = OS.XGrabPointer(xDisplay, xWindow, 0, 76, 1, 1, 0, 0, 0);
        int kbdGrabResult = OS.XGrabKeyboard(xDisplay, xWindow, 0, 1, 1, 0);
        block14: while (this.tracking) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.XtAppNextEvent(xtContext, xEvent);
            switch (xEvent.type) {
                case 6: {
                    if (this.cursor != 0) {
                        OS.XChangeActivePointerGrab(xDisplay, 76, this.cursor, 0);
                    }
                }
                case 5: {
                    OS.XQueryPointer(xDisplay, xWindow, unused, unused, newX, newY, unused, unused, unused);
                    if (oldX[0] != newX[0] || oldY[0] != newY[0]) {
                        this.drawRectangles();
                        Event event = new Event();
                        event.x = newX[0];
                        event.y = newY[0];
                        if ((this.style & 0x10) != 0) {
                            this.resizeRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                            this.sendEvent(11, event);
                            cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                            newX[0] = cursorPos.x;
                            newY[0] = cursorPos.y;
                        } else {
                            this.moveRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                            this.sendEvent(10, event);
                        }
                        if (this.isDisposed()) {
                            if (ptrGrabResult == 0) {
                                OS.XUngrabPointer(xDisplay, 0);
                            }
                            if (kbdGrabResult == 0) {
                                OS.XUngrabKeyboard(xDisplay, 0);
                            }
                            return false;
                        }
                        this.drawRectangles();
                        oldX[0] = newX[0];
                        oldY[0] = newY[0];
                    }
                    this.tracking = xEvent.type != 5;
                    break;
                }
                case 2: {
                    XKeyEvent keyEvent = new XKeyEvent();
                    OS.memmove(keyEvent, xEvent, 96);
                    if (keyEvent.keycode == 0) continue block14;
                    int[] keysym = new int[1];
                    OS.XLookupString(keyEvent, null, 0, keysym, null);
                    keysym[0] = keysym[0] & 0xFFFF;
                    int xChange = 0;
                    int yChange = 0;
                    int stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
                    switch (keysym[0]) {
                        case 65293: 
                        case 65421: {
                            this.tracking = false;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65307: 
                        case 65385: {
                            this.tracking = false;
                            cancelled = true;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65361: {
                            xChange = -stepSize;
                            break;
                        }
                        case 65363: {
                            xChange = stepSize;
                            break;
                        }
                        case 65362: {
                            yChange = -stepSize;
                            break;
                        }
                        case 65364: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) continue block14;
                    this.drawRectangles();
                    Event event = new Event();
                    event.x = oldX[0] + xChange;
                    event.y = oldY[0] + yChange;
                    if ((this.style & 0x10) != 0) {
                        this.resizeRectangles(xChange, yChange);
                        this.sendEvent(11, event);
                        cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                    } else {
                        this.moveRectangles(xChange, yChange);
                        this.sendEvent(10, event);
                        cursorPos = this.adjustMoveCursor(xDisplay, xWindow);
                    }
                    if (this.isDisposed()) {
                        if (ptrGrabResult == 0) {
                            OS.XUngrabPointer(xDisplay, 0);
                        }
                        if (kbdGrabResult == 0) {
                            OS.XUngrabKeyboard(xDisplay, 0);
                        }
                        return false;
                    }
                    this.drawRectangles();
                    oldX[0] = cursorPos.x;
                    oldY[0] = cursorPos.y;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    OS.XtDispatchEvent(xEvent);
                }
            }
        }
        this.drawRectangles();
        if (ptrGrabResult == 0) {
            OS.XUngrabPointer(xDisplay, 0);
        }
        if (kbdGrabResult == 0) {
            OS.XUngrabKeyboard(xDisplay, 0);
        }
        return !cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        Rectangle bounds = this.computeBounds();
        if ((this.cursorOrientation & 0x4000) != 0) {
            bounds.x += xChange;
            bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            bounds.y += yChange;
            bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            bounds.height += yChange;
        }
        if (bounds.width < 0 || bounds.height < 0) {
            return;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle proportion = this.proportions[i];
            newRects[i] = new Rectangle(proportion.x * bounds.width / 100 + bounds.x, proportion.y * bounds.height / 100 + bounds.y, proportion.width * bounds.width / 100, proportion.height * bounds.height / 100);
            ++i;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        this.rectangles = rectangles;
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

