/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WidgetTable {
    static int FreeSlot = 0;
    static int GrowSize = 1024;
    static int[] IndexTable = new int[GrowSize];
    static Shell[] Shells = new Shell[GrowSize / 8];
    static Widget[] WidgetTable = new Widget[GrowSize];
    static int[] ArgList = new int[]{OS.XmNuserData, 0};

    WidgetTable() {
    }

    public static synchronized Widget get(int handle) {
        if (handle == 0) {
            return null;
        }
        if (OS.XtIsSubclass(handle, OS.ShellWidgetClass())) {
            int i = 0;
            while (i < Shells.length) {
                Shell shell = Shells[i];
                if (shell != null && ((Widget)shell).topHandle() == handle) {
                    return shell;
                }
                ++i;
            }
            return null;
        }
        org.eclipse.swt.widgets.WidgetTable.ArgList[1] = 0;
        OS.XtGetValues(handle, ArgList, ArgList.length / 2);
        if (ArgList[1] == 0) {
            return null;
        }
        int index = ArgList[1] - 1;
        if (0 <= index && index < WidgetTable.length) {
            return WidgetTable[index];
        }
        return null;
    }

    public static synchronized void put(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (OS.XtIsSubclass(handle, OS.ShellWidgetClass())) {
            int i = 0;
            while (i < Shells.length) {
                if (Shells[i] == null) {
                    org.eclipse.swt.widgets.WidgetTable.Shells[i] = (Shell)widget;
                    return;
                }
                ++i;
            }
            Shell[] newShells = new Shell[Shells.length + GrowSize / 8];
            System.arraycopy(Shells, 0, newShells, 0, Shells.length);
            newShells[org.eclipse.swt.widgets.WidgetTable.Shells.length] = (Shell)widget;
            Shells = newShells;
            return;
        }
        if (FreeSlot == -1) {
            FreeSlot = IndexTable.length;
            int length = FreeSlot + GrowSize;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(IndexTable, 0, newIndexTable, 0, FreeSlot);
            System.arraycopy(WidgetTable, 0, newWidgetTable, 0, FreeSlot);
            int i = FreeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            IndexTable = newIndexTable;
            WidgetTable = newWidgetTable;
        }
        org.eclipse.swt.widgets.WidgetTable.ArgList[1] = FreeSlot + 1;
        OS.XtSetValues(handle, ArgList, ArgList.length / 2);
        int oldSlot = FreeSlot;
        FreeSlot = IndexTable[oldSlot];
        org.eclipse.swt.widgets.WidgetTable.IndexTable[oldSlot] = -2;
        org.eclipse.swt.widgets.WidgetTable.WidgetTable[oldSlot] = widget;
    }

    public static synchronized Widget remove(int handle) {
        if (handle == 0) {
            return null;
        }
        if (OS.XtIsSubclass(handle, OS.ShellWidgetClass())) {
            int i = 0;
            while (i < Shells.length) {
                Shell shell = Shells[i];
                if (shell != null && ((Widget)shell).topHandle() == handle) {
                    org.eclipse.swt.widgets.WidgetTable.Shells[i] = null;
                    return shell;
                }
                ++i;
            }
            return null;
        }
        org.eclipse.swt.widgets.WidgetTable.ArgList[1] = 0;
        Widget widget = null;
        OS.XtGetValues(handle, ArgList, ArgList.length / 2);
        int index = ArgList[1] - 1;
        if (0 <= index && index < WidgetTable.length) {
            widget = WidgetTable[index];
            org.eclipse.swt.widgets.WidgetTable.WidgetTable[index] = null;
            org.eclipse.swt.widgets.WidgetTable.IndexTable[index] = FreeSlot;
            FreeSlot = index;
            org.eclipse.swt.widgets.WidgetTable.ArgList[1] = 0;
            OS.XtSetValues(handle, ArgList, ArgList.length / 2);
        }
        return widget;
    }

    public static synchronized Shell[] shells() {
        int length = 0;
        int i = 0;
        while (i < Shells.length) {
            if (Shells[i] != null) {
                ++length;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[length];
        int i2 = 0;
        while (i2 < Shells.length) {
            Shell widget = Shells[i2];
            if (widget != null) {
                result[index++] = widget;
            }
            ++i2;
        }
        return result;
    }

    public static synchronized int size() {
        int length = 0;
        int i = 0;
        while (i < Shells.length) {
            if (Shells[i] != null) {
                ++length;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < WidgetTable.length) {
            if (WidgetTable[i2] != null) {
                ++length;
            }
            ++i2;
        }
        return length;
    }

    static {
        int i = 0;
        while (i < GrowSize - 1) {
            org.eclipse.swt.widgets.WidgetTable.IndexTable[i] = i + 1;
            ++i;
        }
        org.eclipse.swt.widgets.WidgetTable.IndexTable[org.eclipse.swt.widgets.WidgetTable.GrowSize - 1] = -1;
    }
}

