/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Control;

public final class FormData {
    public int height;
    public int width;
    public FormAttachment left;
    public FormAttachment right;
    public FormAttachment top;
    public FormAttachment bottom;
    int cacheHeight;
    int cacheWidth;
    FormAttachment cacheLeft;
    FormAttachment cacheRight;
    FormAttachment cacheTop;
    FormAttachment cacheBottom;
    boolean isVisited;

    public FormData() {
        this(-1, -1);
    }

    public FormData(int width, int height) {
        this.width = width;
        this.height = height;
    }

    FormAttachment getBottomAttachment() {
        if (this.cacheBottom != null) {
            return this.cacheBottom;
        }
        if (this.isVisited) {
            this.cacheBottom = new FormAttachment(0, this.cacheHeight);
            return this.cacheBottom;
        }
        if (this.bottom == null) {
            if (this.top == null) {
                this.cacheBottom = new FormAttachment(0, this.cacheHeight);
                return this.cacheBottom;
            }
            this.cacheBottom = this.getTopAttachment().plus(this.cacheHeight);
            return this.cacheBottom;
        }
        Control control = this.bottom.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.bottom.control = null;
        }
        if (control == null) {
            this.cacheBottom = this.bottom;
            return this.cacheBottom;
        }
        this.isVisited = true;
        FormData bottomData = (FormData)control.getLayoutData();
        FormAttachment topAttachment = bottomData.getTopAttachment();
        FormAttachment bottomAttachment = bottomData.getBottomAttachment();
        this.isVisited = false;
        switch (this.bottom.alignment) {
            case 1024: {
                this.cacheBottom = bottomAttachment.plus(this.bottom.offset);
                return this.cacheBottom;
            }
            case 0x1000000: {
                FormAttachment bottomHeight = bottomAttachment.minus(topAttachment);
                this.cacheBottom = bottomAttachment.minus(bottomHeight.minus(this.cacheHeight).divide(2));
                return this.cacheBottom;
            }
        }
        this.cacheBottom = topAttachment.plus(this.bottom.offset);
        return this.cacheBottom;
    }

    FormAttachment getLeftAttachment() {
        if (this.cacheLeft != null) {
            return this.cacheLeft;
        }
        if (this.isVisited) {
            this.cacheLeft = new FormAttachment(0, 0);
            return this.cacheLeft;
        }
        if (this.left == null) {
            if (this.right == null) {
                this.cacheLeft = new FormAttachment(0, 0);
                return this.cacheLeft;
            }
            this.cacheLeft = this.getRightAttachment().minus(this.cacheWidth);
            return this.cacheLeft;
        }
        Control control = this.left.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.left.control = null;
        }
        if (control == null) {
            this.cacheLeft = this.left;
            return this.cacheLeft;
        }
        this.isVisited = true;
        FormData leftData = (FormData)control.getLayoutData();
        FormAttachment rightAttachment = leftData.getRightAttachment();
        FormAttachment leftAttachment = leftData.getLeftAttachment();
        this.isVisited = false;
        switch (this.left.alignment) {
            case 16384: {
                this.cacheLeft = leftAttachment.plus(this.left.offset);
                return this.cacheLeft;
            }
            case 0x1000000: {
                FormAttachment leftWidth = rightAttachment.minus(leftAttachment);
                this.cacheLeft = leftAttachment.plus(leftWidth.minus(this.cacheWidth).divide(2));
                return this.cacheLeft;
            }
        }
        this.cacheLeft = rightAttachment.plus(this.left.offset);
        return this.cacheLeft;
    }

    FormAttachment getRightAttachment() {
        if (this.cacheRight != null) {
            return this.cacheRight;
        }
        if (this.isVisited) {
            this.cacheRight = new FormAttachment(0, this.cacheWidth);
            return this.cacheRight;
        }
        if (this.right == null) {
            if (this.left == null) {
                this.cacheRight = new FormAttachment(0, this.cacheWidth);
                return this.cacheRight;
            }
            this.cacheRight = this.getLeftAttachment().plus(this.cacheWidth);
            return this.cacheRight;
        }
        Control control = this.right.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.right.control = null;
        }
        if (control == null) {
            this.cacheRight = this.right;
            return this.cacheRight;
        }
        this.isVisited = true;
        FormData rightData = (FormData)control.getLayoutData();
        FormAttachment leftAttachment = rightData.getLeftAttachment();
        FormAttachment rightAttachment = rightData.getRightAttachment();
        this.isVisited = false;
        switch (this.right.alignment) {
            case 131072: {
                this.cacheRight = rightAttachment.plus(this.right.offset);
                return this.cacheRight;
            }
            case 0x1000000: {
                FormAttachment rightWidth = rightAttachment.minus(leftAttachment);
                this.cacheRight = rightAttachment.minus(rightWidth.minus(this.cacheWidth).divide(2));
                return this.cacheRight;
            }
        }
        this.cacheRight = leftAttachment.plus(this.right.offset);
        return this.cacheRight;
    }

    FormAttachment getTopAttachment() {
        if (this.cacheTop != null) {
            return this.cacheTop;
        }
        if (this.isVisited) {
            this.cacheTop = new FormAttachment(0, 0);
            return this.cacheTop;
        }
        if (this.top == null) {
            if (this.bottom == null) {
                this.cacheTop = new FormAttachment(0, 0);
                return this.cacheTop;
            }
            this.cacheTop = this.getBottomAttachment().minus(this.cacheHeight);
            return this.cacheTop;
        }
        Control control = this.top.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.top.control = null;
        }
        if (control == null) {
            this.cacheTop = this.top;
            return this.cacheTop;
        }
        this.isVisited = true;
        FormData topData = (FormData)control.getLayoutData();
        FormAttachment topAttachment = topData.getTopAttachment();
        FormAttachment bottomAttachment = topData.getBottomAttachment();
        this.isVisited = false;
        switch (this.top.alignment) {
            case 128: {
                this.cacheTop = topAttachment.plus(this.top.offset);
                return this.cacheTop;
            }
            case 0x1000000: {
                FormAttachment topHeight = bottomAttachment.minus(topAttachment);
                this.cacheTop = topAttachment.plus(topHeight.minus(this.cacheHeight).divide(2));
                return this.cacheTop;
            }
        }
        this.cacheTop = bottomAttachment.plus(this.top.offset);
        return this.cacheTop;
    }
}

