/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int tooltipsHandle;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation((int)this.handle, (int)orientation);
    }

    Control[] _getChildren() {
        Control[] children = super._getChildren();
        int count = 0;
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.control != null) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return children;
        }
        Control[] newChildren = new Control[children.length + count];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        int index = children.length;
        int i2 = 0;
        while (i2 < items.length) {
            ToolItem item = items[i2];
            if (item != null && item.control != null) {
                newChildren[index++] = item.control;
            }
            ++i2;
        }
        return newChildren;
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    void createHandle(int index) {
        this.state |= 0x800;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        OS.gtk_widget_show((int)this.fixedHandle);
        OS.gtk_widget_show((int)this.handle);
        if ((this.style & 0x800000) != 0) {
            int style = OS.gtk_widget_get_modifier_style((int)this.handle);
            OS.gtk_rc_style_set_xthickness((int)style, (int)0);
            OS.gtk_rc_style_set_ythickness((int)style, (int)0);
            OS.gtk_widget_modify_style((int)this.handle, (int)style);
        }
    }

    void enableWidget(boolean enabled) {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.layout != null) {
            super.computeSize(wHint, hHint, changed);
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        ToolItem[] items = this.getItems();
        if (point == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getBounds().contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return 0;
        }
        int itemCount = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length((int)list);
        ToolItem[] result = new ToolItem[count];
        int i = 0;
        while (i < count) {
            int data = OS.g_list_nth_data((int)list, (int)i);
            Widget widget = this.display.getWidget(data);
            result[i] = (ToolItem)widget;
            ++i;
        }
        OS.g_list_free((int)list);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void releaseWidget() {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        items = null;
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref((int)this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setForegroundColor(color);
            }
            ++i;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        int tooltipsHandle = this.tooltipsHandle();
        if (string == null) {
            OS.gtk_tooltips_enable((int)tooltipsHandle);
        } else {
            OS.gtk_tooltips_disable((int)tooltipsHandle);
        }
    }

    int tooltipsHandle() {
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.tooltipsHandle);
            OS.gtk_object_sink((int)this.tooltipsHandle);
        }
        return this.tooltipsHandle;
    }
}

