/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.PorterStemmer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class PorterStemFilter
extends TokenFilter {
    private PorterStemmer stemmer = new PorterStemmer();

    public PorterStemFilter(TokenStream tokenStream) {
        this.input = tokenStream;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = this.stemmer.stem(token.termText);
        if (string != token.termText) {
            token.termText = string;
        }
        return token;
    }
}

