/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import org.apache.lucene.document.DateField;

public final class Field
implements Serializable {
    private String name = "body";
    private String stringValue = null;
    private Reader readerValue = null;
    private boolean isStored = false;
    private boolean isIndexed = true;
    private boolean isTokenized = true;
    private float boost = 1.0f;

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public static final Field Keyword(String string, String string2) {
        return new Field(string, string2, true, true, false);
    }

    public static final Field UnIndexed(String string, String string2) {
        return new Field(string, string2, true, false, false);
    }

    public static final Field Text(String string, String string2) {
        return new Field(string, string2, true, true, true);
    }

    public static final Field Keyword(String string, Date date) {
        return new Field(string, DateField.dateToString(date), true, true, true);
    }

    public static final Field UnStored(String string, String string2) {
        return new Field(string, string2, false, true, true);
    }

    public static final Field Text(String string, Reader reader) {
        return new Field(string, reader);
    }

    public String name() {
        return this.name;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public Reader readerValue() {
        return this.readerValue;
    }

    public Field(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = string.intern();
        this.stringValue = string2;
        this.isStored = bl;
        this.isIndexed = bl2;
        this.isTokenized = bl3;
    }

    Field(String string, Reader reader) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = string.intern();
        this.readerValue = reader;
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final String toString() {
        if (this.isStored && this.isIndexed && !this.isTokenized) {
            return "Keyword<" + this.name + ":" + this.stringValue + ">";
        }
        if (this.isStored && !this.isIndexed && !this.isTokenized) {
            return "Unindexed<" + this.name + ":" + this.stringValue + ">";
        }
        if (this.isStored && this.isIndexed && this.isTokenized && this.stringValue != null) {
            return "Text<" + this.name + ":" + this.stringValue + ">";
        }
        if (!this.isStored && this.isIndexed && this.isTokenized && this.readerValue != null) {
            return "Text<" + this.name + ":" + this.readerValue + ">";
        }
        return super.toString();
    }
}

