/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.Posting;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private float[] fieldBoosts;
    private final Term termBuffer = new Term("", "");

    DocumentWriter(Directory directory, Analyzer analyzer, int n) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.maxFieldLength = n;
    }

    final void addDocument(String string, Document document) throws IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(document);
        this.fieldInfos.write(this.directory, string + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, string, this.fieldInfos);
        try {
            fieldsWriter.addDocument(document);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fieldsWriter.close();
            throw throwable;
        }
        fieldsWriter.close();
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, document.getBoost());
        this.invertDocument(document);
        Posting[] postingArray = this.sortPostingTable();
        this.writePostings(postingArray, string);
        this.writeNorms(document, string);
    }

    private final void invertDocument(Document document) throws IOException {
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            String string = field.name();
            int n = this.fieldInfos.fieldNumber(string);
            int n2 = this.fieldLengths[n];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                this.addPosition(string, field.stringValue(), n2++);
            } else {
                Object var11_10;
                Reader reader;
                if (field.readerValue() != null) {
                    reader = field.readerValue();
                } else if (field.stringValue() != null) {
                    reader = new StringReader(field.stringValue());
                } else {
                    throw new IllegalArgumentException("field must have either String or Reader value");
                }
                TokenStream tokenStream = this.analyzer.tokenStream(string, reader);
                try {
                    Token token = tokenStream.next();
                    while (token != null) {
                        n2 += token.getPositionIncrement() - 1;
                        this.addPosition(string, token.termText(), n2++);
                        if (n2 > this.maxFieldLength) break;
                        token = tokenStream.next();
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    tokenStream.close();
                    throw throwable;
                }
                tokenStream.close();
                {
                }
            }
            this.fieldLengths[n] = n2;
            int n3 = n;
            this.fieldBoosts[n3] = this.fieldBoosts[n3] * field.getBoost();
        }
    }

    private final void addPosition(String string, String string2, int n) {
        this.termBuffer.set(string, string2);
        Posting posting = (Posting)this.postingTable.get(this.termBuffer);
        if (posting != null) {
            int n2 = posting.freq;
            if (posting.positions.length == n2) {
                int[] nArray = new int[n2 * 2];
                int[] nArray2 = posting.positions;
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = nArray2[n3];
                    ++n3;
                }
                posting.positions = nArray;
            }
            posting.positions[n2] = n;
            posting.freq = n2 + 1;
        } else {
            Term term = new Term(string, string2, false);
            this.postingTable.put(term, new Posting(term, n));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] postingArray = new Posting[this.postingTable.size()];
        Enumeration enumeration = this.postingTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            postingArray[n] = (Posting)enumeration.nextElement();
            ++n;
        }
        DocumentWriter.quickSort(postingArray, 0, postingArray.length - 1);
        return postingArray;
    }

    private static final void quickSort(Posting[] postingArray, int n, int n2) {
        int n3;
        int n4;
        Posting posting;
        if (n >= n2) {
            return;
        }
        int n5 = (n + n2) / 2;
        if (postingArray[n].term.compareTo(postingArray[n5].term) > 0) {
            posting = postingArray[n];
            postingArray[n] = postingArray[n5];
            postingArray[n5] = posting;
        }
        if (postingArray[n5].term.compareTo(postingArray[n2].term) > 0) {
            posting = postingArray[n5];
            postingArray[n5] = postingArray[n2];
            postingArray[n2] = posting;
            if (postingArray[n].term.compareTo(postingArray[n5].term) > 0) {
                Posting posting2 = postingArray[n];
                postingArray[n] = postingArray[n5];
                postingArray[n5] = posting2;
            }
        }
        if ((n4 = n + 1) >= (n3 = n2 - 1)) {
            return;
        }
        Term term = postingArray[n5].term;
        while (true) {
            if (postingArray[n3].term.compareTo(term) > 0) {
                --n3;
                continue;
            }
            while (n4 < n3 && postingArray[n4].term.compareTo(term) <= 0) {
                ++n4;
            }
            if (n4 >= n3) break;
            Posting posting3 = postingArray[n4];
            postingArray[n4] = postingArray[n3];
            postingArray[n3] = posting3;
            --n3;
        }
        DocumentWriter.quickSort(postingArray, n, n4);
        DocumentWriter.quickSort(postingArray, n4 + 1, n2);
    }

    private final void writePostings(Posting[] postingArray, String string) throws IOException {
        TermInfosWriter termInfosWriter;
        OutputStream outputStream;
        block11: {
            OutputStream outputStream2 = null;
            outputStream = null;
            termInfosWriter = null;
            try {
                outputStream2 = this.directory.createFile(string + ".frq");
                outputStream = this.directory.createFile(string + ".prx");
                termInfosWriter = new TermInfosWriter(this.directory, string, this.fieldInfos);
                TermInfo termInfo = new TermInfo();
                int n = 0;
                while (n < postingArray.length) {
                    Posting posting = postingArray[n];
                    termInfo.set(1, outputStream2.getFilePointer(), outputStream.getFilePointer());
                    termInfosWriter.add(posting.term, termInfo);
                    int n2 = posting.freq;
                    if (n2 == 1) {
                        outputStream2.writeVInt(1);
                    } else {
                        outputStream2.writeVInt(0);
                        outputStream2.writeVInt(n2);
                    }
                    int n3 = 0;
                    int[] nArray = posting.positions;
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5 = nArray[n4];
                        outputStream.writeVInt(n5 - n3);
                        n3 = n5;
                        ++n4;
                    }
                    ++n;
                }
                Object var15_14 = null;
                if (outputStream2 == null) break block11;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (outputStream2 != null) {
                    outputStream2.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (termInfosWriter != null) {
                    termInfosWriter.close();
                }
                throw throwable;
            }
            outputStream2.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (termInfosWriter != null) {
            termInfosWriter.close();
        }
    }

    private final void writeNorms(Document document, String string) throws IOException {
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            Object var9_8;
            Field field = (Field)enumeration.nextElement();
            if (!field.isIndexed()) continue;
            int n = this.fieldInfos.fieldNumber(field.name());
            float f = this.fieldBoosts[n] * Similarity.normalizeLength(this.fieldLengths[n]);
            OutputStream outputStream = this.directory.createFile(string + ".f" + n);
            try {
                outputStream.writeByte(Similarity.encodeNorm(f));
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            {
            }
        }
    }
}

