/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;

final class FieldsReader {
    private FieldInfos fieldInfos;
    private InputStream fieldsStream;
    private InputStream indexStream;
    private int size;

    FieldsReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.fieldInfos = fieldInfos;
        this.fieldsStream = directory.openFile(string + ".fdt");
        this.indexStream = directory.openFile(string + ".fdx");
        this.size = (int)this.indexStream.length() / 8;
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n) throws IOException {
        this.indexStream.seek((long)n * 8L);
        long l = this.indexStream.readLong();
        this.fieldsStream.seek(l);
        Document document = new Document();
        int n2 = this.fieldsStream.readVInt();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.fieldsStream.readVInt();
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n4);
            byte by = this.fieldsStream.readByte();
            document.add(new Field(fieldInfo.name, this.fieldsStream.readString(), true, fieldInfo.isIndexed, (by & 1) != 0));
            ++n3;
        }
        return document;
    }
}

