/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentsReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;

public abstract class IndexReader {
    Directory directory;
    private Lock writeLock;

    protected IndexReader(Directory directory) {
        this.directory = directory;
    }

    public static IndexReader open(String string) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(string, false));
    }

    public static IndexReader open(File file) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(file, false));
    }

    public static IndexReader open(final Directory directory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            IndexReader indexReader = (IndexReader)new Lock.With(directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    SegmentInfos segmentInfos = new SegmentInfos();
                    segmentInfos.read(directory);
                    if (segmentInfos.size() == 1) {
                        return new SegmentReader(segmentInfos.info(0), true);
                    }
                    SegmentReader[] segmentReaderArray = new SegmentReader[segmentInfos.size()];
                    int n = 0;
                    while (n < segmentInfos.size()) {
                        segmentReaderArray[n] = new SegmentReader(segmentInfos.info(n), n == segmentInfos.size() - 1);
                        ++n;
                    }
                    return new SegmentsReader(directory, segmentReaderArray);
                }
            }.run();
            return indexReader;
        }
    }

    public static long lastModified(String string) throws IOException {
        return IndexReader.lastModified(new File(string));
    }

    public static long lastModified(File file) throws IOException {
        return FSDirectory.fileModified(file, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static boolean indexExists(String string) {
        return new File(string, "segments").exists();
    }

    public static boolean indexExists(File file) {
        return new File(file, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract byte[] norms(String var1) throws IOException;

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public final synchronized void delete(int n) throws IOException {
        if (this.writeLock == null) {
            Lock lock = this.directory.makeLock("write.lock");
            if (!lock.obtain()) {
                throw new IOException("Index locked for write: " + lock);
            }
            this.writeLock = lock;
        }
        this.doDelete(n);
    }

    abstract void doDelete(int var1) throws IOException;

    public final int delete(Term term) throws IOException {
        TermDocs termDocs = this.termDocs(term);
        if (termDocs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (termDocs.next()) {
                this.delete(termDocs.doc());
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            termDocs.close();
            throw throwable;
        }
        termDocs.close();
        return n;
    }

    public final synchronized void close() throws IOException {
        this.doClose();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    abstract void doClose() throws IOException;

    protected final void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.fileExists("write.lock");
    }

    public static boolean isLocked(String string) throws IOException {
        return new File(string, "write.lock").exists();
    }

    public static void unlock(Directory directory) throws IOException {
        directory.deleteFile("write.lock");
        directory.deleteFile("commit.lock");
    }
}

