/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.BitVector;

final class SegmentMerger {
    private Directory directory;
    private String segment;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private OutputStream freqOutput = null;
    private OutputStream proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private SegmentMergeQueue queue = null;
    private final TermInfo termInfo = new TermInfo();

    SegmentMerger(Directory directory, String string) {
        this.directory = directory;
        this.segment = string;
    }

    final void add(SegmentReader segmentReader) {
        this.readers.addElement(segmentReader);
    }

    final SegmentReader segmentReader(int n) {
        return (SegmentReader)this.readers.elementAt(n);
    }

    /*
     * Unable to fully structure code
     */
    final void merge() throws IOException {
        block4: {
            try {
                this.mergeFields();
                this.mergeTerms();
                this.mergeNorms();
                var2_1 = null;
                var3_3 = 0;
                ** while (var3_3 < this.readers.size())
            }
            catch (Throwable var1_7) {
                var2_2 = null;
                var3_4 = 0;
                ** while (var3_4 < this.readers.size())
            }
lbl-1000:
            // 1 sources

            {
                var4_5 = (SegmentReader)this.readers.elementAt(var3_3);
                var4_5.close();
                ++var3_3;
                continue;
lbl13:
                // 1 sources

                break block4;
            }
lbl-1000:
            // 1 sources

            {
                var4_6 = (SegmentReader)this.readers.elementAt(var3_4);
                var4_6.close();
                ++var3_4;
                continue;
            }
lbl23:
            // 1 sources

            throw var1_7;
        }
    }

    private final void mergeFields() throws IOException {
        Object object;
        this.fieldInfos = new FieldInfos();
        int n = 0;
        while (n < this.readers.size()) {
            object = (SegmentReader)this.readers.elementAt(n);
            this.fieldInfos.add(((SegmentReader)object).fieldInfos);
            ++n;
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        object = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int n2 = 0;
            while (n2 < this.readers.size()) {
                SegmentReader segmentReader = (SegmentReader)this.readers.elementAt(n2);
                BitVector bitVector = segmentReader.deletedDocs;
                int n3 = segmentReader.maxDoc();
                int n4 = 0;
                while (n4 < n3) {
                    if (bitVector == null || !bitVector.get(n4)) {
                        ((FieldsWriter)object).addDocument(segmentReader.document(n4));
                    }
                    ++n4;
                }
                ++n2;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ((FieldsWriter)object).close();
            throw throwable;
        }
        ((FieldsWriter)object).close();
    }

    private final void mergeTerms() throws IOException {
        block9: {
            try {
                this.freqOutput = this.directory.createFile(this.segment + ".frq");
                this.proxOutput = this.directory.createFile(this.segment + ".prx");
                this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos);
                this.mergeTermInfos();
                Object var2_1 = null;
                if (this.freqOutput == null) break block9;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.freqOutput != null) {
                    this.freqOutput.close();
                }
                if (this.proxOutput != null) {
                    this.proxOutput.close();
                }
                if (this.termInfosWriter != null) {
                    this.termInfosWriter.close();
                }
                if (this.queue != null) {
                    this.queue.close();
                }
                throw throwable;
            }
            this.freqOutput.close();
        }
        if (this.proxOutput != null) {
            this.proxOutput.close();
        }
        if (this.termInfosWriter != null) {
            this.termInfosWriter.close();
        }
        if (this.queue != null) {
            this.queue.close();
        }
    }

    private final void mergeTermInfos() throws IOException {
        Object object;
        Object object2;
        this.queue = new SegmentMergeQueue(this.readers.size());
        int n = 0;
        int n2 = 0;
        while (n2 < this.readers.size()) {
            object2 = (SegmentReader)this.readers.elementAt(n2);
            SegmentTermEnum segmentTermEnum = (SegmentTermEnum)((SegmentReader)object2).terms();
            object = new SegmentMergeInfo(n, segmentTermEnum, (SegmentReader)object2);
            n += ((SegmentReader)object2).numDocs();
            if (((SegmentMergeInfo)object).next()) {
                this.queue.put(object);
            } else {
                ((SegmentMergeInfo)object).close();
            }
            ++n2;
        }
        object2 = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int n3 = 0;
            object2[n3++] = (SegmentMergeInfo)this.queue.pop();
            object = ((SegmentMergeInfo)object2[0]).term;
            SegmentMergeInfo segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            while (segmentMergeInfo != null && ((Term)object).compareTo(segmentMergeInfo.term) == 0) {
                object2[n3++] = (SegmentMergeInfo)this.queue.pop();
                segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo((SegmentMergeInfo[])object2, n3);
            while (n3 > 0) {
                Object object3;
                if (((SegmentMergeInfo)(object3 = object2[--n3])).next()) {
                    this.queue.put(object3);
                    continue;
                }
                ((SegmentMergeInfo)object3).close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] segmentMergeInfoArray, int n) throws IOException {
        long l = this.freqOutput.getFilePointer();
        long l2 = this.proxOutput.getFilePointer();
        int n2 = this.appendPostings(segmentMergeInfoArray, n);
        if (n2 > 0) {
            this.termInfo.set(n2, l, l2);
            this.termInfosWriter.add(segmentMergeInfoArray[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] segmentMergeInfoArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            SegmentMergeInfo segmentMergeInfo = segmentMergeInfoArray[n4];
            SegmentTermPositions segmentTermPositions = segmentMergeInfo.postings;
            int n5 = segmentMergeInfo.base;
            int[] nArray = segmentMergeInfo.docMap;
            segmentMergeInfo.termEnum.termInfo(this.termInfo);
            segmentTermPositions.seek(this.termInfo);
            while (segmentTermPositions.next()) {
                int n6 = nArray == null ? n5 + segmentTermPositions.doc : n5 + nArray[segmentTermPositions.doc];
                if (n6 < n2) {
                    throw new IllegalStateException("docs out of order");
                }
                int n7 = n6 - n2 << 1;
                n2 = n6;
                int n8 = segmentTermPositions.freq;
                if (n8 == 1) {
                    this.freqOutput.writeVInt(n7 | 1);
                } else {
                    this.freqOutput.writeVInt(n7);
                    this.freqOutput.writeVInt(n8);
                }
                int n9 = 0;
                int n10 = 0;
                while (n10 < n8) {
                    int n11 = segmentTermPositions.nextPosition();
                    this.proxOutput.writeVInt(n11 - n9);
                    n9 = n11;
                    ++n10;
                }
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void mergeNorms() throws IOException {
        int n = 0;
        while (n < this.fieldInfos.size()) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n);
            if (fieldInfo.isIndexed) {
                Object var14_12;
                OutputStream outputStream = this.directory.createFile(this.segment + ".f" + n);
                try {
                    int n2 = 0;
                    while (true) {
                        block14: {
                            Object var12_11;
                            if (n2 >= this.readers.size()) {
                                var14_12 = null;
                                break;
                            }
                            SegmentReader segmentReader = (SegmentReader)this.readers.elementAt(n2);
                            BitVector bitVector = segmentReader.deletedDocs;
                            InputStream inputStream = segmentReader.normStream(fieldInfo.name);
                            int n3 = segmentReader.maxDoc();
                            try {
                                int n4 = 0;
                                while (true) {
                                    byte by;
                                    if (n4 >= n3) {
                                        var12_11 = null;
                                        if (inputStream == null) break block14;
                                        break;
                                    }
                                    byte by2 = by = inputStream != null ? inputStream.readByte() : (byte)0;
                                    if (bitVector == null || !bitVector.get(n4)) {
                                        outputStream.writeByte(by);
                                    }
                                    ++n4;
                                }
                            }
                            catch (Throwable throwable) {
                                var12_11 = null;
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                throw throwable;
                            }
                            inputStream.close();
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    var14_12 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
            }
            ++n;
        }
        return;
    }
}

