/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.BitVector;

final class SegmentReader
extends IndexReader {
    private boolean closeDirectory = false;
    private String segment;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    InputStream freqStream;
    InputStream proxStream;
    private Hashtable norms = new Hashtable();

    SegmentReader(SegmentInfo segmentInfo, boolean bl) throws IOException {
        this(segmentInfo);
        this.closeDirectory = bl;
    }

    SegmentReader(SegmentInfo segmentInfo) throws IOException {
        super(segmentInfo.dir);
        this.segment = segmentInfo.name;
        this.fieldInfos = new FieldInfos(this.directory, this.segment + ".fnm");
        this.fieldsReader = new FieldsReader(this.directory, this.segment, this.fieldInfos);
        this.tis = new TermInfosReader(this.directory, this.segment, this.fieldInfos);
        if (SegmentReader.hasDeletions(segmentInfo)) {
            this.deletedDocs = new BitVector(this.directory, this.segment + ".del");
        }
        this.freqStream = this.directory.openFile(this.segment + ".frq");
        this.proxStream = this.directory.openFile(this.segment + ".prx");
        this.openNorms();
    }

    final synchronized void doClose() throws IOException {
        if (this.deletedDocsDirty) {
            Directory directory = this.directory;
            synchronized (directory) {
                new Lock.With(this.directory.makeLock("commit.lock")){

                    public Object doBody() throws IOException {
                        SegmentReader.this.deletedDocs.write(SegmentReader.this.directory, SegmentReader.this.segment + ".tmp");
                        SegmentReader.this.directory.renameFile(SegmentReader.this.segment + ".tmp", SegmentReader.this.segment + ".del");
                        SegmentReader.this.directory.touchFile("segments");
                        return null;
                    }
                }.run();
            }
            this.deletedDocsDirty = false;
        }
        this.fieldsReader.close();
        this.tis.close();
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    static final boolean hasDeletions(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.dir.fileExists(segmentInfo.name + ".del");
    }

    final synchronized void doDelete(int n) throws IOException {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.deletedDocs.set(n);
    }

    final Vector files() throws IOException {
        Vector<String> vector = new Vector<String>(16);
        vector.addElement(this.segment + ".fnm");
        vector.addElement(this.segment + ".fdx");
        vector.addElement(this.segment + ".fdt");
        vector.addElement(this.segment + ".tii");
        vector.addElement(this.segment + ".tis");
        vector.addElement(this.segment + ".frq");
        vector.addElement(this.segment + ".prx");
        if (this.directory.fileExists(this.segment + ".del")) {
            vector.addElement(this.segment + ".del");
        }
        int n = 0;
        while (n < this.fieldInfos.size()) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n);
            if (fieldInfo.isIndexed) {
                vector.addElement(this.segment + ".f" + n);
            }
            ++n;
        }
        return vector;
    }

    public final TermEnum terms() throws IOException {
        return this.tis.terms();
    }

    public final TermEnum terms(Term term) throws IOException {
        return this.tis.terms(term);
    }

    public final synchronized Document document(int n) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n);
    }

    public final synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public final int docFreq(Term term) throws IOException {
        TermInfo termInfo = this.tis.get(term);
        if (termInfo != null) {
            return termInfo.docFreq;
        }
        return 0;
    }

    public final int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public final int maxDoc() {
        return this.fieldsReader.size();
    }

    public final byte[] norms(String string) throws IOException {
        Norm norm = (Norm)this.norms.get(string);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] byArray = new byte[this.maxDoc()];
            this.norms(string, byArray, 0);
            norm.bytes = byArray;
        }
        return norm.bytes;
    }

    final void norms(String string, byte[] byArray, int n) throws IOException {
        InputStream inputStream = this.normStream(string);
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.readBytes(byArray, n, this.maxDoc());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    final InputStream normStream(String string) throws IOException {
        Norm norm = (Norm)this.norms.get(string);
        if (norm == null) {
            return null;
        }
        InputStream inputStream = (InputStream)norm.in.clone();
        inputStream.seek(0L);
        return inputStream;
    }

    private final void openNorms() throws IOException {
        int n = 0;
        while (n < this.fieldInfos.size()) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n);
            if (fieldInfo.isIndexed) {
                this.norms.put(fieldInfo.name, new Norm(this.directory.openFile(this.segment + ".f" + fieldInfo.number)));
            }
            ++n;
        }
    }

    private final void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumeration = this.norms.elements();
            while (enumeration.hasMoreElements()) {
                Norm norm = (Norm)enumeration.nextElement();
                norm.in.close();
            }
        }
    }

    private static class Norm {
        public InputStream in;
        public byte[] bytes;

        public Norm(InputStream inputStream) {
            this.in = inputStream;
        }
    }
}

